<?php
/**
 * Holds components listing HTML.
 *
 * @package BuddyBossApp\Admin
 */

use BuddyBossApp\Components;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed direct

/**
 * Components class variable.
 *
 * @var $this \BuddyBossApp\Admin\Components
 */

$all_components      = $this->get_components();
$active_components   = Components::instance()->get_active_components();
$inactive_components = Components::instance()->get_inactive_components();
?>
<h3 class="screen-reader-text">
	<?php esc_html_e( 'Components list', 'buddyboss-app' ); ?>
</h3>

<form method="post" id="bbapp-admin-component-form">
	<div class="tablenav top">
		<div class="alignleft actions bulkactions">
			<label for="bulk-action-selector-top" class="screen-reader-text">
				<?php esc_html_e( 'Select bulk action', 'buddyboss-app' ); ?>
			</label>
			<select name="action1" id="bulk-action-selector-top">
				<option value=""><?php esc_html_e( 'Bulk actions', 'buddyboss-app' ); ?></option>
				<option value="active" class="hide-if-no-js"><?php esc_html_e( 'Activate', 'buddyboss-app' ); ?></option>
				<option value="inactive"><?php esc_html_e( 'Deactivate', 'buddyboss-app' ); ?></option>
			</select>
			<input type="submit" id="doaction" class="button action" name="bbapp-admin-component-submit" value="Apply">
		</div>
	</div>
	<table class="wp-list-table widefat plugins">
		<thead>
		<tr>
			<td id="cb" class="manage-column column-cb check-column">
				<input id="cb-select-all" type="checkbox" <?php checked( empty( $inactive_components ) ); ?>>
				<label class="screen-reader-text" for="cb-select-all">
					<?php
					esc_html_e( 'Enable or disable all optional components in bulk', 'buddyboss-app' );
					?>
				</label>
			</td>
			<th scope="col" id="name" class="manage-column column-title column-primary">
				<?php esc_html_e( 'Component', 'buddyboss-app' ); ?>
			</th>
			<th scope="col" id="description" class="manage-column column-description">
				<?php esc_html_e( 'Description', 'buddyboss-app' ); ?>
			</th>
		</tr>
		</thead>

		<tbody id="the-list">
		<?php
		if ( ! empty( $all_components ) ) :
			foreach ( $all_components as $component_id => $component ) :
				if ( true === $component['hide_from_list'] ) {
					continue;
				}

				$settings = $component['instance']->get_settings_link();
				$name     = $component['name'];
				?>

				<?php
				$class = '';

				if ( isset( $active_components[ esc_attr( $component_id ) ] ) ) {
					$class = 'active';
				}
				?>

				<tr id="<?php echo esc_attr( $name ); ?>"
					class="<?php echo esc_attr( $component_id ) . ' ' . esc_attr( $class ); ?>">
					<th scope="row" class="check-column">
						<?php if ( ! $component['required'] ) : ?>
							<input type="checkbox" id="<?php echo esc_attr( "bbapp_components[$component_id]" ); ?>" name="<?php echo esc_attr( "bbapp_components[$component_id]" ); ?>" value="1"<?php checked( isset( $active_components[ esc_attr( $component_id ) ] ) ); ?> /><label for="<?php echo esc_attr( "bbapp_components[$component_id]" ); ?>" class="screen-reader-text">
								<?php
								/* translators: %s: Component name. */
								printf( esc_html__( 'Select %s', 'buddyboss-app' ), esc_html( $name ) );
								?>
							</label>
						<?php endif; ?>
					</th>
					<td class="plugin-title column-primary">
						<label for="<?php echo esc_attr( "bbapp_components[$component_id]" ); ?>">
							<span aria-hidden="true"></span>
							<strong><?php echo esc_html( $name ); ?></strong>
						</label>
						<div class="row-actions visible">
							<?php if ( $component['required'] ) : ?>
								<span class="required">
										<?php esc_html_e( 'Required', 'buddyboss-app' ); ?>
									</span>
								<?php
							elseif ( ! $component['required'] ) :
								if ( isset( $active_components[ esc_attr( $component_id ) ] ) ) :
									$deactivate_nonce_url = wp_nonce_url(
										bbapp_get_super_admin_url(
											add_query_arg(
												array(
													'page' => 'bbapp-components',
													'bbapp_component' => $component_id,
													'do_action' => 'deactivate',
												),
												'admin.php'
											)
										),
										'bbapp-admin-component-activation'
									);
									?>
									<span class="deactivate">
										<a href="<?php echo esc_url( $deactivate_nonce_url ); ?>">
											<?php esc_html_e( 'Deactivate', 'buddyboss-app' ); ?>
										</a>
									</span>
																<?php
								else :
									$activate_nonce_url = wp_nonce_url(
										bbapp_get_super_admin_url(
											add_query_arg(
												array(
													'page' => 'bbapp-components',
													'bbapp_component' => $component_id,
													'do_action' => 'activate',
												),
												'admin.php'
											)
										),
										'bbapp-admin-component-activation'
									);
									?>
									<span class="activate">
											<a href="<?php echo esc_url( $activate_nonce_url ); ?>">
												<?php esc_html_e( 'Activate', 'buddyboss-app' ); ?>
											</a>
										</span>
								<?php endif; ?>
							<?php endif; ?>
							<?php if ( isset( $active_components[ esc_attr( $component_id ) ] ) && ! empty( $settings ) ) : ?>
								<span><?php esc_html_e( '|', 'buddyboss-app' ); ?></span>

								<span class="settings">
										<?php
										$i = 1;
										foreach ( $settings as $setting ) :
											$sap = '|';

											if ( count( $settings ) === $i ) {
												$sap = '';
											}
											?>
											<a href="<?php echo esc_url( $setting['link'] ); ?>">
											<?php
											echo wp_kses_post( $setting['label'] );
											$i ++;
											?>
										</a> <?php echo esc_html( $sap ); ?>
										<?php endforeach; ?>
									</span>
							<?php endif; ?>
						</div>
					</td>

					<td class="column-description desc">
						<div class="plugin-description">
							<p><?php echo wp_kses_post( $component['desc'] ); ?></p>
						</div>
					</td>
				</tr>
			<?php endforeach ?>
		<?php else : ?>
			<tr class="no-items">
				<td class="colspanchange" colspan="3"><?php esc_html_e( 'No components found.', 'buddyboss-app' ); ?></td>
			</tr>
		<?php endif; ?>
		</tbody>
		<tfoot>
		<tr>
			<td class="manage-column column-cb check-column">
				<input id="cb-select-all-2" type="checkbox" <?php checked( empty( $inactive_components ) ); ?>>
				<label class="screen-reader-text" for="cb-select-all-2">
					<?php
					/* translators: accessibility text */
					esc_html_e( 'Enable or disable all optional components in bulk', 'buddyboss-app' );
					?>
				</label></td>
			<th class="manage-column column-title column-primary"><?php esc_html_e( 'Component', 'buddyboss-app' ); ?></th>
			<th class="manage-column column-description"><?php esc_html_e( 'Description', 'buddyboss-app' ); ?></th>
		</tr>
		</tfoot>
	</table>

	<div class="tablenav bottom">
		<div class="alignleft actions bulkactions">
			<label for="bulk-action-selector-top" class="screen-reader-text">
				<?php esc_html_e( 'Select bulk action', 'buddyboss-app' ); ?>
			</label>
			<select name="action2" id="bulk-action-selector-top">
				<option value=""><?php esc_html_e( 'Bulk actions', 'buddyboss-app' ); ?></option>
				<option value="active" class="hide-if-no-js"><?php esc_html_e( 'Activate', 'buddyboss-app' ); ?></option>
				<option value="inactive"><?php esc_html_e( 'Deactivate', 'buddyboss-app' ); ?></option>
			</select>
			<input type="submit" id="doaction" class="button action" name="bbapp-admin-component-submit" value="Apply">
		</div>
	</div>

	<?php wp_nonce_field( 'bbapp-admin-component-bulk', 'bbapp-admin-component-bulk' ); ?>
</form>
