<?php
/**
 * Holds plugin update HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$update_required_plugins = \BuddyBossApp\Build::instance()->check_installed_plugin_update();
?>

<div class="bbapp-publish-block buddyboss-app-admin-card full-width">
	<p><?php esc_html_e( 'Please update the following plugins before requesting new builds:', 'buddyboss-app' ); ?></p>
	<?php
	if ( ! empty( $update_required_plugins ) ) {
		echo '<table class="required-plugin-update">';
		foreach ( $update_required_plugins as $plugin_item ) {
			/* translators: %s: plugin current version. */
			echo '<tr><th colspan="2">' . esc_html( $plugin_item['plugin_name'] ) . '</th></tr><tr class="bottom-spacing"><td>' . sprintf( esc_html__( 'Current Version: %s', 'buddyboss-app' ), esc_html( $plugin_item['current_version'] ) ) . '</td><td>' . sprintf( esc_html__( 'Latest Version: %s', 'buddyboss-app' ), esc_html( $plugin_item['latest_version'] ) ) . '</td></tr>';
		}
		echo '</table>';
	}
	?>
	<a href="<?php echo esc_url( admin_url( 'update-core.php' ) ); ?>" class="button button-primary">
		<?php esc_html_e( 'Update Plugins', 'buddyboss-app' ); ?>
	</a>
</div>
