<?php
/**
 * Holds plugin update HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$update_required_plugins = BuddyBossApp\Integrations\MemberPressCourses\Main::instance()->check_plugin_version_validation();
?>

<div class="bbapp-publish-block buddyboss-app-admin-card bbapp-mp-validation-block full-width">
	<p><?php esc_html_e( 'Please update the following plugins before requesting new builds:', 'buddyboss-app' ); ?></p>
	<?php
	if ( ! empty( $update_required_plugins ) ) {
		echo '<table class="required-plugin-update">';
		foreach ( $update_required_plugins as $plugin_item ) {
			echo '<tr>';
			echo sprintf(
				'<th colspan="2">%s %s</th>',
				esc_html( $plugin_item['plugin_name'] ),
				isset( $plugin_item['issue'] ) ? '(' . esc_html( $plugin_item['issue'] ) . ')' : ''
			);
			echo '</tr>';
			echo '<tr>';
			echo sprintf( '<td>%s %s</td>', esc_html__( 'Current Version:', 'buddyboss-app' ), esc_html( $plugin_item['current_version'] ) );
			echo sprintf( '<td>%s %s</td>', esc_html__( 'Required Version:', 'buddyboss-app' ), esc_html( $plugin_item['latest_version'] ) );
			echo '</tr>';
		}
		echo '</table>';
	}
	?>
	<a href="<?php echo esc_url( admin_url( 'update-core.php' ) ); ?>" class="button button-primary">
		<?php esc_html_e( 'Update Plugins', 'buddyboss-app' ); ?>
	</a>
</div>
