<?php
/**
 * Holds request build HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Build class.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */
?>
<div class="bbapp-build-container">
	<?php
	// return the steps view.
	require dirname( __FILE__ ) . '/build-steps-bar.php';

	if ( $this->get_current_step() === 'scope' ) {
		include dirname( __FILE__ ) . '/build-select-scope.php';
	}

	if ( $this->get_current_step() === 'review' ) {
		include dirname( __FILE__ ) . '/build-scope-review.php';
	}

	if ( $this->get_current_step() === 'status' ) {
		// About buddyboss publishing service Screens.
		$bbapp_get_latest_release_app = $this->bbapp_get_latest_release_app( array( 'ios', 'android' ), array( 'completed', 'new' ) );
		$ios_is_first_release_app     = false;
		$ios_is_new_release_app       = false;
		$android_is_first_release_app = false;
		$android_is_new_release_app   = false;

		if (
			! empty( $bbapp_get_latest_release_app ) &&
			( empty( $bbapp_get_latest_release_app['code'] ) || 'invalid_app' !== $bbapp_get_latest_release_app['code'] )
		) {
			foreach ( $bbapp_get_latest_release_app as $build ) {
				if ( 'completed' === $build['status'] && 'ios' === $build['type'] ) {
					$ios_is_first_release_app = true;
				}
				if ( 'new' === $build['status'] && 'ios' === $build['type'] ) {
					$ios_is_new_release_app = true;
				}
				if ( 'completed' === $build['status'] && 'android' === $build['type'] ) {
					$android_is_first_release_app = true;
				}
				if ( 'new' === $build['status'] && 'android' === $build['type'] ) {
					$android_is_new_release_app = true;
				}
			}
		}

		if ( ( false === $ios_is_first_release_app && false !== $ios_is_new_release_app ) || ( false === $android_is_first_release_app && false !== $android_is_new_release_app ) ) {
			add_action( 'admin_footer', array( $this, 'about_buddyboss_publishing_service_screen' ) );
		}
		include dirname( __FILE__ ) . '/build-status.php';
	}
	?>
</div>
