<?php
/**
 * Holds builds HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\Build;
use BuddyBossApp\ManageApp;

/**
 * Current class object.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */

$bbapp = \BuddyBossApp\ManageApp::instance()->get_app();

if ( empty( $bbapp ) || empty( $bbapp['verified'] ) ) {
	include dirname( __FILE__ ) . '/build-no-connection.php';

	return;
}

$tabs_types = array(
	'all'     => __( 'All', 'buddyboss-app' ),
	'ios'     => __( 'iOS', 'buddyboss-app' ),
	'android' => __( 'Android', 'buddyboss-app' ),
);

$tabs_envs = array(
	'live' => __( 'Release Apps', 'buddyboss-app' ),
	'dev'  => __( 'Test Apps', 'buddyboss-app' ),
);

$page_request  = isset( $_REQUEST['paged'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['paged'] ) ) : 1; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
$per_page_item = 12;
$builds        = Build::instance()->get_app_builds( '', '', false, '', $page_request, $per_page_item );
$build_link    = bbapp_get_super_admin_url( 'admin.php?page=bbapp-build' );

?>
<div class="wrap">
	<div class="flex">
		<h1 class="wp-heading-inline "><?php esc_html_e( 'Build History', 'buddyboss-app' ); ?></h1>
		<a class="page-title-action button button-primary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=request-build' ) ); ?>">
			<?php esc_html_e( 'Request Build', 'buddyboss-app' ); ?>
		</a>
		<a class="page-title-action button button-secondary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=request-build&step=status' ) ); ?>">
			<?php esc_html_e( 'Request Status', 'buddyboss-app' ); ?>
		</a>
	</div>
</div>

<div class="bbapp-build-container">
	<?php if ( true === \BuddyBossApp\ManageApp::instance()->is_app_disabled() ) { ?>
		<div class="buddyboss-app-admin-card full-width bbapp-is-disabled">
			<?php include dirname( __DIR__ ) . '/app-is-disabled.php'; ?>
		</div>
		<?php
		return;
	}
	if ( ! is_wp_error( $builds ) && ! empty( $builds ) && ! empty( $builds['data'] ) ) {
		?>
	<ul class="build-tab-navigation">
		<?php
		if ( ! empty( $tabs_types ) ) {
			foreach ( $tabs_types as $key => $tabs_type ) {
				echo '<li>' .
					'<label for="build-type-' . esc_attr( $key ) . '">' .
						'<input type="checkbox" value="' . esc_attr( $key ) . '" id="build-type-' . esc_attr( $key ) . '" name="build-type" ' . checked( 'all', $key, false ) . '/>' .
						'<span>' . esc_html( $tabs_type ) . '</span>' .
					'</label>' .
				'</li>';
			}
		}

		if ( ! empty( $tabs_envs ) ) {
			foreach ( $tabs_envs as $key => $tabs_env ) {
				echo '<li>' .
					'<label for="build-env-' . esc_attr( $key ) . '">' .
						'<input type="checkbox" value="' . esc_attr( $key ) . '" id="build-env-' . esc_attr( $key ) . '" name="build-env" />' .
						'<span>' . esc_html( $tabs_env ) . '</span>' .
					'</label>' .
				'</li>';
			}
		}

		?>
	</ul>
	<?php } ?>
	<div class="bbapp-builds-list <?php echo empty( $builds ) ? ' loading' : ''; ?>" data-app-id="<?php echo esc_attr( ManageApp::instance()->get_app_id() ); ?>">
		<?php
		if ( ! is_wp_error( $builds ) && ! empty( $builds ) && ! empty( $builds['data'] ) ) {
			if ( ! empty( $builds['data']['code'] ) && 'invalid_app' === $builds['data']['code'] ) {
				?>
                <p class="bbapp-no-builds"><?php echo wp_kses_post( $builds['data']['message'] ); ?></p>
				<?php
			} else {
				$headers = $builds['headers'];
				global $build_tile;
				foreach ( $builds['data'] as $build ) {
					$build_tile = $build;
					include dirname( __FILE__ ) . '/build-tile.php';
				}

				if ( ! empty( $headers['total'] ) ) {
					echo '<div class="pagination tablenav-pages">';
					$pagination = paginate_links(
						array(
							'base'      => add_query_arg( 'paged', '%#%' ),
							'format'    => '',
							'total'     => ceil( (int) $headers['total'] / (int) $per_page_item ),
							'current'   => (int) $page_request,
							'prev_text' => __( '&lsaquo;', 'buddyboss-app' ),
							'next_text' => __( '&rsaquo;', 'buddyboss-app' ),
							'mid_size'  => 1,
							'add_args'  => array(),
						)
					);

					if ( ! empty( $pagination ) ) {
						$pagination = str_replace( 'page-numbers', 'button page-numbers', $pagination );
					}

					echo wp_kses_post( str_replace( 'page-numbers current', 'page-numbers current disabled', $pagination ) );
					echo '</div>';
				}
			}
		} elseif ( is_wp_error( $builds ) ) {
			?>
			<p class="bbapp-no-builds"><?php echo wp_kses_post( $builds->get_error_message( $builds->get_error_code() ) ); ?></p>
			<?php
		} else {
			?>
			<p class="bbapp-no-builds">
				<?php echo sprintf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'You haven\'t created any builds yet.', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=request-build' ) ), esc_html__( 'Request a build', 'buddyboss-app' ), esc_html__( 'to create your first one.', 'buddyboss-app' ) ); ?>
			</p>
			<?php
		}
		?>
	</div>
</div>

<script>
	jQuery( document ).ready( function() {
		jQuery( document ).on( 'click', '.bbapp-build-failed', function( e ) {
			e.preventDefault();
			jQuery( '.bbapp-lite-dialog' ).hide();
			jQuery( this ).next( '.bbapp-lite-dialog' ).show();
		} );
	} );
</script>
