<?php
/**
 * Holds build tile HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use BuddyBossApp\Build;

global $build_tile;

if ( empty( $build_tile ) ) {
	return;
}

$build      = $build_tile;
$build_type = $build['type'];

// Added Minimum version support.
$get_min_version_code_support              = Build::instance()->get_build_min_version_code_support( $build_type );
$min_version_code_support_toggle_link      = Build::instance()->get_build_min_version_code_toggle_link( $build_type, $build['build_version_code'] );
$ios_buddyboss_publishing_service_hide     = \BuddyBossApp\Admin\Publish\Publish::instance()->is_publishing_services_already_requested( 'ios' );
$android_buddyboss_publishing_service_hide = \BuddyBossApp\Admin\Publish\Publish::instance()->is_publishing_services_already_requested( 'android' );
$build_time                                = $build['time'];

if ( 'completed' === $build['status'] ) {
	$build_time = $build['time_modified'];
}

if ( '#' === $build['build_secondary_url'] ) {
	unset( $build['build_secondary_url'] );
}

if ( '#' === $build['build_fingerprint_url'] ) {
	unset( $build['build_fingerprint_url'] );
}
?>
	<div class="bbapp-build-item" data-build-id="<?php echo( ! empty( $build['id'] ) ? esc_attr( $build['id'] ) : 0 ); ?>">
		<div class="bbapp-build-item-header">
			<?php
			if ( $build['id'] ) {
				?>
				<h2><?php echo esc_html__( 'Build ', 'buddyboss-app' ) . ' #' . esc_html( $build['id'] ); ?></h2>
				<?php
			}
			if ( isset( $build['status'] ) && 'new' === $build['status'] ) {
				?>
				<span class="bbapp-status new"><?php esc_html_e( 'New', 'buddyboss-app' ); ?></span>
			<?php } elseif ( 'running' === $build['status'] ) { ?>
				<span class="bbapp-status running"><?php esc_html_e( 'Generating', 'buddyboss-app' ); ?></span>
			<?php } elseif ( 'failed' === $build['status'] ) { ?>
				<span class="bbapp-status failed"><?php esc_html_e( 'Failed', 'buddyboss-app' ); ?></span>
			<?php } elseif ( 'completed' === $build['status'] ) { ?>
				<span class="bbapp-status completed"><?php esc_html_e( 'Completed', 'buddyboss-app' ); ?></span>
			<?php } elseif ( 'cancelled' === $build['status'] ) { ?>
				<span class="bbapp-status cancelled"><?php esc_html_e( 'Cancelled', 'buddyboss-app' ); ?></span>
			<?php } ?>
		</div>
		<div class="type flex align-center <?php echo ( 'ios' === $build['type'] ) ? 'type--ios' : 'type--android'; ?>">
			<span class="type--icon">
				<?php if ( 'ios' === $build['type'] ) { ?>
					<i class='bb-icon-f bb-icon-brand-apple'></i>
				<?php } else { ?>
					<i class='bb-icon-f bb-icon-brand-android'></i>
				<?php } ?>
			</span>
			<span class="type--platform">
				<?php
				if ( 'ios' === $build['type'] ) {
					esc_html_e( 'iOS', 'buddyboss-app' );
				} else {
					esc_html_e( 'Android', 'buddyboss-app' );
				}
				?>
			</span>
		</div>
		<div class="info">
			<strong><?php esc_html_e( 'Build Type', 'buddyboss-app' ); ?></strong>
			<span>
				<?php
				if ( 'live' === $build['env'] ) {
					esc_html_e( 'Release App', 'buddyboss-app' );
				} else {
					esc_html_e( 'Test App', 'buddyboss-app' );
				}
				?>
			</span>
		</div>

		<div class="info">
			<?php if ( ! empty( $build['status'] ) && 'completed' === $build['status'] ) { ?>
				<strong><?php esc_html_e( 'Date Generated', 'buddyboss-app' ); ?></strong>
			<?php } else { ?>
				<strong><?php esc_html_e( 'Date Requested', 'buddyboss-app' ); ?></strong>
			<?php } ?>
			<?php
			$date_format = get_option( 'date_format' );
			$date_format = ! empty( $date_format ) ? $date_format : 'F j, Y';
			$time_format = get_option( 'time_format' );
			$time_format = ! empty( $time_format ) ? $time_format : 'g:i a';
			$_date       = gmdate( 'd-m-Y H:i:s', $build_time );
			?>
			<span>
				<?php echo sprintf( '%1$s %2$s', esc_html( get_date_from_gmt( $_date, $date_format ) ), esc_html( get_date_from_gmt( $_date, $time_format ) ) ); ?>
			</span>
		</div>

		<div class="info">
			<strong><?php esc_html_e( 'Build Version', 'buddyboss-app' ); ?></strong>
			<span>
				<?php
				if ( isset( $build['build_version'] ) && $build['build_version'] ) {
					printf( '%1$s%2$s', esc_html( $build['build_version'] ), ( $build['build_version_code'] ? ' (' . esc_html( $build['build_version_code'] ) . ')' : '' ) );
				} else {
					esc_html_e( 'N/A', 'buddyboss-app' );
				}
				?>
			</span>
		</div>
		<div class="core-app-version info">
			<strong><?php esc_html_e( 'Core App Version', 'buddyboss-app' ); ?></strong>
			<span><?php echo ! empty( $build['app_core_version'] ) ? esc_html( $build['app_core_version'] ) : esc_html__( 'N/A', 'buddyboss-app' ); ?></span>
		</div>

        <div class="custom-repo info" <?php if ( empty( $build['repo_branch'] ) ) { ?>style="height: 21px;"<?php } ?>>
            <?php if ( ! empty( $build['repo_branch'] ) ) { ?>
                <strong>
                    <?php esc_html_e( 'Custom Git Branch', 'buddyboss-app' ); ?>
                </strong>
                <span>
                    <?php echo esc_html( $build['repo_branch'] ); ?>
                </span>
			<?php } ?>
        </div>

		<div class="bbapp-download info">
			<?php if ( 'completed' === $build['status'] && $build['build_url'] && 'live' === $build['env'] ) : ?>
				<div class="bbapp-dropdown-container">
					<div class="bbapp-dropdown-ctrl">
						<?php if ( 'ios' === $build_type ) { ?>
							<?php if ( false === $ios_buddyboss_publishing_service_hide && ! bbapp_is_sandbox_enabled() ) { ?>
								<a class="button" href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-publish&setting=ios' ) ); ?>">
									<?php esc_html_e( 'Submit for Publishing', 'buddyboss-app' ); ?>
								</a>
							<?php } elseif ( ! bbapp_is_sandbox_enabled() ) { ?>
								<a class="button" href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build-upload&setting=request-ios&build_id=' . $build['id'] ) ); ?>">
									<?php esc_html_e( 'Upload to App Store Connect', 'buddyboss-app' ); ?>
								</a>
							<?php } ?>
							<?php if ( ! bbapp_is_sandbox_enabled() ) { ?>
								<span class="bbapp-dropdown-caret"><i class="bbapp-arrow bbapp-arrow--down"></i></span>
							<?php } else { ?>
								<a href="#" class="button--build-tab button--build-modal bbapp-button-download-build button inactive" data-fancybox data-src="#download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Download IPA File', 'buddyboss-app' ); ?>
								</a>
							<?php } ?>
						<?php } elseif ( 'android' === $build_type ) { ?>
							<?php if ( false === $android_buddyboss_publishing_service_hide && ! bbapp_is_sandbox_enabled() ) { ?>
								<a class="button" href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-publish&setting=android' ) ); ?>">
									<?php esc_html_e( 'Submit for Publishing', 'buddyboss-app' ); ?>
								</a>
							<?php } elseif ( ! bbapp_is_sandbox_enabled() ) { ?>
								<a class="button" href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build-upload&setting=request-android&build_id=' . $build['id'] ) ); ?>">
									<?php esc_html_e( 'Upload to Google Play Console', 'buddyboss-app' ); ?>
								</a>
							<?php } ?>
							<?php if ( bbapp_is_sandbox_enabled() ) { ?>
								<a href="#" class="button button--build-tab button--build-modal" data-fancybox data-src="#install-build-device-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Install on Android Device', 'buddyboss-app' ); ?>
								</a>
							<?php } ?>
							<span class="bbapp-dropdown-caret"><i class="bbapp-arrow bbapp-arrow--down"></i></span>
						<?php } ?>
					</div>
					<div class="bbapp-dropdown-tab-container">
						<div class="bbapp-dropdown-tab">
							<?php if ( 'ios' === $build_type ) { ?>
								<?php if ( false === $ios_buddyboss_publishing_service_hide && ! bbapp_is_sandbox_enabled() ) { ?>
									<a class="button--build-tab " href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build-upload&setting=request-ios&build_id=' . $build['id'] ) ); ?>">
										<?php esc_html_e( 'Upload to App Store Connect', 'buddyboss-app' ); ?>
									</a>
								<?php } ?>
								<a href="#" class="button--build-tab button--build-modal bbapp-button-download-build" data-fancybox data-src="#download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Download IPA File', 'buddyboss-app' ); ?>
								</a>
							<?php } elseif ( 'android' === $build_type ) { ?>
								<?php if ( false === $android_buddyboss_publishing_service_hide && ! bbapp_is_sandbox_enabled() ) { ?>
									<a class="button--build-tab " href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build-upload&setting=request-android&build_id=' . $build['id'] ) ); ?>">
										<?php esc_html_e( 'Upload to Google Play Console', 'buddyboss-app' ); ?>
									</a>
								<?php } ?>
								<?php if ( ! bbapp_is_sandbox_enabled() ) { ?>
									<a href="#" class="button--build-tab button--build-modal" data-fancybox data-src="#install-build-device-<?php echo esc_attr( $build['id'] ); ?>">
										<?php esc_html_e( 'Install on Android Device', 'buddyboss-app' ); ?>
									</a>
								<?php } ?>
								<?php if ( ! empty( $build['build_secondary_url'] ) ) : ?>
									<a href="#" class="button--build-tab button--build-modal bbapp-button-download-build" data-fancybox data-src="#download-aab-release-<?php echo esc_attr( $build['id'] ); ?>">
										<?php esc_html_e( 'Download AAB File', 'buddyboss-app' ); ?>
									</a>
								<?php endif; ?>
                                <a href="#" class="button--build-tab button--build-modal bbapp-button-download-build" data-fancybox data-src="#download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Download APK File', 'buddyboss-app' ); ?>
                                </a>
								<?php if ( ! empty( $build['build_fingerprint_url'] ) ) : ?>
                                    <a href="<?php echo esc_url( $build['build_fingerprint_url'] ); ?>" class="button--build-tab" download="<?php esc_attr_e('Certificate', 'buddyboss-app'); ?>">
										<?php esc_html_e( 'Download SHA-1 Certificate Fingerprint', 'buddyboss-app' ); ?>
                                    </a>
								<?php endif; ?>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php elseif ( 'dev' === $build['env'] && 'completed' === $build['status'] ) : ?>
				<?php if ( 'ios' === $build['type'] ) : ?>
					<?php
					$connected         = \BuddyBossApp\AppStores\Apple::instance()->is_connected();
					$auto_provisioning = true === (bool) \BuddyBossApp\Admin\Configure::instance()->option( 'publish.ios.provisioning_profile_automatic' );
					$devices           = \BuddyBossApp\AppStores\Apple::instance()->get_local_devices();
					?>
				<?php endif; ?>
				<div class="bbapp-dropdown-container">
					<div class="bbapp-dropdown-ctrl">
						<?php if ( 'ios' === $build_type ) { ?>
							<a href="#" class="button button--build-modal" data-fancybox data-src="#install-build-device-<?php echo esc_attr( $build['id'] ); ?>">
								<?php esc_html_e( 'Install on iOS Device', 'buddyboss-app' ); ?>
							</a>
						<?php } elseif ( 'android' === $build_type ) { ?>
							<a href="#" class="button button--build-modal" data-fancybox data-src="#install-build-device-<?php echo esc_attr( $build['id'] ); ?>">
								<?php esc_html_e( 'Install on Android Device', 'buddyboss-app' ); ?>
							</a>
						<?php } ?>
						<span class="bbapp-dropdown-caret"><i class="bbapp-arrow bbapp-arrow--down"></i></span>
					</div>
					<div class="bbapp-dropdown-tab-container">
						<div class="bbapp-dropdown-tab">
							<?php if ( 'ios' === $build_type ) { ?>
								<a href="#" class="button--build-tab button--build-modal bbapp-button-download-build" data-fancybox data-src="#download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Download IPA File', 'buddyboss-app' ); ?>
								</a>
							<?php } elseif ( 'android' === $build_type ) { ?>
								<a href="#" class="button--build-tab button--build-modal bbapp-button-download-build" data-fancybox data-src="#download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>">
									<?php esc_html_e( 'Download APK File', 'buddyboss-app' ); ?>
								</a>
								<?php if ( ! empty( $build['build_fingerprint_url'] ) ) : ?>
                                    <a href="<?php echo esc_url( $build['build_fingerprint_url'] ); ?>" class="button--build-tab" download="<?php esc_attr_e('Certificate', 'buddyboss-app'); ?>">
										<?php esc_html_e( 'Download SHA-1 Certificate Fingerprint', 'buddyboss-app' ); ?>
                                    </a>
								<?php endif; ?>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php elseif ( 'running' === $build['status'] || 'new' === $build['status'] ) : ?>
				<a href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build&setting=request-build&step=status' ) ); ?>" class="button">
					<?php esc_html_e( 'Check Status Now', 'buddyboss-app' ); ?>
				</a>
			<?php elseif ( 'failed' === $build['status'] ) : ?>
				<a class="button bbapp-build-failed" href="javascript:;">
					<?php esc_html_e( 'More Information', 'buddyboss-app' ); ?>
				</a>
				<div class="bbapp-lite-dialog" style="display: none">
					<div class="overlay"></div>
					<div class="bbapp-dialog  bbapp-dialog--install bbapp-dialog--<?php echo ( 'ios' === $build['type'] ) ? 'ios' : 'android'; ?> ?>">
						<h2>
							<?php
							/* translators: %s: Build id. */
							echo sprintf( esc_html__( 'Build #%s', 'buddyboss-app' ), esc_html( $build['id'] ) );
							?>
						</h2>
						<p><?php esc_html_e( 'We were unable to complete this build request for the following reason(s):', 'buddyboss-app' ); ?></p>

						<?php
						if ( ! empty( $build['error_message'] ) ) {
							$error_messages       = array_column( $build['error_message'], 'message' );
							$error_messages       = array_filter( $error_messages );
							$custom_error_message = '';
							if ( ! empty( $error_messages ) ) {
								foreach ( $build['error_message'] as $error_msg_item ) {
									$error_msg_item_code    = ! empty( $error_msg_item['code'] ) ? esc_html__( 'Error #', 'buddyboss-app' ) . $error_msg_item['code'] . '<br/>' : '';
									$error_msg_item_message = ! empty( $error_msg_item['message'] ) ? $error_msg_item['message'] : '';
									echo sprintf( '<p class="bbapp-notice-box">%1$s %2$s</p>', wp_kses_post( $error_msg_item_code ), esc_html( $error_msg_item_message ) );
									if ( ( ! empty( $error_msg_item['code'] ) && 'E019' === $error_msg_item['code'] ) ) {
										/* translators: %s: Article link. */
										$custom_error_message = sprintf( __( 'Follow the documentation for <a target="_blank" href="%s">updating your custom development repo</a> to resolve this issue.', 'buddyboss-app' ), esc_url( 'https://www.buddyboss.com/resources/dev-docs/app-development/extending-the-buddyboss-app/installing-native-libraries/' ) );
									}
								}

								if ( ! empty( $custom_error_message ) ) {
									echo wp_kses_post( $custom_error_message );
								}
							} else {
								?>
								<p class="bbapp-notice-box"><?php esc_html_e( 'Unknown error.', 'buddyboss-app' ); ?></p>
							<?php } ?>
						<?php } else { ?>
							<p class="bbapp-notice-box"><?php esc_html_e( 'Unknown error.', 'buddyboss-app' ); ?></p>
						<?php } ?>
						<a href="#" class="close"><?php echo esc_attr_x( 'Close', 'close app install qr', 'buddyboss-app' ); ?></a>
					</div>
				</div>
			<?php else : ?>
				<span class="button inactive"><?php esc_html_e( 'No Build Available', 'buddyboss-app' ); ?></span>
			<?php endif; ?>
		</div>

		<?php /*Build Modals*/ ?>
		<div id='download-ipa-apk-release-<?php echo esc_attr( $build['id'] ); ?>' class="download-build-modal-block download-ipa-apk-release-block hidden">
			<div class="download-build-modal-block__heading">
				<h2>
					<?php if ( 'ios' === $build_type ) { ?>
						<?php esc_html_e( 'Download IPA File', 'buddyboss-app' ); ?>
						<span>
						<?php
						if ( 'live' === $build['env'] ) {
							esc_html_e( 'iOS Release App', 'buddyboss-app' );
						} else {
							esc_html_e( 'iOS Test App', 'buddyboss-app' );
						}
						?>
						</span>
					<?php } elseif ( 'android' === $build_type ) { ?>
						<?php esc_html_e( 'Download APK File', 'buddyboss-app' ); ?>
					<?php } ?>
				</h2>
			</div>
			<div class="download-build-modal-block__body">
				<?php
				if ( 'ios' === $build_type ) {
					if ( 'live' === $build['env'] ) {
						?>
						<p><?php esc_html_e( 'iOS Release App IPA files cannot be installed directly on iOS devices.', 'buddyboss-app' ); ?></p>
						<p><?php echo wp_kses_post( __( 'To install this build via TestFlight, or release it on the Apple App Store, use the <strong>Upload to App Store Connect</strong> option.', 'buddyboss-app' ) ); ?></p>
						<p><?php esc_html_e( 'Alternatively, you can download the file to upload through your own development tools.', 'buddyboss-app' ); ?></p>
					<?php } else { ?>
						<p><?php echo wp_kses_post( __( 'iOS Test App IPA files cannot be opened directly on iOS devices, so to install this build, use the <strong>Install on iOS Device</strong> option.', 'buddyboss-app' ) ); ?></p>
						<p><?php esc_html_e( 'Alternatively, you can download the file to install to third-party tools such as BrowserStack and Google Firebase Test Lab.', 'buddyboss-app' ); ?></p>
					<?php } ?>
				<?php } elseif ( 'android' === $build_type ) { ?>
					<p><?php echo wp_kses_post( __( 'To install this build to your device, use the <strong>Install on Android Device</strong> option or download this file and open it on your Android device.', 'buddyboss-app' ) ); ?></p>
					<p><?php esc_html_e( 'If you published your app prior to August 2021, you can continue to upload APK files to the Google Play Store, although we recommend using the AAB file format.', 'buddyboss-app' ); ?></p>
				<?php } ?>
			</div>
			<div class="download-build-modal-block__footer">
				<a class="button--build-tab button button-primary" href="<?php echo esc_url( $build['build_url'] ); ?>">
					<?php esc_html_e( 'Download', 'buddyboss-app' ); ?>
				</a>
			</div>
		</div>

		<?php if ( ! empty( $build['build_secondary_url'] ) ) : ?>
			<div id='download-aab-release-<?php echo esc_attr( $build['id'] ); ?>' class="download-build-modal-block download-aab-release-block hidden">
				<div class="download-build-modal-block__heading">
					<h2>
						<?php esc_html_e( 'Download AAB File', 'buddyboss-app' ); ?>
					</h2>
				</div>
				<div class="download-build-modal-block__body">
					<p><?php esc_html_e( 'Upload this AAB file directly into a release on the Google Play Store to distribute it to other users.', 'buddyboss-app' ); ?></p>
					<p><?php esc_html_e( 'Since August 2021, all new Android apps uploaded to the Google Play Store must use the AAB file format.', 'buddyboss-app' ); ?></p>
				</div>
				<div class="download-build-modal-block__footer">
					<a class="button--build-tab button button-primary" href="<?php echo esc_url( $build['build_secondary_url'] ); ?>">
						<?php esc_html_e( 'Download', 'buddyboss-app' ); ?>
					</a>
				</div>
			</div>
		<?php endif; ?>

		<div id='install-build-device-<?php echo esc_attr( $build['id'] ); ?>' class="download-build-modal-block install-android-device-block hidden">
			<div class="download-build-modal-block__heading">
				<h2>
					<?php if ( 'ios' === $build_type ) { ?>
						<?php esc_html_e( 'Install on iOS Device', 'buddyboss-app' ); ?>
					<?php } elseif ( 'android' === $build_type ) { ?>
						<?php esc_html_e( 'Install on Android Device', 'buddyboss-app' ); ?>
					<?php } ?>
				</h2>
			</div>
			<div class="download-build-modal-block__body">
				<div class="bbapp-install-qr-body flex">
					<?php
					$install_url = \BuddyBossApp\Builds\Installer::instance()->get_installer_link( $build['id'] );
					?>
					<img src="<?php echo wp_kses_data( ( BuddyBossApp\Library\Composer::instance()->qr_code_instance()->qr_code() )->render( $install_url ) ); ?>" alt="<?php esc_attr_e( 'QR Code', 'buddyboss-app' ); ?>"/>
					<div class="content-box">
						<?php if ( 'ios' === $build['type'] ) { ?>
							<p><?php esc_html_e( 'To install this test app build on your iOS device, scan the QR code using the camera app and follow the instructions.', 'buddyboss-app' ); ?></p>
						<?php } else { ?>
							<p><?php esc_html_e( 'To install this test app build on your Android device, scan the QR code using the camera app and follow the instructions.', 'buddyboss-app' ); ?></p>
						<?php } ?>
					</div>
				</div>
				<?php if ( 'ios' === $build['type'] ) { ?>
					<div class="ios-instruction bbapp-notice-box">
						<h3 style="margin-top: 0;"><?php esc_html_e( 'Installation Instructions', 'buddyboss-app' ); ?></h3>
						<p><?php esc_html_e( 'In order to install this build on your iOS device, it must have been generated using a Test App Provisioning Profile that contains your device\'s UDID number.', 'buddyboss-app' ); ?></p>
						<?php
						$url      = bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios_devices' );
						$url_text = esc_html__( 'iOS Devices', 'buddyboss-app' );
						$html     = sprintf( '<a href="%1$s">%2$s</a>', esc_url( $url ), esc_html( $url_text ) );
						echo sprintf( '%1$s %2$s %3$s', esc_html__( 'If you are generating profiles automatically, you can register your device on the', 'buddyboss-app' ), wp_kses_post( $html ), esc_html__( ' page. Otherwise, please register your device in your Apple Developer account and upload a new provisioning profile.', 'buddyboss-app' ) );
						?>
						<p><?php esc_html_e( 'Reminder: You will require a new build every time you change your registered devices or provisioning profiles.', 'buddyboss-app' ); ?></p>
						<a class="button button-primary" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=122270' ) ); ?>" target="_blank">
							<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
						</a>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
<?php
