<?php
/**
 * Holds buidls steps HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Build class.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */
?>
	<h1 class="wp-heading-inline wp-heading-inline--local">
		<?php esc_html_e( 'Request Build', 'buddyboss-app' ); ?>
	</h1>
	<a class="page-title-action" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ); ?>">
		<?php esc_html_e( 'Build History', 'buddyboss-app' ); ?>
	</a>
<?php

if ( 'scope' === $this->get_current_step() ) {
	?>
	<div class="bbapp-step bbapp-step--local">
		<li class="active"><?php printf( ' <span class="%s">%s</span>', esc_attr( 'bb-step-count' ), esc_html__( 'Step 1:', 'buddyboss-app' ) ); ?><?php esc_html_e( 'Build Settings', 'buddyboss-app' ); ?></li>
		<li><?php printf( ' <span class="%s">%s</span>', esc_attr( 'bb-step-count' ), esc_html__( 'Step 2:', 'buddyboss-app' ) ); ?><?php esc_html_e( 'Review Information', 'buddyboss-app' ); ?></li>
	</div>
	<?php
}

if ( 'review' === $this->get_current_step() ) {
	?>
	<div class="bbapp-step bbapp-step--local">
		<li class="done"><?php printf( ' <span class="%s">%s</span>', esc_attr( 'bb-step-count' ), esc_html__( 'Step 1:', 'buddyboss-app' ) ); ?><?php esc_html_e( 'Build Settings', 'buddyboss-app' ); ?></li>
		<li class="active"><?php printf( ' <span class="%s">%s</span>', esc_attr( 'bb-step-count' ), esc_html__( 'Step 2:', 'buddyboss-app' ) ); ?><?php esc_html_e( 'Review Information', 'buddyboss-app' ); ?></li>
	</div>
	<?php
}
