<?php
/**
 * Build Status.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Build class.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */

$build_option    = \BuddyBossApp\Build::instance()->get_build_options();
$build_requested = isset( $build_option['build_requested'] ) ? $build_option['build_requested'] : array();
$env             = ( ! empty( $_GET['app_env'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['app_env'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

$platforms = array(
	'android' => __( 'Android', 'buddyboss-app' ),
	'ios'     => __( 'iOS', 'buddyboss-app' ),
);

$platform_icon = array(
	'ios'     => '<svg width="25" height="25" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 150 150">
					<g fill="#000000">
						<path d="M78.8 37.539h.626a34.425 34.425 0 0027.49-34.362A3.124 3.124 0 00105.727.74a3.061 3.061 0 00-2.561-.687 34.425 34.425 0 00-27.49 34.425A3.124 3.124 0 0078.8 37.6z"/>
						<path d="M136.092 103.327a26.865 26.865 0 01-16.681-24.99 27.865 27.865 0 0113.807-24.054 3.124 3.124 0 00.75-4.811 37.486 37.486 0 00-27.053-11.933 38.236 38.236 0 00-14.62 3.249 34.862 34.862 0 01-13.494 2.999 34.862 34.862 0 01-13.495-3 38.236 38.236 0 00-14.62-3.248c-3.81 0-37.486 1.25-37.486 43.734 0 34.737 23.741 68.724 37.486 68.724a41.422 41.422 0 0017.556-3.686 25.616 25.616 0 0110.559-2.561 25.616 25.616 0 0110.558 2.561 41.422 41.422 0 0017.556 3.686c11.184 0 24.366-22.054 31.239-42.734a3.124 3.124 0 00-2.062-3.936z"/>
					</g>
				</svg>',
	'android' => '<svg width="25" height="25" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 150 150">
					<path d="M111.594 54.408l12.443-21.555a2.528 2.528 0 00-.915-3.445 2.495 2.495 0 00-3.429.914l-12.606 21.832C97.469 47.762 86.643 45.312 75 45.312c-11.643 0-22.469 2.45-32.087 6.842L30.307 30.322a2.514 2.514 0 00-3.445-.914 2.514 2.514 0 00-.915 3.445L38.39 54.408C16.933 66.034 2.4 87.752 0 113.176h150c-2.4-25.424-16.933-47.142-38.406-58.768zM40.562 92.112a6.29 6.29 0 01-6.287-6.287 6.29 6.29 0 016.287-6.287 6.29 6.29 0 016.286 6.287c.017 3.462-2.808 6.287-6.286 6.287zm68.86 0a6.29 6.29 0 01-6.287-6.287 6.29 6.29 0 016.287-6.287 6.29 6.29 0 016.287 6.287c.016 3.462-2.809 6.287-6.287 6.287z" class="st0" fill="#000000"/>
				</svg>',
);
?>

<div class="bbapp-build-container">
	<?php if ( true === \BuddyBossApp\ManageApp::instance()->is_app_disabled() ) { ?>
		<div class="buddyboss-app-admin-card full-width bbapp-is-disabled">
			<?php include dirname( __DIR__ ) . '/app-is-disabled.php'; ?>
		</div>
		<?php
		return;
	}

	$build_infomation = array();

	foreach ( $platforms as $platform => $platform_label ) {
		$is_failed      = false;
		$failed_message = '';
		$is_sent        = false;
		$is_not_sent    = false;
		$build_status   = '';

		if ( isset( $build_requested[ $platform ] ) ) {
			if ( $build_requested[ $platform ]['success'] ) {
				$build_status                                 = $this->get_build_status( $build_requested[ $platform ]['build_id'] );
				$build_requested[ $platform ]['build_status'] = $build_status;
				$is_sent                                      = true;

				if ( ! empty( $build_status ) && in_array( $build_status, array( 'new', 'running' ), true ) ) {
					if ( 'new' === $build_status ) {
						$build_title = sprintf(
								/* translators: %s: Platform name. */
							__( 'Your %s build has been submitted.', 'buddyboss-app' ),
							wp_kses_post( $platform_label )
							/* translators: %s: Build request number. */
						) . '<span class="build-id">(' . sprintf( __( 'Ref: #br-%s', 'buddyboss-app' ), esc_html( $build_requested[ $platform ]['build_id'] ) ) . ')</span>';
					} elseif ( 'running' === $build_status ) {
						$build_title = sprintf(
								/* translators: %s: Platform name. */
							__( 'Your %s build is processing.', 'buddyboss-app' ),
							wp_kses_post( $platform_label )
							/* translators: %s: Build request number. */
						) . '<span class="build-id">(' . sprintf( __( 'Ref: #br-%s', 'buddyboss-app' ), esc_html( $build_requested[ $platform ]['build_id'] ) ) . ')</span>';
					}
				}
			}

			if ( ! $build_requested[ $platform ]['success'] ) {
				if ( 'build_limit_error' === $build_requested[ $platform ]['error_code'] ) {
					$build_title = __( 'You have reached your monthly build limit', 'buddyboss-app' );
					/* translators: %s: Platform label. */
					$failed_message = sprintf( __( 'Sorry, we\'re unable to submit this request for a new %s build as you have reached your build limit for this month. To discuss increasing this month\'s build limit, please contact BuddyBoss support.', 'buddyboss-app' ), esc_html( $platform_label ) );
				} else {
					$build_title    = __( 'Sorry, we\'re unable to send your build request.', 'buddyboss-app' );
					$failed_message = $build_requested[ $platform ]['error_message'];
				}

				$is_failed = true;
			}
		} else {
			if ( ! isset( $build_requested[ $platform ] ) ) {
				$build_title = __( 'Not Requested', 'buddyboss-app' );
				$is_not_sent = true;
			}
		}

		if ( $is_not_sent || in_array( $build_status, array( 'failed', 'completed', 'cancelled' ), true ) ) {
			continue;
		}

		$build_infomation[ $platform ]                   = $build_requested[ $platform ];
		$build_infomation[ $platform ]['build_title']    = $build_title;
		$build_infomation[ $platform ]['is_failed']      = $is_failed;
		$build_infomation[ $platform ]['failed_message'] = $failed_message;
		$build_infomation[ $platform ]['is_sent']        = $is_sent;
		$build_infomation[ $platform ]['build_status']   = $build_status;
		$build_infomation[ $platform ]['label']          = $platform_label;
	}

	if ( ! empty( $build_infomation ) ) {
		$recheck_status = '<a class="bbapp-check-status" href="' . esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ) . '">' . __( 'Recheck status now', 'buddyboss-app' ) . ' <span class="bbapp_loading" style="display:none;vertical-align: middle;"></span></a>';
		echo '<p>';
		/* translators: build number. */
		echo sprintf( esc_html( _n( 'You currently have %s build in progress.', 'You currently have %s builds in progress.', count( $build_infomation ), 'buddyboss-app' ) ), count( $build_infomation ) );
		echo '&nbsp;';
		echo wp_kses_post( $recheck_status );
		echo '</p>';
	}

	if ( ! empty( $build_infomation ) ) {
		foreach ( $build_infomation as $platform => $platform_label ) {
			?>
			<div class="buddyboss-app-admin-card bbapp-build-status-block bbapp-publish-block full-width">
				<div class="bbapp-build-status-left-block <?php echo esc_attr( $platform ); ?>">
					<div class="icon-wrap">
						<h2 class="bbapp-admin-card-heading bbapp-admin-card-heading--<?php echo esc_attr( $platform ); ?>">
							<i class="bb-icon-rf bb-icon-brand-<?php echo 'ios' === $platform ? esc_attr( 'apple' ) : esc_attr( 'android' ); ?>"></i>
							<?php echo wp_kses_post( $platform_label['build_title'] ); ?>
						</h2>
					</div>

					<?php
					if ( ! empty( $platform_label['is_sent'] ) ) {
						$build_statuses = \BuddyBossApp\Admin\Build\Build::instance()->get_statuses_details();

						if ( isset( $build_statuses[ $platform_label['build_status'] ] ) ) {
							?>
							<div class="bbapp-build-<?php echo esc_attr( $platform_label['build_status'] ); ?>">
								<p><?php echo wp_kses_post( $build_statuses[ $platform_label['build_status'] ]['desc'] ); ?></p>
							</div>
						<?php } ?>
					<?php } ?>

					<?php if ( ! empty( $platform_label['key'] ) && ! empty( $platform_label['is_failed'] ) ) { ?>
						<div class="bbapp-notice-box bbapp-notice-box--error bbapp-notice-box--icon">
							<?php esc_html_e( 'Please resolve the errors specified below and resubmit your request.', 'buddyboss-app' ); ?>
						</div>
						<?php
						$invalid_key        = $platform_label['key'];
						$review_information = \BuddyBossApp\Admin\Build\Build::instance()->get_review_information( array( $platform ), $platform_label['type'] );
						?>
						<ul class="bbapp-cards">
							<?php
							if ( ! empty( $review_information ) ) {
								foreach ( $review_information as $rinfo_name => $rinfo ) {
									if ( 'files' === $rinfo_name ) {
										continue;
									}

									if ( is_array( $rinfo ) ) {
										if ( ! empty( $rinfo ) ) {
											foreach ( $rinfo as $cinfo_name => $cinfo ) {
												if ( 'files' === $cinfo_name ) {
													continue;
												}

												if ( $cinfo_name !== $invalid_key ) {
													continue;
												}

												$label        = ! empty( $cinfo['label'] ) ? $cinfo['label'] . ' ' . __( 'invalid. Please configure properly.', 'buddyboss-app' ) : '';
												$label_prefix = ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : $label;
												$description  = ! empty( $cinfo['description'] ) ? $cinfo['description'] : $label_prefix;
												?>
												<li class="bbapp-card">
													<div class="bbapp-card-inner">
														<header class="bbapp-card-header">
															<h4 class="bbapp-card-title"><?php echo esc_html( ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : '' ) . esc_html( $cinfo['label'] ); ?></h4>
															<?php
															echo '<div class="bb-card-content">';
															echo sprintf( '<span class="bbapp-invalid-val">%s</span>', esc_html( $description ) );
															echo '</div>';
															?>
														</header>
														<a class="button" href="<?php echo esc_url( $cinfo['edit_link'] ); ?>" target="_blank">
															<?php esc_html_e( 'Resolve', 'buddyboss-app' ); ?>
														</a>
													</div>
												</li>
												<?php
											}
										}
									} else {
										if ( $rinfo_name !== $invalid_key ) {
											continue;
										}
										$label        = ! empty( $cinfo['label'] ) ? $cinfo['label'] . ' ' . __( 'invalid. Please configure properly.', 'buddyboss-app' ) : '';
										$label_prefix = ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : $label;
										$description  = ! empty( $cinfo['description'] ) ? $cinfo['description'] : $label_prefix;
										?>
										<li class="bbapp-card <?php echo esc_attr( 'bbapp-info-' . ( ( $rinfo['validated'] ) ? 'valid' : 'invalid' ) ); ?>">
											<div class="bbapp-card-inner">
												<header class="bbapp-card-header">
													<h4 class="bbapp-card-title"><?php echo esc_attr( $rinfo['label'] ); ?></h4>
													<?php
													echo '<div class="bb-card-content">';
													echo sprintf( '<span class="bbapp-invalid-val">%s</span>', esc_html( $description ) );
													echo '</div>';
													?>
												</header>
												<a class="button" href="<?php echo esc_url( $rinfo['edit_link'] ); ?>" target="_blank">
													<?php esc_html_e( 'Resolve', 'buddyboss-app' ); ?>
												</a>
											</div>
										</li>
										<?php
									}
								}
							}
							?>
						</ul>
						<?php
					} elseif ( ! empty( $platform_label['is_failed'] ) ) {
						if ( 'build_limit_error' === $platform_label['error_code'] ) {
							echo '<p>' . wp_kses_post( $platform_label['failed_message'] ) . '</p>';
						} else {
							?>
							<p><?php esc_html_e( 'Please try requesting your build again. If you continue to encounter this issue, contact the BuddyBoss support team.', 'buddyboss-app' ); ?></p>
							<p>
								<?php printf( '<b>%1$s</b>', wp_kses_post( $platform_label['failed_message'] ) ); ?>
							</p>
							<?php
						}
					}
					?>
				</div>

				<?php if ( ! empty( $platform_label['is_sent'] ) && ( 'cancelled' !== $platform_label['build_status'] && 'completed' !== $platform_label['build_status'] ) ) : ?>
					<div class="bbapp-build-status-right-block">
						<?php if ( 'new' === $platform_label['build_status'] ) : ?>
							<button type="button" name="cancel" class="button bbapp-cancel-build" data-build-id="<?php echo esc_attr( $platform_label['build_id'] ); ?>">
								<span><?php esc_html_e( 'Cancel Request', 'buddyboss-app' ); ?></span>
							</button>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
			<?php
		}
	} else {
		?>
		<div class="bbapp-build-status-request bbapp-build-status-block">
			<?php
			$all_builds_link = '<a href="' . esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ) . '"> ' . __( 'View build history.', 'buddyboss-app' ) . ' </a>';
			echo esc_html__( 'You currently have no builds in progress.', 'buddyboss-app' ) . '&nbsp;' . esc_url( $all_builds_link );
			?>
		</div>
		<?php
	}
	?>
</div>

<script>
	jQuery( document ).ready( function() {
		jQuery( '.bbapp-check-status' ).click( function( e ) {
			e.preventDefault();
			jQuery( this ).find( '.bbapp_loading' ).show();
			jQuery( this ).prop( 'disabled', true );

			const post = jQuery.post( ajaxurl, {
				action: 'bbapp_build_status_actions',
				bbapp_build_actions: "<?php echo esc_attr( wp_create_nonce( 'bbapp_build_actions', 'bbapp_build_actions' ) ); ?>",
				sub_action: 'status_check',
			} );

			post.always( function() {
				jQuery( this ).prop( 'disabled', false );
				location.reload();
			} );

			return false;
		} );

		jQuery( '.bbapp-cancel-build' ).click( function() {
			jQuery( this ).prop( 'disabled', true );

			const post = jQuery.post( ajaxurl, {
				action: 'bbapp_build_status_actions',
				build_id: jQuery( this ).data( 'build-id' ),
				bbapp_build_actions: "<?php echo esc_attr( wp_create_nonce( 'bbapp_build_actions', 'bbapp_build_actions' ) ); ?>",
				sub_action: 'cancel',
			} );

			post.always( function() {
				jQuery( this ).prop( 'disabled', false );
				location.reload();
			} );
		} );
	} );
</script>
