<?php
/**
 * Holds select scope for build.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin build class.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */

// Check and update status.
\BuddyBossApp\Admin\Build\Build::instance()->update_build_status();

if ( true === \BuddyBossApp\ManageApp::instance()->is_app_disabled() ) {
	?>
	<div class="buddyboss-app-admin-card full-width bbapp-is-disabled">
		<?php include dirname( __DIR__ ) . '/app-is-disabled.php'; ?>
	</div>
	<?php
	return;
}

if ( ! empty( \BuddyBossApp\Build::instance()->check_installed_plugin_update() ) ) {
	include dirname( __FILE__ ) . '/require-update.php';
	return;
}

if ( BuddyBossApp\Integrations\MemberPressCourses\Main::instance()->check_plugin_version_validation() ) {
	include dirname( __FILE__ ) . '/require-mp-update.php';

	return;
}

$builds_limit = \BuddyBossApp\Build::instance()->get_app_builds_limit();

if ( is_wp_error( $builds_limit ) ) {
	?>
    <div class="bbapp-publish-block buddyboss-app-admin-card full-width">
        <h3 class="plugin-update-headline">
			<?php esc_html_e( 'Something went wrong', 'buddyboss-app' ); ?>
        </h3>
        <p>
			<?php echo esc_html( $builds_limit->get_error_message() ); ?>
        </p>
    </div>
	<?php
    return;
}

if ( $builds_limit <= 0 ) {
	include dirname( __FILE__ ) . '/build-limit-reached.php';
	return;
}

$appcenter_settings = \BuddyBossApp\Admin\Build\Build::instance()->get_appcenter_settings();
$developer_settings = ! empty( $appcenter_settings['developer'] ) ? $appcenter_settings['developer'] : array();
$ios_allowed        = ! empty( $developer_settings['is_build_request_disabled'] ) && ! empty( $developer_settings['disable_platform'] ) && in_array( 'ios', $developer_settings['disable_platform'], true ) || \BuddyBossApp\Build::instance()->is_build_in_process( 'ios', 'live' ) || \BuddyBossApp\Build::instance()->is_build_in_process( 'ios', 'dev' );
$android_allowed    = ! empty( $developer_settings['is_build_request_disabled'] ) && ! empty( $developer_settings['disable_platform'] ) && in_array( 'android', $developer_settings['disable_platform'], true ) || \BuddyBossApp\Build::instance()->is_build_in_process( 'android', 'live' ) || \BuddyBossApp\Build::instance()->is_build_in_process( 'android', 'dev' );
?>

<form action="<?php echo esc_attr( bbapp_get_super_admin_url( 'admin.php' ) ); ?>" method="get" id="build-select-scope" data-limit="<?php echo esc_attr( $builds_limit ); ?>">
	<div class="bbapp-publish-block buddyboss-app-admin-card full-width">
		<?php if ( isset( $developer_settings['is_build_request_disabled'] ) && false === $developer_settings['is_build_request_disabled'] && ! empty( $developer_settings ) && ! empty( $developer_settings['disable_platform'] ) && ! empty( $developer_settings['notice'] ) ) { ?>
			<div class="bbapp-notice-box bbapp-notice-box--warning">
				<?php printf( wp_kses_post( $developer_settings['notice'] ), implode( ', ', array_map( 'esc_html', $developer_settings['disable_platform'] ) ) ); ?>
			</div>
		<?php } ?>

		<p>
			<?php
			/* translators: %s: Remaining build count. */
			printf( __( 'You have <strong>%s builds</strong> remaining this month.', 'buddyboss-app' ), abs( ( $builds_limit < 0 ? 0 : esc_html( $builds_limit ) ) ) );
			?>
		</p>
		<p>
			<?php
			/* translators: %s: New build generation time. */
			printf( esc_html__( 'Once you reach 0, you won\'t be able to request a new build until %s.', 'buddyboss-app' ), esc_html( gmdate( get_option( 'date_format' ), strtotime( gmdate( 'm', strtotime( '+1 month' ) ) . '/01/' . gmdate( 'Y' ) . ' 00:00:00' ) ) ) );
			?>
		</p>
		<p class="no-margin"><?php esc_html_e( 'You only need new builds when:', 'buddyboss-app' ); ?></p>
		<ul>
			<li><?php esc_html_e( 'You have updated your launch screen or app icons.', 'buddyboss-app' ); ?></li>
			<li><?php esc_html_e( 'You have changed any Configure settings, including your app icon name.', 'buddyboss-app' ); ?></li>
			<li><?php esc_html_e( 'You have changed any Firebase iOS or Android settings.', 'buddyboss-app' ); ?></li>
			<li><?php esc_html_e( 'You want to update to the latest version of BuddyBoss App.', 'buddyboss-app' ); ?></li>
			<li><?php esc_html_e( 'You want to merge custom code changes into a build.', 'buddyboss-app' ); ?></li>
		</ul>
		<br />

		<div class="field-wrap">
			<h3><?php esc_html_e( 'Select Platforms', 'buddyboss-app' ); ?></h3>
			<div class="platform-select flex align-center">
				<label for="platform-ios" class="build-select-scope__label <?php echo ( true === $ios_allowed ? 'disabled' : '' ); ?>">
					<input type="checkbox" name="app_platform[]" value="ios" id="platform-ios" <?php disabled( true, $ios_allowed ); ?>>
					<span class="platform-select__label flex align-center"><span class="icon-wrap"><i class="bb-icon-f bb-icon-brand-apple"></i></span><span>iOS</span>
				</label>
				<label for="platform-android" class="build-select-scope__label <?php echo ( true === $android_allowed ? 'disabled' : '' ); ?>">
					<input type="checkbox" name="app_platform[]" value="android" id="platform-android" <?php disabled( true, $android_allowed ); ?>>
					<span class="platform-select__label flex align-center"><span class="icon-wrap"><i class="bb-icon-f bb-icon-brand-android"></i></span><span>Android</span>
				</label>
			</div>
		</div>

		<div class="field-wrap">
			<h3><?php esc_html_e( 'Select Build Type', 'buddyboss-app' ); ?></h3>
			<div class="build-type-select flex align-center">
				<?php if ( ! bbapp_is_sandbox_enabled() ) { ?>
					<label for="app-env-live" class="build-select-scope__label">
						<span class="flex align-center">
							<input type="radio" name="app_env" value="live" id="app-env-live">
							<strong><?php esc_html_e( 'Release App', 'buddyboss-app' ); ?></strong>
						</span>
						<p><?php esc_html_e( 'Generate builds that are ready to be published to the app stores. iOS release apps can only be installed after publishing or through Apple\'s TestFlight.', 'buddyboss-app' ); ?></p>
					</label>
				<?php } ?>
				<label for="app-env-dev" class="build-select-scope__label">
					<span class="flex align-center">
						<input type="radio" name="app_env" value="dev" id="app-env-dev">
						<strong><?php esc_html_e( 'Test App', 'buddyboss-app' ); ?></strong>
					</span>
					<p><?php esc_html_e( 'Generate a build that can be immediately installed on your device. Test apps can switch their connection to your secondary sites.', 'buddyboss-app' ); ?></p>
				</label>
			</div>

		</div>
		<?php if ( 0 < $builds_limit ) { ?>
			<div class="bb-col bb-app-submit">
				<input type="hidden" name="page" value="bbapp-build"/>
				<input type="hidden" name="setting" value="request-build"/>
				<input type="hidden" name="step" value="review"/>
				<button class="button button-primary" type="submit" disabled="disabled"><?php esc_html_e( 'Next Step', 'buddyboss-app' ); ?></button>
			</div>
		<?php } ?>

	</div>
</form>
<script>
	function buildNextStepCheck() {
		let status = false;
		const limit = jQuery( '#build-select-scope' ).attr( 'data-limit' );
		let checkedCount = 0;

		jQuery( 'input[name="app_platform[]"]:not(:disabled)' ).each( function() {
			if ( jQuery( this ).prop( 'checked' ) ) {
				status = true;
				checkedCount = checkedCount + 1;
			}
		} );

		if ( limit === 1 && checkedCount > 1 ) {
			// eslint-disable-next-line no-alert
			alert( "<?php esc_html_e( 'You have 1 build remaining for this month.', 'buddyboss-app' ); ?>" );
			jQuery( 'input[name="app_platform[]"]:not(:disabled)' ).removeAttr( 'checked' );
			status = false;
		}

		if ( status === true ) {
			jQuery( '.bb-app-submit .button-primary' ).removeAttr( 'disabled' );
		} else {
			jQuery( '.bb-app-submit .button-primary' ).attr( 'disabled', 'disabled' );
		}
	}

	jQuery( document ).ready( function() {
		buildNextStepCheck();
		jQuery( 'input[name="app_platform[]"]:not(:disabled)' ).change( function() {
			buildNextStepCheck();
		} );
	} );

</script>

