<?php
/**
 * Holds build scope review HTML.
 *
 * @package BuddyBossApp\Admin
 */

use BuddyBossApp\Admin\Configure;
use BuddyBossApp\AppLanguages;
use BuddyBossApp\AppSettings;
use BuddyBossApp\Build;
use BuddyBossApp\ManageApp;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Build variable.
 *
 * @var $this BuddyBossApp\Admin\Build\Build
 */

$app_platforms = ! empty( $_GET['app_platform'] ) ? map_deep( wp_unslash( $_GET['app_platform'] ), 'sanitize_text_field' ) : array(); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$app_env       = ( ! empty( $_GET['app_env'] ) ) ? sanitize_text_field( wp_unslash( $_GET['app_env'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended

// Try to fetch the latest last versions.
Build::instance()->update_last_versions( $app_env, true );

$review_information  = $this->get_review_information( $app_platforms, $app_env );
$review_info_summary = $this->get_review_info_summary( $review_information );

if ( ! empty( $review_info_summary['invalid'] ) ) {
	?>
	<div class="bbapp-publish-block full-width">
		<div class="wp-headline">
			<h2 class="wp-heading-inline"><?php esc_html_e( 'Review Information', 'buddyboss-app' ); ?></h2>
		</div>
		<div class="bbapp-notice-box bbapp-notice-box--error bbapp-notice-box--icon">
			<?php esc_html_e( 'We\'re missing some information required to fulfill your build request. Please resolve the errors specified below and resubmit your request.', 'buddyboss-app' ); ?>
		</div>

		<ul class="bbapp-cards">
			<?php
			if ( ! empty( $review_information ) ) {
				foreach ( $review_information as $rinfo_name => $rinfo ) {
					if ( 'files' === $rinfo_name || ( isset( $rinfo['validated'] ) && $rinfo['validated'] ) ) {
						continue;
					}

					if ( is_array( $rinfo ) ) {
						if ( ! empty( $rinfo ) ) {
							foreach ( $rinfo as $cinfo_name => $cinfo ) {
								if ( 'files' === $cinfo_name || ( isset( $cinfo['validated'] ) && $cinfo['validated'] ) ) {
									continue;
								}
								?>
								<li class="bbapp-card <?php echo esc_attr( 'bbapp-info-' . ( ( $cinfo['validated'] ) ? 'valid' : 'invalid' ) ); ?>">
									<div class="bbapp-card-inner">
										<header class="bbapp-card-header">
											<h4 class="bbapp-card-title">
												<?php echo esc_html( ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : '' ) . esc_html( $cinfo['label'] ); ?>
											</h4>
											<?php
											echo '<div class="bb-card-content">';
											if ( empty( $cinfo['value'] ) ) {
												$cinfo['value'] = __( 'N/A', 'buddyboss-app' );
											}

											if ( isset( $cinfo['validated'] ) && $cinfo['validated'] ) {
												if ( isset( $cinfo['is_image'] ) ) {
													echo '<img src="' . esc_attr( $cinfo['value'] ) . '" class="bbapp-image-preview" />';
												} elseif ( isset( $cinfo['preview'] ) ) {
													echo wp_kses_post( $cinfo['preview'] );
												} else {
													echo esc_html( $cinfo['value'] );
												}
											} else {
												$label        = $cinfo['label'] . ' ' . esc_html__( 'needs to be configured.', 'buddyboss-app' );
												$label_prefix = ! empty( $cinfo['label_prefix'] ) ? $cinfo['label_prefix'] . ' ' : $label;
												$description  = ! empty( $cinfo['description'] ) ? $cinfo['description'] : $label_prefix;
												printf( '<span class="bbapp-invalid-val">%1$s</span>', esc_html( $description ) );
											}
											echo '</div>';
											?>
										</header>
										<a class="button" href="<?php echo esc_url( $cinfo['edit_link'] ); ?>" target="_blank">
											<?php esc_html_e( 'Resolve', 'buddyboss-app' ); ?>
										</a>
									</div>
								</li>
								<?php
							}
						}
					} else {
						?>
						<li class="bbapp-card <?php echo esc_attr( 'bbapp-info-' . ( ( $rinfo['validated'] ) ? 'valid' : 'invalid' ) ); ?>">
							<div class="bbapp-card-inner">
								<header class="bbapp-card-header">
									<h4 class="bbapp-card-title"><?php echo esc_attr( $rinfo['label'] ); ?></h4>
									<?php
									echo '<div class="bb-card-content">';
									if ( empty( $rinfo['value'] ) ) {
										$rinfo['value'] = __( 'N/A', 'buddyboss-app' );
									}

									if ( isset( $rinfo['validated'] ) && $rinfo['validated'] ) {
										if ( isset( $rinfo['is_image'] ) ) {
											echo '<img src="' . esc_attr( $rinfo['value'] ) . '" class="bbapp-image-preview" />';
										} elseif ( isset( $rinfo['preview'] ) ) {
											echo wp_kses_post( $rinfo['preview'] );
										} else {
											echo esc_html( $rinfo['value'] );
										}
									} else {
										printf( '<span class="bbapp-invalid-val">%1$s</span> %2$s', isset( $rinfo['description'] ) && ! empty( $rinfo['description'] ) ? esc_html( $rinfo['description'] ) : esc_html( $rinfo['label'] ), esc_html__( 'needs to be configured.', 'buddyboss-app' ) );
									}
									echo '</div>';
									?>
								</header>
								<a class="button" href="<?php echo esc_url( $rinfo['edit_link'] ); ?>" target="_blank">
									<?php esc_html_e( 'Resolve', 'buddyboss-app' ); ?>
								</a>
							</div>
						</li>
						<?php
					}
				}
			}
			?>
		</ul>
	</div>
	<?php
} else {
	if ( empty( $review_information ) ) {
		?>
		<div class="bbapp-publish-block full-width">
			<p>
				<?php
				printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'No information has been found to create build with please', 'buddyboss-app' ), esc_url( admin_url( 'admin.php?page=bbapp-build&setting=request-build' ) ), esc_html__( 'go back', 'buddyboss-app' ), esc_html__( '& select some other options', 'buddyboss-app' ) );
				?>
			</p>
		</div>
		<?php

		return false;
	}

	$build_review_information = $this->get_build_review_information( $app_platforms, $app_env );
	$app_platform             = ! empty( $app_platforms ) ? $app_platforms : '';
	$app_platform             = is_array( $app_platform ) ? implode( ',', $app_platform ) : $app_platform;
	?>
	<form target="_self" method="post" id="bbapp_publish">
		<?php $this->publish_nonce_field(); ?>
		<input type="hidden" name="action" value="bbapp_publish_submit"/>
		<input type="hidden" name="app_env" value="<?php echo esc_attr( $app_env ); ?>"/>
		<input type="hidden" name="app_platform" value="<?php echo esc_attr( $app_platform ); ?>"/>
		<div class="bbapp-build-submit">
			<button class="button button-primary bbapp-submit-btn" type="submit">
				<span><?php esc_html_e( 'Send Build Request', 'buddyboss-app' ); ?></span>
				<span class="bb-arrow-wrap">
					<svg width="6" height="10" xmlns="http://www.w3.org/2000/svg"><path d="M1 1l4 4-4 4" stroke="#FFF" stroke-width="1.5" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"></path></svg>
				</span>
				<div class="bbapp_loading light" style="display:none"></div>
			</button>
		</div>
		<div class="bbapp-build-review-full-wrp">
			<?php
			if ( ! empty( $build_review_information ) ) {
				foreach ( $build_review_information as $key => $value ) {
					?>
					<div class="bbapp-publish-block full-width">
						<?php if ( 'ios' === $key ) { ?>
							<h2 class="bbapp-heading-base bbapp-heading-base--icon">
								<i class="bb-icon-bf bb-icon-brand-apple"></i>
								<?php esc_html_e( 'iOS App Overview', 'buddyboss-app' ); ?>
								<div class="bbapp-heading-actions">
									<a href="#" class="bbapp-heading-actions-link bbapp-build-adv-switch" data-platform="ios">
										<?php esc_html_e( 'Advanced Settings', 'buddyboss-app' ); ?>
										<i class="bb-icon-l bb-icon-angle-right"></i>
									</a>
								</div>
							</h2>
						<?php } elseif ( 'android' === $key ) { ?>
							<h2 class="bbapp-heading-base bbapp-heading-base--icon">
								<i class="bb-icon-bf bb-icon-brand-android"></i>
								<?php esc_html_e( 'Android App Overview', 'buddyboss-app' ); ?>
								<div class="bbapp-heading-actions">
									<a href="#" class="bbapp-heading-actions-link bbapp-build-adv-switch" data-platform="android">
										<?php esc_html_e( 'Advanced Settings', 'buddyboss-app' ); ?>
										<i class="bb-icon-l bb-icon-angle-right"></i>
									</a>
								</div>
							</h2>
						<?php } ?>
						<div class="bbapp-build-overview">
							<div class="bbapp-build-overview-stamp">
								<img src="<?php echo esc_url( $value['app_icon']['value'] ); ?>" class="bbapp-build-figure">
							</div>
							<div class="bbapp-build-overview-panel">
								<div class="bbapp-build-overview-col">
									<div class="bbapp-build-overview-label">
										<?php echo esc_html( $value['app_name']['label'] ); ?>
									</div>
									<div class="bbapp-build-overview-value">
										<?php echo esc_html( $value['app_name']['value'] ); ?>
									</div>
								</div>
								<div class="bbapp-build-overview-col">
									<div class="bbapp-build-overview-label">
										<?php echo esc_html( $value['build_type']['label'] ); ?>
									</div>
									<div class="bbapp-build-overview-value">
										<?php echo esc_html( $value['build_type']['value'] ); ?>
									</div>
								</div>
							</div>
						</div>
						<?php if ( 'ios' === $key ) { ?>
							<h2 class="bbapp-heading-base bbapp-heading-base--icon bbapp-heading-base--sub">
								<i class="bb-icon-bf bb-icon-cog"></i>
								<?php esc_html_e( 'iOS Settings', 'buddyboss-app' ); ?>
							</h2>
						<?php } elseif ( 'android' === $key ) { ?>
							<h2 class="bbapp-heading-base bbapp-heading-base--icon bbapp-heading-base--sub">
								<i class="bb-icon-bf bb-icon-cog"></i>
								<?php esc_html_e( 'Android Settings', 'buddyboss-app' ); ?>
							</h2>
							<?php
						}
						$current_version               = $value['app_version']['value'];
						$value['app_version']['value'] = Build::instance()->get_next_version( $value['app_version']['value'], $key );
						?>
						<div class="bbapp-build-request-opts">
							<div class="request-block request-block--editable">
								<div class="request-block-label">
									<?php echo esc_html( $value['app_version']['label'] ); ?>
									<a class="request-block-edit editable">
										<i class="bb-icon-l bb-icon-pencil"></i>
									</a>
								</div>
								<div class="request-block-value bb-card-content">
									<span class="editable" data-value="<?php echo esc_html( $value['app_version']['value'] ); ?>">
										<?php echo esc_html( $value['app_version']['value'] ); ?>
									</span>
									<input value="<?php echo esc_attr( trim( $value['app_version']['value'] ) ); ?>"
											name="app_version_<?php echo esc_attr( $key ); ?>" type="text"
											class="edit-fields mask-version hidden" required>
									<?php printf( '<span class="error hidden">%1$s %2$s</span>', esc_html__( 'Enter a value higher than', 'buddyboss-app' ), esc_html( $current_version ) ); ?>
									<input type="hidden" class="build-version-current"
											value="<?php echo esc_attr( $current_version ); ?>">
								</div>
							</div>
							<div class="request-block request-block--editable">
								<?php
								$current_version                    = $value['app_version_code']['value'];
								$value['app_version_code']['value'] = Build::instance()->get_next_version_code( $value['app_version_code']['value'] );
								?>
								<div class="request-block-label">
									<?php echo esc_html( $value['app_version_code']['label'] ); ?>
									<a class="request-block-edit editable">
										<i class="bb-icon-l bb-icon-pencil"></i>
									</a>
								</div>
								<div class="request-block-value bb-card-content">
									<span class="editable" data-value="<?php echo esc_html( $value['app_version_code']['value'] ); ?>">
										<?php echo esc_html( $value['app_version_code']['value'] ); ?>
									</span>
									<input value="<?php echo esc_attr( $value['app_version_code']['value'] ); ?>"
											name="app_version_code_<?php echo esc_attr( $key ); ?>"
											type="number" class="edit-fields mask-version hidden" required>
									<?php printf( '<span class="error hidden">%1$s %2$s</span>', esc_html__( 'Enter a value higher than', 'buddyboss-app' ), esc_html( $current_version ) ); ?>
									<input type="hidden" class="build-version-current"
											value="<?php echo esc_attr( $current_version ); ?>">
								</div>
							</div>
							<div class="request-block">
								<div class="request-block-label">
									<?php echo esc_html( $value['push_notification']['label'] ); ?>
								</div>
								<div class="request-block-value">
									<span>
										<?php echo esc_html( $value['push_notification']['value'] ); ?>
									</span>
								</div>
							</div>
							<div class="request-block">
								<div class="request-block-label">
									<?php echo esc_html( $value['iap']['label'] ); ?>
								</div>
								<div class="request-block-value">
									<span>
										<?php echo esc_html( $value['iap']['value'] ); ?>
									</span>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>

			<div class="bbapp-publish-block full-width">
				<h2 class="bbapp-heading-base bbapp-heading-base--icon bbapp-heading-base--sub">
					<i class="bb-icon-bf bb-icon-font"></i>
					<?php esc_html_e( 'Languages', 'buddyboss-app' ); ?>
					<div class="bbapp-heading-actions">
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-translations' ) ); ?>" target="_blank">
							<?php esc_html_e( 'Go to Translations', 'buddyboss-app' ); ?>
							<i class="bb-icon-l bb-icon-angle-right"></i>
						</a>
					</div>
				</h2>
				<ul class="bbapp-build-languages">
					<?php
					// Get active languages from function.
					$active_languages     = AppLanguages::instance()->get_active_languages();
					$build_selected_langs = maybe_unserialize( AppSettings::instance()->get_setting_value( 'build_selected_languages' ) );
					$build_selected_langs = ! empty( $build_selected_langs ) ? $build_selected_langs : array();

					// Display each active language.
					foreach ( $active_languages as $lang_code => $lang_details ) {
						$is_wp_default = isset( $lang_details['is_wp_default'] ) && $lang_details['is_wp_default'];
						$lang_name     = isset( $lang_details['name'] ) ? $lang_details['name'] : $lang_code;
						?>
						<li>
							<input type="checkbox" id="language-<?php echo esc_attr( $lang_code ); ?>"
								<?php checked( $is_wp_default || in_array( $lang_code, $build_selected_langs, true ) ); ?>
								<?php disabled( $is_wp_default ); ?> value="<?php echo esc_attr( $lang_code ); ?>" name="languages[]"/>
							<?php
							if ( $is_wp_default ) {
								printf( '<input type="hidden" name="languages[]" value="%1$s">', esc_attr( $lang_code ) );
							}
							?>
							<label for="language-<?php echo esc_attr( $lang_code ); ?>">
								<?php echo esc_html( $lang_name ); ?>
								<span class="bbapp-badge">
									<?php esc_html( $lang_details['name'] ); ?>
								</span>
							</label>
						</li>
						<?php
					}
					?>
				</ul>
			</div>
		</div>
	</form>

	<div id="bbapp-modal-box" class="bbapp-modal-box bbapp-modal-box--generic bbapp-modal bbapp-build-adv-modal">
		<div tabindex="0" class="bbapp-media-modal">
			<div class="bbapp-modal-wrapper">
				<form method="post" name="bbapp-build-adv-opts" id="bbapp-build-adv-opts" class="bbapp-modal-box__form-wrapper">
					<?php wp_nonce_field( 'bbapp-build-permissions', 'bbapp_permissions_nonce' ); ?>
					<input type="hidden" name="platform" id="bbapp-platform-type" value="android">
					<div class="bbapp-modal-header">
						<h2 class="bbapp-heading-base bbapp-heading-base--icon" id="bbapp-modal-title">
							<i class="bb-icon-l bb-icon-lock-alt"></i>
							<span class="bbapp-platform-label"><?php esc_html_e( 'Android Permissions', 'buddyboss-app' ); ?></span>
						</h2>
						<a href="#" class="bbapp-modal-close"><i class="bb-icon-l bb-icon-times"></i></a>
					</div>
					<div class="bbapp-modal-content">
						<!-- Android Permissions Section -->
						<div class="bbapp-permissions-section bbapp-android-permissions">
							<ul class="bbapp-build-adv-opts-list">
								<li>
									<input type="checkbox" id="audio-recording" name="permissions[audio_recording]" value="true" <?php checked( ManageApp::instance()->get_app_setting( 'publish.android.permissions.audio_recording' ) ); ?>>
									<label for="audio-recording">
										<?php esc_html_e( 'Audio Recording', 'buddyboss-app' ); ?>
									</label>
									<span class="bbapp-tooltip bbapp-tooltip--overflow">
										<span class="bbapp-tooltip-text">
											<?php esc_html_e( 'When enabled audio recording will be allowed in your app.', 'buddyboss-app' ); ?>
										</span>
										<i class="bb-icon-rl bb-icon-info"></i>
									</span>
								</li>
								<li>
									<input type="checkbox" id="foreground-services" name="permissions[foreground_services]" value="true" <?php checked( ! empty( ManageApp::instance()->get_app_setting( 'publish.android.permissions.foreground_media_playback' ) ) && Configure::instance()->has_custom_developer_access() ); ?> <?php disabled( ! Configure::instance()->has_custom_developer_access() ); ?>>
									<label for="foreground-services">
										<?php esc_html_e( 'Foreground Services', 'buddyboss-app' ); ?>
									</label>
									<span class="bbapp-tooltip bbapp-tooltip--overflow">
										<span class="bbapp-tooltip-text">
											<?php esc_html_e( 'When enabled, background media playback will be allowed in your app, ensuring continuous audio or video playback even when the app is minimized.', 'buddyboss-app' ); ?>
										</span>
										<i class="bb-icon-rl bb-icon-info"></i>
									</span>
								</li>
							</ul>
						</div>
						
						<!-- iOS Permissions Section -->
						<div class="bbapp-permissions-section bbapp-ios-permissions" style="display: none;">
							<ul class="bbapp-build-adv-opts-list">
								<li>
									<input type="checkbox" id="play-music" name="permissions[play_music]" value="true" <?php checked( ManageApp::instance()->get_app_setting( 'publish.ios.permissions.play_music' ) ); ?> <?php disabled( ! Configure::instance()->has_custom_developer_access() ); ?>>
									<label for="play-music">
										<?php esc_html_e( 'Play Music', 'buddyboss-app' ); ?>
									</label>
									<span class="bbapp-tooltip bbapp-tooltip--overflow">
										<span class="bbapp-tooltip-text">
											<?php esc_html_e( 'When enabled, music playback will be allowed in your iOS app.', 'buddyboss-app' ); ?>
										</span>
										<i class="bb-icon-rl bb-icon-info"></i>
									</span>
								</li>
							</ul>
						</div>
					</div>
					<div class="bbapp-modal-footer">
						<button class="button button-primary bbapp-modal-save"><?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?></button>
						<button class="button bbapp-modal-cancel"><?php esc_html_e( 'Cancel', 'buddyboss-app' ); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
	<?php
}
?>

<script>
	jQuery( document ).ready( function() {
		jQuery( '#bbapp_publish' ).submit( function( e ) {
			e.preventDefault();

			if ( jQuery( this ).find( '.not-valid' ).length ) {
				return false;
			}

			jQuery( '.bbapp-submit-btn' ).prop( 'disabled', true ).find( '.bb-arrow-wrap' ).hide().closest( '.bbapp-submit-btn' ).find( '.bbapp_loading' ).show();

			const post = jQuery.post( ajaxurl, jQuery( this ).serialize() );

			post.always( function() {
				jQuery( '.bbapp-submit-btn' ).prop( 'disabled', false ).find( '.bb-arrow-wrap' ).show().closest( '.bbapp-submit-btn' ).find( '.bbapp_loading' ).hide();
			} );

			post.done( function( data ) {
				if ( ! data.success ) {
					// eslint-disable-next-line no-alert
                    if ( data.data.message ) {
                        alert(data.data.message);
                    } else {
                        alert( "<?php esc_html_e( 'Something went wrong. Please try again.', 'buddyboss-app' ); ?>" );
                    }

					return false;
				}

                window.location.href = data.data.redirect;
			} );

			post.fail( function() {
				// eslint-disable-next-line no-alert
				alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );
			} );
		} );
		
		// Prevent default form submission for the advanced settings modal.
		jQuery( '#bbapp-build-adv-opts' ).on( 'submit', function( e ) {
			e.preventDefault();
		} );
	} );
</script>
