<?php
/**
 * Holds IOS build data upload HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Current class object.
 *
 * @var $this BuddyBossApp\Admin\BuildUpload\Upload
 */

$bbapp = \BuddyBossApp\ManageApp::instance()->get_app();

if ( empty( $bbapp ) || empty( $bbapp['verified'] ) ) {
	include dirname( __FILE__ ) . '/build-no-connection.php';
	return;
}
?>
<h1 class="wp-heading-inline">
	<?php esc_html_e( 'Upload History', 'buddyboss-app' ); ?>
</h1>
<a class="page-title-action button button-primary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build-upload&setting=request-ios' ) ); ?>">
	<?php esc_html_e( 'Upload Build', 'buddyboss-app' ); ?>
</a>
<a class="page-title-action button button-secondary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ); ?>">
	<?php esc_html_e( 'Build History', 'buddyboss-app' ); ?>
</a>

<div class="wrap bbapp-build-uploads-container">
	<?php if ( true === \BuddyBossApp\ManageApp::instance()->is_app_disabled() ) { ?>
		<div class="bbapp-build-container">
			<div class="buddyboss-app-admin-card full-width bbapp-is-disabled">
				<?php include dirname( __DIR__ ) . '/app-is-disabled.php'; ?>
			</div>
		</div>
		<?php
		return;
	}
	?>
	<?php $this->list->views(); ?>
	<?php $this->list->display(); ?>
</div>

