<?php
/**
 * Holds request IOS build HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Current class object.
 *
 * @var $this BuddyBossApp\Admin\BuildUpload\Upload
 */

$bbapp = \BuddyBossApp\ManageApp::instance()->get_app();

if ( empty( $bbapp ) || empty( $bbapp['verified'] ) ) {
	include dirname( __FILE__ ) . '/no-connection.php';

	return;
}

$request_upload_checklist = $this->request_upload_checklist( 'ios' );
$build_id                 = ( ! empty( $_GET['build_id'] ) ) ? sanitize_text_field( wp_unslash( $_GET['build_id'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended

?>
<h1 class="wp-heading-inline">
	<?php esc_html_e( 'Upload Build', 'buddyboss-app' ); ?>
</h1>
<a class="page-title-action button button-primary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build-upload&setting=all-uploads' ) ); ?>">
	<?php esc_html_e( 'Upload History', 'buddyboss-app' ); ?>
</a>
<a class="page-title-action button button-secondary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ); ?>">
	<?php esc_html_e( 'Build History', 'buddyboss-app' ); ?>
</a>

<div>
	<?php
	\BuddyBossApp\Admin\SetupAdmin::instance()->render_subtabs( $this->sub_settings(), $this->get_current_sub_tab(), 'setting' );
	?>
</div>

<div class="wrap bbapp-build-uploads-container">
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-build-uploads">
			<div class="bbapp-ie">
				<div class="bbapp-ie__heading bbapp-ie__sub">
					<h2 class="title bbapp-build-upload-heading ios">
						<i class="bb-icon-rf bb-icon-brand-apple"></i>
						<?php esc_html_e( 'Upload to App Store Connect', 'buddyboss-app' ); ?>
						<a class="button button-secondary bbapp-tutorial-btn" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-help&article=124747' ) ); ?>" target="_blank">
							<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
						</a>
					</h2>
				</div>

				<?php if ( $request_upload_checklist && $this->current_build_error ) : ?>
					<div class="bbapp-notice-box bbapp-notice-box--error">
						<p><?php echo esc_html( $this->current_build_error ); ?></p>
					</div>
				<?php endif; ?>

				<?php if ( true !== $request_upload_checklist ) : ?>
					<div class="bbapp-ie__block">
						<div class="bbapp-upload-error-notice">
							<p><?php echo wp_kses_post( $request_upload_checklist['desc'] ); ?></p>
							<a <?php echo ( isset( $request_upload_checklist['new_window'] ) && $request_upload_checklist['new_window'] ) ? 'target="_blank"' : ''; ?> href="<?php echo esc_url( $request_upload_checklist['link'] ); ?>" class="button button-primary bbapp-resolve-btn"><?php echo esc_attr( $request_upload_checklist['button_txt'] ); ?>
								<?php if ( ( isset( $request_upload_checklist['new_window'] ) && $request_upload_checklist['new_window'] ) ) : ?>
									<span class="dashicons dashicons-external"></span>
								<?php endif; ?>
							</a>
						</div>
					</div>
				<?php else : ?>
					<div class="bbapp-ie__block">
						<p><?php esc_html_e( 'Your build will be uploaded to the TestFlight section of your app in App Store Connect. From there, you can submit it for release through either TestFlight or Apple\'s App Store apps. Before your app will be available for download, it must be approved by Apple.', 'buddyboss-app' ); ?></p>
						<p><?php esc_html_e( 'You can only upload the following types of builds:', 'buddyboss-app' ); ?></p>
						<ul>
							<li><?php esc_html_e( 'iOS Release App builds', 'buddyboss-app' ); ?></li>
							<li><?php esc_html_e( 'Builds that have not already been uploaded to App Store Connect', 'buddyboss-app' ); ?></li>
							<li><?php esc_html_e( 'Builds that have a build version and build version code higher than any other build uploaded to App Store Connect', 'buddyboss-app' ); ?></li>
						</ul>
						<?php if ( $this->upload_error ) : ?>
							<div class="bbapp-notice-box bbapp-notice-box--error">
								<p><?php esc_html_e( 'There was a problem submitting your upload request:', 'buddyboss-app' ); ?></p>
								<p><?php echo esc_html( $this->upload_error ); ?></p>
							</div>
						<?php elseif ( $this->build_not_available ) : ?>
							<div class="bbapp-notice-box bbapp-notice-box--warning">
								<p>
									<?php
									$ios_build_link = bbapp_get_super_admin_url( 'admin.php?page=bbapp-build&setting=request-build' );
									echo sprintf(
										'%1$s <a href="%2$s">%3$s</a>',
										esc_html__( 'No builds available for upload. To continue, please ', 'buddyboss-app' ),
										esc_url( $ios_build_link ),
										esc_html__( 'generate a new iOS Release App build', 'buddyboss-app' )
									);
									?>
								</p>
							</div>

						<?php elseif ( $this->build_upload_success ) : ?>
							<div class="bbapp-notice-box bbapp-notice-box--success">
								<?php echo sprintf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'Your upload is in progress. You can check the status at anytime on the ', 'buddyboss-app' ), esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-build-upload&setting=all-uploads' ) ), esc_html__( 'Upload History', 'buddyboss-app' ), esc_html__( 'page.', 'buddyboss-app' ) ); ?>
							</div>
							<?php if ( false === \BuddyBossApp\Admin\Publish\Publish::instance()->is_publishing_services_already_requested( 'ios' ) ) { ?>
								<div class="bbapp-notice-box bbapp-notice-box--info">
									<?php
									echo sprintf(
										'<strong>%1$s</strong> %2$s <a href="%3$s">%4$s</a> %5$s',
										esc_html__( 'Tip:', 'buddyboss-app' ),
										esc_html__( 'Make use of the', 'buddyboss-app' ),
										esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-publish&setting=ios' ) ),
										esc_html__( 'BuddyBoss Publishing Service', 'buddyboss-app' ),
										esc_html__( 'to increase your chances of successfully publishing your app. This service is included for all BuddyBoss App customers.', 'buddyboss-app' )
									);
									?>
								</div>
							<?php } ?>
						<?php else : ?>
							<form name="bbapp-request-build-upload" method="post" id="bbapp-request-build-upload">
								<?php wp_nonce_field( 'bbapp_build_upload_request', 'bbapp_build_upload_request' ); ?>

								<table class="form-table">
									<tbody>
									<tr class="bbapp_field_wrapper">
										<th scope="row" style="width:250px">
											<label><?php esc_html_e( 'Build', 'buddyboss-app' ); ?></label>
										</th>
										<td>
											<select name="build_id" class="regular-text bbapp-build-id">
												<option><?php esc_html_e( '-- Select Build --', 'buddyboss-app' ); ?></option>
												<?php
												$builds = $this->get_builds( 'ios', true, true );

												foreach ( $builds as $build ) {
													$is_disabled = ( 'not' !== $build['is_uploaded'] ) ? true : false;
													$post_text   = '';

													if ( 'yes' === $build['is_uploaded'] ) {
														$post_text = __( '- Uploaded', 'buddyboss-app' );
													}

													if ( 'running' === $build['is_uploaded'] ) {
														$post_text = __( '- Processing', 'buddyboss-app' );
													}

													/* translators: %1$s: Build id, %2$s: Build version, %3$s: Build version code.  */
													$build_txt = sprintf( __( 'Build #%1$s %2$s (%3$s)', 'buddyboss-app' ), $build['id'], $build['build_version'], $build['build_version_code'] );

													echo sprintf( '<option value="%1$s" %2$s %3$s >%4$s %5$s </option>', esc_html( $build['id'] ), disabled( $is_disabled, true, false ), selected( $build_id, $build['id'], false ), esc_html( $build_txt ), esc_html( $post_text ) );
												}
												?>
											</select>
											<p class="description"><?php esc_html_e( 'Select an iOS Release App build to upload to App Store Connect', 'buddyboss-app' ); ?></p>
										</td>
									</tr>
									<tr class="bbapp_field_wrapper">
										<th scope="row" style="width:250px">
											<button disabled type="submit" name="submit" class="button button-primary submitbtn">
												<div class="bbapp_loading dark" style="display: none"></div>
												<?php esc_html_e( 'Upload Build', 'buddyboss-app' ); ?>
											</button>
										</th>
									</tr>
									</tr>
									</tbody>
								</table>
							</form>
						<?php endif; ?>

						<script>
							jQuery( document ).ready( function() {
								jQuery( '.bbapp-build-id' ).change( function() {
									if ( jQuery( '.bbapp-build-id' ).find( 'option:selected' ).attr( 'value' ) !== undefined ) {
										jQuery( '.submitbtn' ).prop( 'disabled', false );
									} else {
										jQuery( '.submitbtn' ).prop( 'disabled', true );
									}
								} );

								jQuery( '#bbapp-request-build-upload' ).submit( function() {
									jQuery( '.submitbtn' ).prop( 'disabled', true ).find( '.bbapp_loading' ).show();
								} );

								<?php if ( ! empty( $build_id ) ) : ?>
								jQuery( '.bbapp-build-id' ).change();
	                            <?php endif; ?>
							} );
						</script>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
