<?php
/**
 * Holds request Android build HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Current class object.
 *
 * @var $this BuddyBossApp\Admin\BuildUpload\Upload
 */

$bbapp = \BuddyBossApp\ManageApp::instance()->get_app();

if ( empty( $bbapp ) || empty( $bbapp['verified'] ) ) {
	include dirname( __FILE__ ) . '/no-connection.php';

	return;
}

$request_upload_checklist = $this->request_upload_checklist( 'android' );
$build_id                 = ( ! empty( $_GET['build_id'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['build_id'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

?>
<h1 class="wp-heading-inline"><?php esc_html_e( 'Upload Build', 'buddyboss-app' ); ?></h1>
<a class="page-title-action button button-primary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build-upload&setting=all-uploads' ) ); ?>">
	<?php esc_html_e( 'Upload History', 'buddyboss-app' ); ?>
</a>
<a class="page-title-action button button-secondary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ); ?>">
	<?php esc_html_e( 'Build History', 'buddyboss-app' ); ?>
</a>

<div>
	<?php
	\BuddyBossApp\Admin\SetupAdmin::instance()->render_subtabs( $this->sub_settings(), $this->get_current_sub_tab(), 'setting' );
	?>
</div>

<div class="wrap bbapp-build-uploads-container">
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-build-uploads">
			<div class="bbapp-ie">
				<div class="bbapp-ie__heading bbapp-ie__sub">
					<h2 class="title bbapp-build-upload-heading android">
						<i class="bb-icon-rf bb-icon-brand-android"></i>
						<?php echo esc_attr__( 'Upload to Google Play Console', 'buddyboss-app' ); ?>
					</h2>
				</div>
				<?php if ( true !== $request_upload_checklist ) : ?>
					<div class="bbapp-ie__block">
						<div class="bbapp-upload-error-notice">
							<p><?php echo wp_kses_post( $request_upload_checklist['desc'] ); ?></p>
							<a <?php echo ( isset( $request_upload_checklist['new_window'] ) && $request_upload_checklist['new_window'] ) ? 'target="_blank"' : ''; ?> href="<?php echo esc_url( $request_upload_checklist['link'] ); ?>" class="button button-primary bbapp-resolve-btn">
								<?php echo esc_html( $request_upload_checklist['button_txt'] ); ?>
							</a>
						</div>
					</div>
				<?php else : ?>
					<div class="bbapp-ie__block">
						<p><?php echo esc_html__( 'Android apps uploaded into a release track the Google Play Console can be downloaded from the Google Play Store app, after approval from Google.', 'buddyboss-app' ); ?></p>
						<p><?php echo esc_html__( 'Releases in the Production track will be able to all users in the Google Play Store. Alternatively, you can release to a select group of testers through one of the available testing tracks (Open, Closed, Internal).', 'buddyboss-app' ); ?></p>
						<p><?php echo esc_html__( 'After downloading your chosen build\'s file, create a release in the Google Play Console and upload the file into it.', 'buddyboss-app' ); ?></p>

						<form name="bbapp-request-build-upload" method="post" id="bbapp-request-build-upload">
							<table class="form-table">
								<tbody>
								<tr class="bbapp_field_wrapper">
									<th scope="row" style="width:250px">
										<label><?php esc_attr_e( 'Build', 'buddyboss-app' ); ?></label>
									</th>
									<td>
										<select name="build_id" class="regular-text bbapp-build-id">
											<option value=""><?php esc_html_e( '-- Select Build --', 'buddyboss-app' ); ?></option>
											<?php
											foreach ( $this->get_builds( 'android' ) as $build ) {
												$is_disabled = ( 'not' !== $build['is_uploaded'] ) ? true : false;
												$post_text   = '';

												if ( 'yes' === $build['is_uploaded'] ) {
													$post_text = __( '- Uploaded', 'buddyboss-app' );
												}

												if ( 'running' === $build['is_uploaded'] ) {
													$post_text = __( '- Processing', 'buddyboss-app' );
												}

                                                echo sprintf( '<option value="%1$s" data-apk-url="%2$s" data-aab-url="%3$s" data-fp-url="%4$s" %5$s>%6$s %7$s</option>', esc_html( $build['id'] ), esc_url( $build['build_url'] ), esc_url( $build['build_secondary_url'] ), esc_url( $build['build_fingerprint_url'] ), selected( $build_id, $build['id'], false ), esc_html( $build['build_version'] ), esc_html( $post_text ) );
											}
											?>
										</select>
										<p class="description"><?php esc_html_e( 'Select an Android Release App build to download.', 'buddyboss-app' ); ?></p>
									</td>
								</tr>
								<tr class="bbapp_field_wrapper bbapp_build_format_wrapper" style="display: none;">
									<th scope="row" style="width:250px">
										<label><?php esc_html_e( 'Format', 'buddyboss-app' ); ?></label>
									</th>
									<td>
										<input type="radio" id="build_file_format_aab" name="build_file_format" checked value="aab">
										<label for="build_file_format_aab"><?php echo esc_html__( 'AAB File (recommended)', 'buddyboss-app' ); ?></label><br>
										<input type="radio" id="build_file_format_apk" name="build_file_format" value="apk">
										<label for="build_file_format_apk"><?php echo esc_html__( 'APK File', 'buddyboss-app' ); ?></label><br>
										<p class="description"><?php esc_html_e( 'APK files can only be uploaded to apps published in the Google Play Store prior to August 2021.', 'buddyboss-app' ); ?></p>
									</td>
								</tr>
								</tbody>
							</table>
							<br/>
							<div class="flex bbapp-upload-block__ctrl">
								<button disabled type="submit" name="submit"
										class="button button-primary submitbtn">
									<div class="bbapp_loading dark" style="display: none"></div>
									<?php esc_attr_e( 'Download Build', 'buddyboss-app' ); ?>
								</button>

								<a class="button button-secondary extbtn" href="https://play.google.com/console/developers/" target="_blank"><?php esc_attr_e( 'Go to Google Play Console', 'buddyboss-app' ); ?>
									<span class="dashicons dashicons-external"></span>
								</a>
							</div>
						</form>

						<script>
							jQuery( document ).ready( function() {
								jQuery( '.bbapp-build-id' ).change( function() {
									if ( jQuery( this ).val() !== '' ) {
										jQuery( '.submitbtn' ).prop( 'disabled', false );
										const aabUrl = jQuery( this ).find( 'option:selected' ).attr( 'data-aab-url' );
										if ( '' !== aabUrl ) {
											jQuery( '#build_file_format_aab' ).prop( 'checked', true );
											jQuery( '.bbapp_build_format_wrapper' ).show();
										} else {
											jQuery( '#build_file_format_apk' ).prop( 'checked', true );
											jQuery( '.bbapp_build_format_wrapper' ).hide();
										}
									} else {
										jQuery( '.submitbtn' ).prop( 'disabled', true );
										jQuery( '#build_file_format_apk' ).prop( 'checked', true );
										jQuery( '.bbapp_build_format_wrapper' ).hide();
									}
								} );

								jQuery( '#bbapp-request-build-upload' ).submit( function( e ) {
									e.preventDefault(); // avoid form submit.
									jQuery( '.submitbtn' ).prop( 'disabled', true ).find( '.bbapp_loading' ).show();

									const buildFileFormat = jQuery( 'input[name="build_file_format"]:checked' ).val();
									let bbappBuildUrl = jQuery( '.bbapp-build-id' ).find( 'option:selected' ).attr( 'data-' + buildFileFormat + '-url' );

									if ( '' === bbappBuildUrl ) {
										bbappBuildUrl = jQuery( '.bbapp-build-id' ).find( 'option:selected' ).attr( 'data-apk-url' );
									}

									window.location.href = bbappBuildUrl;

									setTimeout( function() {
										jQuery( '.submitbtn' ).prop( 'disabled', false ).find( '.bbapp_loading' ).hide();
									}, 2000 );
								} );

								<?php if ( ! empty( $build_id ) ) : ?>
								jQuery( '.bbapp-build-id' ).change();
								<?php endif; ?>
							} );
						</script>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
