<?php
/**
 * Upload - Android app.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<h1 class="wp-heading-inline"><?php esc_html_e( 'Upload Build', 'buddyboss-app' ); ?></h1>
<a class="page-title-action button button-primary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build-upload&setting=all-uploads' ) ); ?>">
	<?php esc_html_e( 'Upload History', 'buddyboss-app' ); ?>
</a>
<a class="page-title-action button button-secondary button--builds-heading" href="<?php echo esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-build&setting=all-builds' ) ); ?>">
	<?php esc_html_e( 'Build History', 'buddyboss-app' ); ?>
</a>
<div>
	<?php
	\BuddyBossApp\Admin\SetupAdmin::instance()->render_subtabs( $this->sub_settings(), $this->get_current_sub_tab(), 'setting' );
	?>
</div>

<div class="wrap bbapp-build-uploads-container">
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-build-uploads">
			<div class="bbapp-ie">
				<div class="bbapp-ie__heading bbapp-ie__sub">
					<h2 class="title bbapp-build-upload-heading android">
						<i class="bb-icon-rf bb-icon-brand-android"></i>
						<?php echo esc_attr__( 'Upload to Google Play Console', 'buddyboss-app' ); ?>
					</h2>
				</div>
				<?php require dirname( __DIR__ ) . '/app-is-disabled.php'; ?>
			</div>
		</div>
	</div>
</div>
