<?php
/**
 * Holds app languages HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use BuddyBossApp\AppLanguages;

/**
 * App languages class variable.
 *
 * @var $this \BuddyBossApp\Admin\AppLanguages
 */
$app_languages       = AppLanguages::instance();
$available_languages = $app_languages->get_app_supported_languages();
$active_languages    = $app_languages->get_active_languages();
$_wp_locale          = bbapp_wp_locale_to_app_locale();
$_wp_locale          = ! isset( $available_languages[ $_wp_locale ] ) ? 'en' : $_wp_locale;
$selected_language   = get_option( 'bbapp_selected_language', $_wp_locale );
$selected_language   = in_array( $selected_language, array_keys( $active_languages ), true ) ? $selected_language : $_wp_locale;

$this->show_messages();

// Localize the script with new data.
wp_localize_script(
	'bbapp-script',
	'bbappLanguages',
	array(
		'selectLanguage'          => __( 'Select Language', 'buddyboss-app' ),
		'errorDeletingLanguage'   => __( 'Error deleting language', 'buddyboss-app' ),
		'errorAddingLanguage'     => __( 'Error adding language', 'buddyboss-app' ),
		'errorSwitchingLanguage'  => __( 'Error switching language', 'buddyboss-app' ),
		'translationsSaved'       => __( 'Translations saved successfully.', 'buddyboss-app' ),
		'errorSavingTranslations' => __( 'Error saving translations.', 'buddyboss-app' ),
		'dismissNotice'           => __( 'Dismiss this notice.', 'buddyboss-app' ),
		'deleteLanguageNonce'     => wp_create_nonce( 'bbapp_delete_language_nonce' ),
		'addLanguageNonce'        => wp_create_nonce( 'bbapp_add_language_nonce' ),
		'languagesNonce'          => wp_create_nonce( 'bbapp_languages_nonce' ),
		'wpLocale'                => $_wp_locale,
		'selectedLanguage'        => $selected_language,
		'ajaxurl'                 => admin_url( 'admin-ajax.php' ),
		'per_page'                => $app_languages->per_page,
	)
);
?>

<div class="wrap buddyboss-app-translations">
	<h1 class="title"><?php esc_html_e( 'Translations', 'buddyboss-app' ); ?></h1>
	<form method="post" name="bbapp_languages_form" id="bbapp_languages_form">
		<div class="bbapp_languages_fields">
			<?php wp_nonce_field( 'bbapp_languages_nonce', 'bbapp_languages_nonce' ); ?>
			<div class="language-selector-wrapper">
				<select id="language-selector" class="language-selector">
					<?php
					foreach ( $active_languages as $code => $lang_data ) {
						$selected = ( $code === $selected_language ) ? 'selected' : '';
						// translators: %1$s is the language name.
						$lan_name = $lang_data['is_wp_default'] ? sprintf( __( 'Default WordPress language (%s)', 'buddyboss-app' ), $lang_data['name'] ) : $lang_data['name'];
						printf(
							"<option value='%s' %s data-is-default='%s' title='%s'>%s</option>",
							esc_attr( $code ),
							esc_attr( $selected ),
							( $lang_data['is_wp_default'] ? '1' : '0' ),
							esc_attr( $lan_name ),
							esc_html( $lang_data['name'] )
						);
					}
					?>
				</select>
				<button type="button" class="button button-primary add-language">
					<span class="dashicons dashicons-plus"></span>
					<?php esc_html_e( 'Add Language', 'buddyboss-app' ); ?>
				</button>
			</div>
			<div class="bbapp_lang_table" id="bbapp_lang_table">
				<div class="ap_lang_toolbar wp-filter">
					<div class="ap_lang_toolbar-primary search-form">
						<div class="search-container">
							<input type="text" class="lang-search" placeholder="<?php esc_html_e( 'Search Text...', 'buddyboss-app' ); ?>"/>
						</div>
						<div class="filter-container">
							<?php esc_html_e( 'in', 'buddyboss-app' ); ?>
							<select class="lang-search-by">
								<option value="lang-source" selected>
									<?php esc_html_e( 'Source Text', 'buddyboss-app' ); ?>
								</option>
								<option value="lang-id"><?php esc_html_e( 'Source Text ID', 'buddyboss-app' ); ?></option>
								<option value="lang-translate"><?php esc_html_e( 'Translation', 'buddyboss-app' ); ?></option>
							</select>
						</div>
						<div class="show-empty-container">
							<label for="lang-show-empty" class="show-empty-label">
								<input type="checkbox" class="lang-show-empty" value="1" id="lang-show-empty">
								<span><?php esc_attr_e( 'Show Only Empty', 'buddyboss-app' ); ?></span>
							</label>
						</div>
					</div>

					<div class="ap_lang_toolbar-secondary">
						<button type="button" class="button button-secondary download-csv-button">
							<?php esc_attr_e( 'Download CSV', 'buddyboss-app' ); ?>
						</button>
						<div class="csv-upload-container">
							<label class="button button-secondary upload-csv-label">
								<?php esc_html_e( 'Upload CSV', 'buddyboss-app' ); ?>
								<input type="file" accept="text/csv" id="language_upload" name="language_upload" class="button button-secondary" />
							</label>
							<div class="csv-language-info" title="<?php esc_attr_e( 'Important information about CSV import', 'buddyboss-app' ); ?>">
								<span class="dashicons dashicons-info"></span>
								<div class="csv-language-tooltip">
									<?php esc_html_e( 'Important: Your CSV file must be for the currently selected language. Each exported CSV file contains language code information in its filename (e.g., en-translations.csv) and in the file metadata. For best results, only import files that were previously exported from this system.', 'buddyboss-app' ); ?>
								</div>
							</div>
						</div>
						<button type="submit" name="submit" id="submit" class="button button-primary">
							<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>
						</button>
					</div>
				</div>

				<table class="wp-list-table widefat plugins striped translations-table">
					<thead>
						<tr>
							<th style="width: 50%;"><?php esc_html_e( 'Source Text', 'buddyboss-app' ); ?></th>
							<th style="width: 50%;"><?php esc_html_e( 'Translation', 'buddyboss-app' ); ?></th>
						</tr>
					</thead>
					<tbody class="list"></tbody>
				</table>
				
				<!-- No Results UI - Now inside the table area -->
				<div class="no-result-found" style="display: none">
					<div class="no-results-container">
						<div class="no-results-icon">
							<span class="dashicons dashicons-search"></span>
						</div>
						<h3><?php esc_html_e( 'No translations found', 'buddyboss-app' ); ?></h3>
						<p><?php esc_html_e( 'No matching translations were found for your current filters.', 'buddyboss-app' ); ?></p>
						<button type="button" class="button button-secondary reset-filters">
							<?php esc_html_e( 'Reset Filters', 'buddyboss-app' ); ?>
						</button>
					</div>
				</div>

				<div class="translation_footer">
					<div class="pagination-wrapper">
						<div class="pagination-info">
							<span class="displaying-num"></span>
							<span class="pagination-links">
								<button type="button" class="button prev-page" disabled><span class="dashicons dashicons-arrow-left-alt2"></span></button>
								<span class="paging-input">
									<label for="current-page-selector" class="screen-reader-text">Current Page</label>
									<input class="current-page" id="current-page-selector" type="text" value="1" size="1"> of 
									<span class="total-pages">1</span>
								</span>
								<button type="button" class="button next-page" disabled><span class="dashicons dashicons-arrow-right-alt2"></span></button>
							</span>
						</div>
					</div>
					<div class="actions">
						<button type="button" class="button delete-language" disabled>
							<?php esc_html_e( 'Delete Language', 'buddyboss-app' ); ?>
						</button>
					</div>
				</div>
			</div>
		</div>

		<input name="lang_data" id="lang_data" type="hidden" />
		<input name="lang_data_csv" id="lang_data_csv" type="hidden" />
		<input name="lang_name_csv" id="lang_name_csv" type="hidden" />
		<input name="action" type="hidden" value="bbapp_update_languages"/>
	</form>

	<!-- Add Language Modal -->
	<div id="add-language-modal" class="modal" style="display: none;">
		<div class="modal-content add-language-modal">
			<div class="modal-header">
				<h3><?php esc_html_e( 'Add New Language', 'buddyboss-app' ); ?></h3>
				<button type="button" class="close-modal" aria-label="<?php esc_attr_e( 'Close', 'buddyboss-app' ); ?>">
					<span class="dashicons dashicons-no-alt"></span>
				</button>
			</div>
			<div class="modal-body add-language-body">
				<div class="language-icon">
					<span class="dashicons dashicons-translation"></span>
				</div>
				<div class="language-selector-container">
					<p><?php esc_html_e( 'Select a language to add to your app:', 'buddyboss-app' ); ?></p>
					<select id="new-language-selector" class="language-selector">
						<option value=""><?php esc_html_e( 'Select Language', 'buddyboss-app' ); ?></option>
						<?php
						foreach ( $available_languages as $code => $name ) {
							if ( ! isset( $active_languages[ $code ] ) ) {
								echo '<option value="' . esc_attr( $code ) . '">' . esc_html( $name ) . '</option>';
							}
						}
						?>
					</select>
				</div>
			</div>
			<div class="modal-actions add-language-actions">				
				<button type="button" class="button button-primary confirm-add-language"><?php esc_html_e( 'Add', 'buddyboss-app' ); ?></button>
			</div>
		</div>
	</div>

	<!-- Delete Language Confirmation Modal -->
	<div id="delete-language-modal" class="modal" style="display: none;">
		<div class="modal-content delete-confirmation-modal">
			<div class="modal-header">
				<h3><?php esc_html_e( 'Confirmation Prompt', 'buddyboss-app' ); ?></h3>
				<button type="button" class="close-modal" aria-label="<?php esc_attr_e( 'Close', 'buddyboss-app' ); ?>">
					<span class="dashicons dashicons-no-alt"></span>
				</button>
			</div>
			<div class="modal-body delete-confirmation-body">
				<div class="warning-icon">
					<span class="dashicons dashicons-warning"></span>
				</div>
				<p>
					<?php esc_html_e( 'Are you sure you want to delete', 'buddyboss-app' ); ?> 
					<strong><span class="language-name"></span></strong>? 
					<?php esc_html_e( 'This will permanently remove all translations.', 'buddyboss-app' ); ?>
				</p>
			</div>
			<div class="modal-actions delete-confirmation-actions">
				<button type="button" class="button cancel-delete"><?php esc_html_e( 'Cancel', 'buddyboss-app' ); ?></button>
				<button type="button" class="button button-danger confirm-delete"><?php esc_html_e( 'Delete', 'buddyboss-app' ); ?></button>
			</div>
		</div>
	</div>
</div>

