<?php
/**
 * Holds HTML for single push.
 *
 * @package BuddyBossApp\Notification\Push
 */

use BuddyBossApp\Notification\Helpers;
use BuddyBossApp\Notification\ManualRecipientsList;
use BuddyBossApp\Notification\Push;

?>
<div class="wrap">
	<?php
	$push_id_request = ( ! empty( $_REQUEST['push_id'] ) ) ? bbapp_input_clean( wp_unslash( $_REQUEST['push_id'] ) ) : 0; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$single_push     = isset( $push ) ? $push : Push::instance()->get_notification( $push_id_request );
	?>
	<div id="poststuff">
		<div id="post-body" class="metabox-holder columns-2">

			<div id="postbox-container-1" class="postbox-container">
				<div id="side-sortables">
					<div class="postbox push_notification_box push_status_box">
						<h2><span><?php esc_html_e( 'Notification Details', 'buddyboss-app' ); ?></span></h2>
						<div class="inside">
							<table class="bbapp-push-settings">
								<tbody>
								<tr>
									<th><?php esc_html_e( 'Created', 'buddyboss-app' ); ?></th>
									<td><?php echo wp_kses_post( $this->column_default( (array) $single_push, 'created' ) ); ?></td>
								</tr>
								<?php if ( ! empty( $single_push->is_schedule ) ) { ?>
									<tr>
										<th><?php esc_html_e( 'Schedule', 'buddyboss-app' ); ?></th>
										<td><?php echo wp_kses_post( $this->column_default( (array) $single_push, 'schedule' ) ); ?></td>
									</tr>
								<?php } ?>
								<?php if ( ! empty( $single_push->sent_as ) ) { ?>
									<tr>
										<?php
										$user_id      = $single_push->sent_as;
										$user_details = get_userdata( $single_push->sent_as );
										if ( ! empty( $single_push->status ) ) {
											$notification_status      = $single_push->status;
											$notification_status_data = Helpers::instance()->get_push_status( $single_push->id );
											$send_label               = esc_html__( 'Send as', 'buddyboss-app' );

											if ( '1' !== $single_push->is_schedule && ! empty( $notification_status_data['status'] ) ) {
												if ( 'sent_all' === $notification_status_data['status'] || 'sent' === $notification_status_data['status'] ) {
													$notification_status = 'sent';
												} elseif ( 'failed' === $notification_status_data['status'] ) {
													$notification_status = 'failed';
												}
											}

											if ( in_array(
												$notification_status,
												array(
													'sent',
													'failed',
													'expired',
												),
												true
											) ) {
												$send_label = esc_html__( 'Sent as', 'buddyboss-app' );
											}

											printf( '<th>%1$s</th> <td><a href="%2$s"><strong>%3$s</strong></a></td>', esc_html( $send_label ), esc_url( admin_url( 'user-edit.php?user_id=' . $user_id ) ), esc_html( bbaap_get_user_display_name( $user_id ) ) );
										} else {
											printf( '<th>%1$s</th> <td><a href="%2$s"><strong>%3$s</strong></a></td>', esc_html__( 'Send as', 'buddyboss-app' ), esc_url( admin_url( 'user-edit.php?user_id=' . $user_id ) ), esc_html( bbaap_get_user_display_name( $user_id ) ) );
										}
										?>
									</tr>
								<?php } ?>
								</tbody>
							</table>

						</div>
					</div>

					<div class="postbox push_notification_box">
						<h2>
							<span><?php esc_html_e( 'Status', 'buddyboss-app' ); ?></span>
							<?php
							if ( isset( $single_push->status ) ) {

								$push_status = $single_push->status;
								$status_data = Helpers::instance()->get_push_status( $single_push->id );

								if ( '1' !== $single_push->is_schedule && ! empty( $status_data['status'] ) ) {
									if ( 'sent_all' === $status_data['status'] || 'sent' === $status_data['status'] ) {
										$push_status = 'sent';
									} elseif ( 'failed' === $push_status && 'failed' === $status_data['status'] ) {
										$push_status = 'failed';
									}
								}

								if ( 'sent' === $push_status ) {
									printf( "<span class='push_status push_status_success'>%s</span>", esc_html__( 'Sent', 'buddyboss-app' ) );
								} elseif ( 'pending' === $push_status ) {
									if ( '1' === $single_push->is_schedule ) {
										printf( "<span class='push_status push_status_info'>%s</span>", esc_html__( 'Scheduled', 'buddyboss-app' ) );
									} else {
										printf( "<span class='push_status push_status_info'>%s</span>", esc_html__( 'Pending', 'buddyboss-app' ) );
									}
								} elseif ( 'processing' === $push_status ) {
									printf( "<span class='push_status push_status_info'>%s</span>", esc_html__( 'In Progress', 'buddyboss-app' ) );
								} elseif ( 'expired' === $push_status ) {
									printf( "<span class='push_status push_status_warning'>%s</span>", esc_html__( 'Expired', 'buddyboss-app' ) );
								} elseif ( 'failed' === $push_status ) {
									printf( "<span class='push_status push_status_warning'>%s</span>", esc_html__( 'Failed', 'buddyboss-app' ) );
								} else {
									printf( "<span class='push_status push_status_warning'>%s</span>", esc_html( ucfirst( str_replace( '_', ' ', $push_status ) ) ) );
								}
							}
							?>
						</h2>

						<?php if ( ! empty( $single_push->data['logs'] ) ) { ?>
							<div class="inside">
								<ul class="push_notification_box_list">
									<li>
										<div class="push_content success">
											<?php foreach ( $single_push->data['logs'] as $log ) { ?>
												<p class="meta">
													<?php
													if ( is_array( $log ) ) {
														/* translators: %1$s, %2$s: Date and time of log. */
														$date_time_format = sprintf( _x( '%1$s %2$s', 'date_at_time', 'buddyboss-app' ), get_option( 'date_format' ), get_option( 'time_format' ) );
														$log_time         = get_date_from_gmt( $log['log_time'], $date_time_format );

														printf( '<strong>%1$s</strong> <br /><span>%2$s</span>', wp_kses_post( $log['log_text'] ), esc_html( $log_time ) );
													} else {
														echo wp_kses_post( $log );
													}
													?>
												</p>
											<?php } ?>
										</div>
									</li>
								</ul>
							</div>
						<?php } ?>

					</div>

				</div>
			</div>
			<div id="postbox-container-2" class="postbox-container">
				<div id="normal-sortables">
					<?php if ( 'manual' !== $single_push->agent ) { ?>
						<div class="push-main">
							<div class="postbox bbapp_push_box">
								<div class="inside">
									<div class="push-recipients push-box">
										<span class="push-number"><?php echo esc_html( isset( $single_push->data['send_to'] ) ? $single_push->data['send_to'] : 0 ); ?></span>
										<p><?php echo esc_html( _n( 'Recipient', 'Recipients', $single_push->data['send_to'], 'buddyboss-app' ) ); ?></p>
									</div>
								</div>
							</div>
							<div class="postbox bbapp_push_box">
								<div class="inside">
									<div class="push-devices push-box">
										<?php
										$devices_count = Helpers::instance()->get_devices_count( $single_push->id );
										/* translators: %s: Device count. */
										echo sprintf( _n( '<span class="push-number">%s</span><p>Device</p>', '<span class="push-number">%s</span><p>Devices</p>', esc_html( $devices_count ), 'buddyboss-app' ), esc_html( $devices_count ) ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
										?>
									</div>
								</div>
							</div>
							<div class="postbox bbapp_push_box">
								<div class="inside">
									<div class="push-sent push-box">
									<span class="push-number">
										<?php
										$push_status     = Helpers::instance()->get_push_single_status( $single_push->id );
										$sent_percentage = 0;
										if ( isset( $push_status['total'] ) && ! empty( $push_status['sent'] ) ) {
											$sent_percentage = round( ( $push_status['sent'] * 100 ) / $push_status['total'], 2 );
										}
										echo esc_html( $sent_percentage ) . '%';
										?>
										</span>
										<p><?php echo esc_html__( 'Sent', 'buddyboss-app' ); ?></p>
									</div>
								</div>
							</div>
							<div class="postbox bbapp_push_box">
								<div class="inside">
									<div class="push-delivered push-box">
									<span class="push-number">
										<?php
										$delivered_percentage = 0;
										if ( isset( $push_status['total'] ) && ! empty( $push_status['delivery'] ) ) {
											$delivered_percentage = round( ( $push_status['delivery'] * 100 ) / $push_status['total'], 2 );
										}
										echo esc_html( $delivered_percentage ) . '%';
										?>
									</span>
										<p><?php echo esc_html__( 'Delivered', 'buddyboss-app' ); ?></p>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
					<div class="postbox push_notification_details">
						<div class="inside">
							<table>
								<tbody>
								<?php if ( ! empty( $single_push->primary_text ) ) { ?>
									<tr>
										<th><?php echo esc_html( $single_push->primary_text ); ?></th>
									</tr>
								<?php } ?>
								<?php if ( ! empty( $single_push->secondary_text ) ) { ?>
									<tr>
										<td><?php echo esc_html( nl2br( $single_push->secondary_text ) ); ?></td>
									</tr>
								<?php } ?>
								<?php if ( ! empty( $single_push->data['link'] ) ) { ?>
									<tr>
										<td><?php printf( '<span><a href="%1$s">%2$s</a></span>', esc_url( $single_push->data['link'] ), esc_url( $single_push->data['link'] ) ); ?></td>
									</tr>
								<?php } ?>
								</tbody>
							</table>
						</div>

					</div>
					<div class="bbapp-recipients-wrap">
						<div id="poststuff">
							<div id="post-body">
								<h2><?php esc_html_e( 'Recipients ', 'buddyboss-app' ); ?></h2>
								<div id="post-body-content">
									<form method="get">
										<?php
										$recipients_obj = new ManualRecipientsList();
										$recipients_obj->prepare_items();
										if ( 'manual' !== $single_push->agent ) {
											$recipients_obj->search_box( 'Search', 'search' );
										}
										$recipients_obj->display();
										?>
									</form>
								</div>
							</div>
							<br class="clear">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
