<?php
/**
 * New notification page.
 *
 * @package BuddyBossApp/Notifications
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

wp_enqueue_script( 'jquery-ui-datepicker' );
wp_register_style( 'jquery-ui', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/smoothness/jquery-ui.min.css', array(), bbapp()->plugin_version );
wp_enqueue_style( 'jquery-ui' );
wp_enqueue_style( 'bbapp-bootstrap-datepicker' );
wp_enqueue_script( 'bbapp-bootstrap-datepicker' );

?>
<div class="wrap">

	<?php
	$mytab = 'new';


	$controller = \BuddyBossApp\Admin\Notification\Compose::instance();

	$composer_id = $controller->get_compose_id();

	$controller->show_messages();

	wp_localize_script(
		'bbapp-script',
		'userObj',
		array(
			'users'         => $controller->admin_users_options(),
			'currentUserID' => get_current_user_id(),
			'app_id'        => \BuddyBossApp\ManageApp::instance()->get_app_id(),
		)
	);

	$get_segment_id = $controller->get_user_segment_id();

	$user_segment = \BuddyBossApp\UserSegment::instance();

	?>

	<div class="wrap">

		<?php
		if ( ! isset( $_GET['notification_sent'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Recommended, Squiz.PHP.EmbeddedPhp.ContentBeforeEnd ?>

			<?php if ( ! bbapp_get_app_push_instance() ) : ?>
				<div class="notice notice-error">
					<p><?php esc_html_e( 'Please configure', 'buddyboss-app' ); ?> <a
							href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-configure&setting=firebase' ) ); ?>"><?php esc_html_e( 'Firebase Settings', 'buddyboss-app' ); ?></a> <?php esc_html_e( 'to use Push Notifications.', 'buddyboss-app' ); ?>
					</p>
				</div>
			<?php endif; ?>

			<div class="bbapp-pushnotifications">

				<?php if ( ! bbapp_get_app_push_instance() ) : ?>
					<div class="push-disabled"></div>
				<?php endif; ?>

				<form method="POST" id="bbapp-pushnotif-new">

					<input type="hidden" name="action" value="bbapp_push_submit">
					<input type="hidden" name="compose_id" value="<?php echo esc_attr( $composer_id ); ?>">

					<?php wp_nonce_field( 'manual_push_nonce' ); ?>

					<div class="bbapp-push-palette bbapp-content-wrap">

						<div class="bbapp-content-left">
							<div class="bbapp-content-left-inner">

								<?php if ( ! bbapp_get_app_push_firebase_key() ) : ?>

									<div class="bbapp-accordion-header flex align-center">
										<h2><?php esc_html_e( 'Send Push Notification', 'buddyboss-app' ); ?></h2>
									</div>

									<p class="bbapp-accordion-notice"><?php esc_html_e( 'Please configure', 'buddyboss-app' ); ?>
										<a href="<?php echo esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-configure&setting=firebase' ) ); ?>"><?php esc_html_e( 'Firebase Settings', 'buddyboss-app' ); ?></a> <?php esc_html_e( 'to use Push Notifications.', 'buddyboss-app' ); ?>
									</p>

								<?php else : ?>

									<div class="bbapp-accordion">
										<div class="bbapp-accordion-item bbapp-accordion-item--first active">
											<div class="bbapp-accordion-header flex align-center">
												<span class="bbapp-accordion__step">
													<i>
													<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="32"
														height="32" viewBox="0 0 32 32">
													<title>pencil</title>
													<path
														d="M5.344 21.888v4.768h4.768l16-16-4.768-4.768-16 16zM22.272 3.040l6.688 6.688c0.239 0.243 0.387 0.576 0.387 0.944s-0.148 0.701-0.387 0.944l-17.344 17.344c-0.242 0.238-0.574 0.384-0.941 0.384-0.007 0-0.014-0-0.020-0h-6.655c-0.742 0-1.344-0.602-1.344-1.344v0-6.656c0.004-0.378 0.162-0.718 0.415-0.96l0.001-0 17.312-17.344c0.243-0.239 0.576-0.387 0.944-0.387s0.701 0.148 0.944 0.387l-0-0z"></path>
													</svg>
													</i>
												<span>1</span></span>
												<span class="bbapp-accordion__icon">
													<i class="bb-icon-l bb-icon-bell"></i>
												</span>
												<h2><?php esc_html_e( 'Push Notification', 'buddyboss-app' ); ?></h2>
												<span class="bbapp-accordion__step-status"></span>
											</div>

											<div class="bbapp-accordion-body">

												<div class="bbapp-row">
													<div class="bbapp-row__prime">
														<?php esc_html_e( 'Notification Title', 'buddyboss-app' ); ?> <span><?php esc_html_e( '(optional)', 'buddyboss-app' ); ?></span>
													</div>
													<div class="bbapp-row__base">
														<input type="text" maxlength="50" name="primary_text"
															value="<?php echo esc_attr( $this->entry_data( 'primary_text' ) ); ?>"
															placeholder="<?php esc_html_e( 'Enter Title', 'buddyboss-app' ); ?>"
															class="regular-text bbapp-push-field"
															data-title="bbapp-push-title" id='push-text'>
														<div class="field-description">
															<div class="charscountholder"><span
																	class="charscount green">50</span> <?php esc_html_e( 'characters remaining', 'buddyboss-app' ); ?>
															</div>
														</div>
													</div>
												</div>

												<div class="bbapp-row bbapp-message-text">
													<div class="bbapp-row__prime">
														<?php esc_html_e( 'Notification Message', 'buddyboss-app' ); ?>
													</div>
													<div class="bbapp-row__base">
														<textarea style="min-height: 80px;height: 80px;resize: none;"
															maxlength="400"
															placeholder="<?php esc_html_e( 'Enter Message', 'buddyboss-app' ); ?>"
															name="secondary_text" class="regular-text bbapp-push-field"
															data-title="bbapp-push-text"
															id='push-textarea'><?php echo esc_attr( $this->entry_data( 'secondary_text' ) ); ?></textarea>
														<div class="field-description">
															<div class="charscountholder"><span
																	class="charscount green">400</span> <?php esc_html_e( 'characters remaining', 'buddyboss-app' ); ?>
															</div>
														</div>
													</div>
												</div>

												<div class="bbapp-row bbapp-link-url">
													<div class="bbapp-row__prime">
														<?php esc_html_e( 'Link URL', 'buddyboss-app' ); ?> <span><?php esc_html_e( '(optional)', 'buddyboss-app' ); ?></span>
													</div>
													<div class="bbapp-row__base">
														<input class="regular-text" id='bbapp-push-link' type="text"
															name="link_url"
															value="<?php echo isset( $_POST['link_url'] ) ? esc_url( bbapp_input_clean( wp_unslash( $_POST['link_url'] ) ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized ?>"
															placeholder="<?php esc_attr_e( 'eg. https://www.google.com', 'buddyboss-app' ); ?>"/>
														<div class="field-description">
															<p class="description"><?php esc_html_e( 'The link will open when the notification is tapped.', 'buddyboss-app' ); ?></p>
														</div>
													</div>
												</div>

												<div class="bbapp-row send-as-list">
													<div class="bbapp-row__prime">
														<?php esc_html_e( 'Send as', 'buddyboss-app' ); ?>
													</div>
													<div class="bbapp-row__base">
														<select class="send_as" name="send_as"></select>
													</div>
												</div>

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<button type="submit" id="btn-push-second" class="button button-primary">
															<?php esc_html_e( 'Next', 'buddyboss-app' ); ?>
														</button>
													</div>
												</div>

											</div>
										</div>

										<div class="bbapp-accordion-item bbapp-accordion-item--second">
											<div class="bbapp-accordion-header flex align-center">
												<span class="bbapp-accordion__step">2</span>
												<span class="bbapp-accordion__icon">
													<i class="bb-icon-l bb-icon-clock"></i>
												</span>
												<h2><?php esc_html_e( 'Schedule Notification', 'buddyboss-app' ); ?></h2>
												<span class="bbapp-accordion__step-status"></span>
											</div>

											<div class="bbapp-accordion-body">

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<div class="field-description">
															<p class="description"><?php esc_html_e( 'You can schedule push notifications to send immediately or any time within the next 30 days.', 'buddyboss-app' ); ?></p>
														</div>
													</div>
												</div>

												<div class="bbapp-row bbapp-delivery">
													<div class="bbapp-row__base">
														<fieldset
															class="bbapp-push-radio-grid bbapp-push-schedule flex align-center">
															<label>
																<input type="radio" name="schedule" value="0" checked="1"/> <?php esc_html_e( 'Send Immediately', 'buddyboss-app' ); ?>
															</label>
														</fieldset>
														<fieldset
															class="bbapp-push-radio-grid bbapp-push-schedule flex align-center">
															<label>
																<input type="radio" name="schedule" value="1"/> <?php esc_html_e( 'Send Later', 'buddyboss-app' ); ?>
															</label>
														</fieldset>
													</div>
												</div>

												<div class="bbapp-row schedule_date_container" style="display:none">
													<div class="bbapp-row__base">
														<div class="schedule_date_box">
															<div class="bbapp-column">
																<label><?php esc_html_e( 'Date', 'buddyboss-app' ); ?></label>
																<input class="bbapp_date" type="text"
																	name="date_schedule" autocomplete="off"/>
															</div>

															<div class="bbapp-column">
																<label><?php esc_html_e( 'Time', 'buddyboss-app' ); ?></label>
																<select name="date_schedule_time" class="bbapp_time">
																	<?php
																	for ( $i = 1; $i <= 24; $i ++ ) {
																		$time   = "$i:00";
																		$time12 = date( 'g:i a', strtotime( $time ) ); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
																		echo sprintf( '<option value="%1$s">%2$s</option>', esc_attr( $time ), esc_html( $time12 ) );
																	}
																	?>
																</select>
															</div>

															<?php
															$current_offset = get_option( 'gmt_offset' );
															$tzstring       = get_option( 'timezone_string' );

															$check_zone_info = true;

															// Remove old Etc mappings. Fallback to gmt_offset.
															if ( false !== strpos( $tzstring, 'Etc/GMT' ) ) {
																$tzstring = '';
															}

															if ( empty( $tzstring ) ) { // Create a UTC+- zone if no timezone string exists.
																$check_zone_info = false;
																if ( 0 === $current_offset ) {
																	$tzstring = 'UTC+0';
																} elseif ( $current_offset < 0 ) {
																	$tzstring = 'UTC' . $current_offset;
																} else {
																	$tzstring = 'UTC+' . $current_offset;
																}
															}

															$allowed_html             = array();
															$allowed_html['optgroup'] = array(
																'label' => true,
															);
															$allowed_html['option'] = array(
																'selected' => true,
																'value'    => true,
															);
															?>

															<div class="bbapp-column">
																<label><?php esc_html_e( 'Timezone', 'buddyboss-app' ); ?></label>
																<select id="date_schedule_timezone"
																	name="date_schedule_timezone"
																	aria-describedby="timezone-description">
																	<?php echo wp_kses( wp_timezone_choice( $tzstring, get_user_locale() ), $allowed_html ); ?>
																</select>
															</div>
														</div>
													</div>
												</div>

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<button type="submit" id="btn-push-third" class="button button-primary">
															<?php esc_html_e( 'Next', 'buddyboss-app' ); ?>
														</button>
													</div>
												</div>

											</div>
										</div>

										<div class="bbapp-accordion-item bbapp-accordion-item--third">
											<div class="bbapp-accordion-header flex align-center">
												<span class="bbapp-accordion__step">3</span>
												<span class="bbapp-accordion__icon">
													<i class="bb-icon-l bb-icon-user-friends-alt"></i>
												</span>
												<h2><?php esc_html_e( 'Select Members', 'buddyboss-app' ); ?></h2>
												<span class="bbapp-accordion__step-status"></span>
											</div>

											<div class="bbapp-accordion-body">

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<div class="field-description">
															<p class="description"><?php esc_html_e( 'Select which app members should get this notification. Only members who have downloaded and logged into your app will receive notifications.', 'buddyboss-app' ); ?></p>
														</div>
													</div>
												</div>

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<fieldset>
															<label>
																<input type="radio" name="send_to" value="all_users" checked/> <?php esc_html_e( 'All members', 'buddyboss-app' ); ?>
															</label>
														</fieldset>
													</div>
												</div>

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<fieldset>
															<label>
																<input type="radio" name="send_to" value="specific_users"/> <?php esc_html_e( 'Specific members', 'buddyboss-app' ); ?>
															</label>
														</fieldset>
													</div>
												</div>

												<div id="specific_users_wrap" class="bbapp-row" style="display: none;">
													<div class="bbapp-row__base">
														<select class="choose_recipients abb_push_choose_recipients">
															<option value=""><?php esc_html_e( 'Start typing name to add..', 'buddyboss-app' ); ?></option>
														</select>
													</div>
													<div class="bbapp-row__base">
														<div id="tmpl-tbl-notifications_user_list" class="tmpl-tbl-notifications_user_list">
															<div class="loading_screen" style="display: none;">
																<p>
																	<?php esc_html_e( 'Fetching members...', 'buddyboss-app' ); ?>
																	<span class="bbapp_loading"
																		style="display:none"></span>
																</p>
															</div>
															<div id="tmpl-notifications_user_list_wrap">
																<div class="users notifications-users">
																	<p>
																		<?php esc_html_e( 'No recipients selected yet.', 'buddyboss-app' ); ?>
																	</p>
																</div>
															</div>
															<ul class="pagination">
															</ul>
														</div>
													</div>
												</div>

												<div class="bbapp-row bbapp-send-to">
													<div class="bbapp-row__base">
														<fieldset>
															<label>
																<input type="radio" name="send_to" value="filter_users"/> <?php esc_html_e( 'Filter members', 'buddyboss-app' ); ?>
															</label>
														</fieldset>
													</div>
												</div>

												<div id="notifications_filters_wrap"
													style="display: none;">
													<div class="bbapp-row">
														<div class="bbapp-row__base">
															<?php $user_segment->get_form( $this->get_user_segment_id() ); ?>
														</div>
													</div>
												</div>

												<div class="bbapp-row">
													<div class="bbapp-row__base">
														<button type="submit" id="btn-notifications-submit"
															class="button button-primary">
															<span id="btn-notifications-submit-val"><?php esc_html_e( 'Send Notification', 'buddyboss-app' ); ?></span>
														</button>
														<div class="bbapp_loading"
															style="display:none; bottom: -1px;"></div>
														<div id="tmpl-tbl-notifications_count_description"><?php esc_html_e( 'Sending to', 'buddyboss-app' ); ?> <span id="tmpl-notifications-member-count">0</span> <?php esc_html_e( 'members', 'buddyboss-app' ); ?></div>
													</div>
												</div>

											</div>
										</div>
									</div>

								<?php endif; ?>

							</div>
						</div>

						<div class="bbapp-screen-wrapper bbapp-screen-wrapper--push-new">
							<?php include bbapp()->plugin_dir . 'views/preview/main.php'; ?>
						</div>

					</div>

				</form>
			</div>
		<?php } else { ?>

			<div class="bbapp-push-sent">

				<?php
				if ( isset( $_GET['notification_sent'] ) && '1' === bbapp_input_clean( wp_unslash( $_GET['notification_sent'] ) ) ) :  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
					?>
					<span class="bbapp-push-sent-icon"><i class="bb-icon-rl bb-icon-check"></i></span>

					<h4>
						<?php esc_html_e( 'Notification was sent.', 'buddyboss-app' ); ?>
					</h4>

				<?php else : ?>

					<span class="bbapp-push-sent-icon"><i class="bb-icon-rl bb-icon-check"></i></span>

					<h4>
						<?php esc_html_e( 'Notification is scheduled.', 'buddyboss-app' ); ?>
					</h4>

				<?php endif; ?>

				<p>
					<?php
					$view_all_link = \BuddyBossApp\Notification\Push::instance()->get_view_all_link();
					$new_link      = \BuddyBossApp\Notification\Push::instance()->get_new_notification_link();
					echo sprintf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'Your notification has been sent.', 'buddyboss-app' ), esc_url( $view_all_link ), esc_html__( 'Click here', 'buddyboss-app' ), esc_html__( 'to view all notifications.', 'buddyboss-app' ) );
					?>
				</p>

			</div>

		<?php } ?>
	</div>
</div>
<script>
	jQuery( document ).ready( function() {
		jQuery( '.bbapp_date' ).datepicker( { startDate: ( new Date() ), endDate: '+30D' } );

		// Show Hide Schedule Advance Fields.
		jQuery( "input[name='schedule']" ).change( function() {
			if ( jQuery( this ).val() === '1' ) {
				jQuery( '.schedule_date_container' ).show();
			} else {
				jQuery( '.schedule_date_container' ).hide();
			}
		} );

		// Show Hide Link URL.
		jQuery( "input[name='link']" ).change( function() {
			jQuery( '.bbapp-link-url' ).toggle( ( jQuery( this ).is( ':checked' ) ) );
		} );

		/**
		 * Show settings of selected notification.
		 */
		jQuery( "select[name='notification_type']" ).change( function() {
			jQuery( '.push_notification_settings' ).hide();
			jQuery( '.push_notification_settings_' + jQuery( this ).val() ).show();
		} );
	} );
</script>

<style>
	/**
		Select2 Input Styling.
	 */
	.select2-dropdown {
		border: 1px solid #44444459;
	}

	.select2-container--default .select2-search--dropdown .select2-search__field {
		min-width: 100%;
		border-radius: 6px;
		border-color: #00000052;
		margin: auto;
		display: block;
	}
</style>
