<?php
/**
 * Require Script.
 * Notification form.
 *
 * @package BuddyBossApp/UserSegment
 */

wp_enqueue_style( 'bbapp-bootstrap-datepicker' );
wp_enqueue_script( 'bbapp-bootstrap-datepicker' );

?>
<div class="field-description">
	<p class="description"><?php esc_html_e( 'Notifications will only be sent to members who match all filter conditions.', 'buddyboss-app' ); ?></p>
</div>

<div class="bbapp_user_segment">
	<?php wp_nonce_field( 'bbapp_user_segment_nonce', 'bbapp_user_segment_nonce' ); ?>
	<input name="bbapp_segment_id" id="bbapp_segment_id" type="hidden"
		value="<?php echo( ( $segment_id ) ? esc_attr( $segment_id ) : '' ); ?>">
		<div class="dialog" id="segment_filters_items">

		<div class="segment_filters_item">

			<a class="removeEle"><span class="dashicons dashicons-dismiss"></span></a>

			<select class="choose_filter">
				<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>

				<?php foreach ( $this->filters_groups as $filters_group_name => $filters_group ) : ?>

					<?php if ( $filters_group['show_child'] ) { ?>
						<?php
						if ( isset( $this->filters_groups[ $filters_group_name ] ) && is_array( $this->filters[ $filters_group_name ] ) ) {

							foreach ( $this->filters[ $filters_group_name ] as $filter_name => $filter ) :
								?>
								<option
									<?php
									if ( ! $filter['enabled'] ) {
										disabled( true );
									}
									?>
									data-fields="<?php echo esc_attr( isset( $filter['fields'] ) ? wp_json_encode( $filter['fields'] ) : '' ); ?>"
									value="<?php echo esc_attr( $filters_group_name . '_' . $filter_name ); ?>"><?php echo esc_html( $filter['label'] ); ?>
								</option>
								<?php
							endforeach;

						}
						?>
					<?php } else { ?>
						<option
							data-sub_filter="1"
							<?php
							if ( ! $filters_group['enabled'] ) {
								disabled( true );
							}
							?>
							value="<?php echo esc_attr( $filters_group_name ); ?>"><?php echo esc_html( $filters_group['label'] ); ?></option>
					<?php } ?>

				<?php endforeach; ?>
			</select>

			<?php foreach ( $this->filters_groups as $filters_group_name => $filters_group ) : ?>
				<?php if ( empty( $filters_group['show_child'] ) ) { ?>
					<select id="sub_filter-<?php echo esc_attr( $filters_group_name ); ?>" class="choose_sub_filter hide" disabled>
						<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>
						<?php
						if ( isset( $this->filters_groups[ $filters_group_name ] ) && is_array( $this->filters[ $filters_group_name ] ) ) {

							foreach ( $this->filters[ $filters_group_name ] as $filter_name => $filter ) :
								?>
								<option
									<?php
									if ( ! $filter['enabled'] ) {
										disabled( true );
									}
									?>
									data-fields="<?php echo esc_attr( isset( $filter['fields'] ) ? wp_json_encode( $filter['fields'] ) : '' ); ?>"
									value="<?php echo esc_attr( $filters_group_name . '_' . $filter_name ); ?>"><?php echo esc_html( $filter['label'] ); ?>
								</option>
								<?php
							endforeach;

						}
						?>
					</select>
				<?php } ?>
			<?php endforeach; ?>

			<div class="segment_filters_item_lists"></div>
		</div>

		<div id="segment_filters_clone_item" class="hide">

			<a class="removeEle"><span class="dashicons dashicons-dismiss"></span></a>

			<select class="choose_filter">
				<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>

				<?php foreach ( $this->filters_groups as $filters_group_name => $filters_group ) : ?>

					<?php if ( $filters_group['show_child'] ) { ?>
						<?php
						if ( isset( $this->filters_groups[ $filters_group_name ] ) && is_array( $this->filters[ $filters_group_name ] ) ) {

							foreach ( $this->filters[ $filters_group_name ] as $filter_name => $filter ) :
								?>
								<option
									<?php
									if ( ! $filter['enabled'] ) {
										disabled( true );
									}
									?>
									data-fields="<?php echo esc_attr( isset( $filter['fields'] ) ? wp_json_encode( $filter['fields'] ) : '' ); ?>"
									value="<?php echo esc_attr( $filters_group_name . '_' . $filter_name ); ?>"><?php echo esc_html( $filter['label'] ); ?></option>

								<?php
							endforeach;

						}
						?>
					<?php } else { ?>
						<option
							data-sub_filter="1"
							<?php
							if ( ! $filters_group['enabled'] ) {
								disabled( true );
							}
							?>
							value="<?php echo esc_attr( $filters_group_name ); ?>"><?php echo esc_html( $filters_group['label'] ); ?></option>
					<?php } ?>

				<?php endforeach; ?>
			</select>

			<?php foreach ( $this->filters_groups as $filters_group_name => $filters_group ) : ?>
				<?php if ( empty( $filters_group['show_child'] ) ) { ?>
					<select id="sub_filter-<?php echo esc_attr( $filters_group_name ); ?>" class="choose_sub_filter hide" disabled>
						<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>
						<?php
						if ( isset( $this->filters_groups[ $filters_group_name ] ) && is_array( $this->filters[ $filters_group_name ] ) ) {

							foreach ( $this->filters[ $filters_group_name ] as $filter_name => $filter ) :
								?>
								<option
									<?php
									if ( ! $filter['enabled'] ) {
										disabled( true );
									}
									?>
									data-fields="<?php echo ( isset( $filter['fields'] ) ) ? esc_attr( wp_json_encode( $filter['fields'] ) ) : ''; ?>"
									value="<?php echo esc_attr( $filters_group_name . '_' . $filter_name ); ?>"><?php echo esc_html( $filter['label'] ); ?></option>

								<?php
							endforeach;

						}
						?>
					</select>
				<?php } ?>
			<?php endforeach; ?>

			<div class="segment_filters_item_lists"></div>
		</div>
	</div>

	<div class="actions">
		<a href="#" id="segment_filters_add" class="button"><?php esc_html_e( '+ Add Filter', 'buddyboss-app' ); ?></a>
	</div>
</div>

<!--Scripts Templates-->
<?php $this->filter_templates(); ?>

<?php do_action( 'bbapp_user_segment_render_scripts' ); ?>

<script>

	/**
	 * Function will add new filter.
	 * *
	 */

	window.bbapp_filters_index = 0;

		function bbappSegmentAddFilter( element, filterName, fields ) {
			const filterHtml = jQuery( '<div class="bbapp_segment_filters_item_' + filterName + '">\n' +
				'</div>' );

			filterHtml.attr( 'data-bbapp-usegment-filter', filterName );

			// Go thru all fields for this filter.
			for ( let i = 0; i < fields.length; i++ ) {
				const fieldName = fields[ i ];

				// Get the HTML of the field.
				const fieldTemplate = wp.template( 'bbapp_usegment_field_' + fieldName );
				const _cloneField = jQuery( fieldTemplate( {
					_filter: filterName,
					_index: window.bbapp_filters_index,
				} ) );

				_cloneField.attr( 'data-bbapp-usegment-field', fieldName );

				// Append field into filter html container.
				filterHtml.append( _cloneField );
			}

			// Add More Required Fields.
			const _input = jQuery( '<input />' )
				.attr( 'type', 'hidden' )
				.attr( 'name', "<?php echo esc_js( $this->get_form_field_name( 'filter' ) ); ?>[" + window.bbapp_filters_index + ']' )
				.attr( 'value', filterName );

			filterHtml.append( _input );

			// Add the Filter Into Filter List Container.
			filterHtml.hide();
			jQuery( element.parent().find( '.segment_filters_item_lists' ).get( 0 ) ).html( filterHtml );
			filterHtml.fadeIn();

			// Process Date Fields on Newly added Elements.
			window.bbappCore.core.load_bbapp_date_pickers();

			// Increase the index number for next filter uniqueness.
			window.bbapp_filters_index++;
		}

	jQuery( document ).ready( function() {
		let segmentRequest = null;

		/**
		 * Add Filter Clicked
		 * *
		 */
		jQuery( '#segment_filters_add' ).click( function( e ) {
			e.preventDefault();
			jQuery( '#segment_filters_clone_item' ).clone().insertBefore( '#segment_filters_clone_item' ).removeAttr( 'id' ).removeClass( 'hide' ).addClass( 'segment_filters_item' );
		} );

		/**
		 * Remove filter
		 * *
		 */
		// Add Remove Event
		jQuery( document ).on( 'click', '.segment_filters_item .removeEle', function( e ) {
			e.preventDefault();
			jQuery( this ).parent().fadeOut( function() {
				jQuery( this ).remove();
			} );

			setTimeout( function() {
				if ( jQuery( '.segment_filters_item' ).length > 0 ) {
					usegmentCheck();
				} else {
					jQuery( '#bbapp-pushnotif-new' ).addClass( 'certify--members' );
				}
			}, 500 );
		} );

		/**
		 * Show sub filter or filter items UI on filter change.
		 * *
		 */
		jQuery( document ).on( 'change', '.choose_filter', function() {
			const subFilter = jQuery( this ).find( ':selected' ).data( 'sub_filter' );
			if ( subFilter === 1 ) {
				jQuery( this ).parent().find( '.choose_sub_filter' ).addClass( 'hide' ).attr( 'disabled', 'disabled' );
				const elementSubFilter = jQuery( this ).parent().find( '#sub_filter-' + jQuery( this ).val() );
				if ( elementSubFilter.length ) {
					jQuery( elementSubFilter.parent().find( '.segment_filters_item_lists' ).get( 0 ) ).html( '' );
					elementSubFilter.val( '' );
					elementSubFilter.removeClass( 'hide' ).removeAttr( 'disabled' );
				}
			} else {
				jQuery( this ).parent().find( '.choose_sub_filter' ).addClass( 'hide' ).attr( 'disabled', 'disabled' );

				// Add filter items UI on filter change.
				const element = jQuery( this );
				const fields = element.find( ':selected' ).data( 'fields' );

				if ( element.val() ) {
					bbappSegmentAddFilter( element, element.val(), fields );
				}

				if ( element.val() === '' ) {
					jQuery( element.parent().find( '.segment_filters_item_lists' ).get( 0 ) ).html( '' );
				}
			}

			chooseFilterUsegmentCheck();

			jQuery( '#choose_filter' ).trigger( 'segment_filter_updated' );
		} );

		jQuery( document ).on( 'change', '.choose_sub_filter', function() {
			const element = jQuery( this );
			const fields = element.find( ':selected' ).data( 'fields' );
			if ( element.val() !== '' ) {
				bbappSegmentAddFilter( element, element.val(), fields );
			}

			jQuery( '#choose_sub_filter' ).trigger( 'segment_filter_updated' );

			if ( element.val() === '' ) {
				jQuery( element.parent().find( '.segment_filters_item_lists' ).get( 0 ) ).html( '' );
			}

			chooseFilterUsegmentCheck();
		} );

		/**
		 * Start Preparing Process
		 */
		jQuery( document ).on( 'change', '.segment_filters_item_lists select, .segment_filters_item_lists input', function( e ) {
			e.preventDefault();
			if ( jQuery( this ).hasClass( 'disabled' ) ) {
				return false;
			}
			bbappRenderLoadingScreen();
			const formdata = jQuery( '.bbapp_user_segment *' ).serializeArray();
			formdata.push( { name: 'action', value: 'bbapp_user_segment' } );

			if ( segmentRequest !== null ) {
				segmentRequest.abort();
				bbappRenderLoadingScreen();
			}

			segmentRequest = jQuery.post( ajaxurl, formdata );
			segmentRequest.done( function( data ) {
				bbappDoProcessRequest( data );
			} );
			segmentRequest.error( function() {
			} );

			const checked = jQuery( '#bbapp-pushnotif-new .bbapp_usegment_checkbox_select' ).find( ':checked' ).length;
			if ( checked ) {
				jQuery( '#bbapp-pushnotif-new' ).removeClass( 'certify--members' );
			} else {
				jQuery( '#bbapp-pushnotif-new' ).addClass( 'certify--members' );
			}
		} );

		function usegmentCheck() {
			const checked = jQuery( '#bbapp-pushnotif-new .bbapp_usegment_checkbox_select' ).find( ':checked' ).length;
			if ( checked ) {
				jQuery( '#bbapp-pushnotif-new' ).removeClass( 'certify--members' );
			}
		}

		function chooseFilterUsegmentCheck() {
			if ( jQuery( '#bbapp-pushnotif-new .bbapp_usegment_checkbox_select' ).length === 0 ) {
				jQuery( '#bbapp-pushnotif-new' ).addClass( 'certify--members' );
			} else {
				usegmentCheck();
			}
		}

		/**
		 * Here we will render loading screen based on filters are there or not.
		 */
		function bbappRenderLoadingScreen() {
			const submitBtn = jQuery( '#btn-notifications-submit' );
			submitBtn.prop( 'disabled', true );
			submitBtn.next( '.bbapp_loading' ).show();

			const loadingScreen = jQuery( '#tmpl-tbl-notifications_user_list .loading_screen' );
			loadingScreen.find( '.bbapp_loading' ).show();
			loadingScreen.show();
			jQuery( '#tmpl-notifications_user_list_wrap' ).addClass( 'blur' );
		}

		/**
		 * Cancels the loading screen.
		 */
		function bbappHideLoadingScreen() {
			const loadingScreen = jQuery( '#tmpl-tbl-notifications_user_list .loading_screen' );
			jQuery( '#tmpl-notifications_user_list_wrap' ).removeClass( 'blur' );
			loadingScreen.find( '.bbapp_loading' ).hide();
			loadingScreen.hide();

			const submitBtn = jQuery( '#btn-notifications-submit' );
			submitBtn.prop( 'disabled', false );
			submitBtn.next( '.bbapp_loading' ).hide();
		}

		function bbappDoProcessRequest( response ) {
			try {
				if ( response.success ) {
					// if queue is smaller than 1 than it's means process is finished.
					if ( response.data.queue.length < 1 ) {
						jQuery( '#btn-notifications-submit' ).trigger( 'segment_select_completed' );

						// close dialog.
						jQuery( '.bbapp_user_segment' ).removeClass( 'open' );
						// update the segment_id in form.
						jQuery( '#bbapp_segment_id' ).val( response.data.id );
						return true;
					}
				} else {
					bbappHideLoadingScreen();
					jQuery( '.bbapp-message' ).remove();
					jQuery( '.bbapp-pushnotifications' ).before( "<div id='message' class='bbapp-message'><p>" + response.data + '</p></div>' );
					jQuery( '#bbapp-pushnotif-new' ).addClass( 'certify--members' );
					return false;
				}
			} catch ( err ) {
				// eslint-disable-next-line no-console
				console.log( err );
				// eslint-disable-next-line no-alert
				alert( " <?php esc_attr_e( 'Unknown Error while processing request. Please try again later.', 'buddyboss-app' ); ?> " );
				bbappHideLoadingScreen();
				return false;
			}

			const btn = jQuery( this );
			btn.prop( 'disabled', true );

			const formdata = jQuery( '.bbapp_user_segment *' ).serializeArray();
			formdata.push( { name: 'action', value: 'bbapp_user_segment' } );
			formdata.push( { name: 'process', value: '1' } ); // process confirm segment don't starts again.

			if ( segmentRequest !== null ) {
				segmentRequest.abort();
				bbappRenderLoadingScreen();
			}
			segmentRequest = jQuery.post( ajaxurl, formdata );
			segmentRequest.done( function( data ) {
				bbappDoProcessRequest( data );
			} );
			segmentRequest.error( function() {
				btn.prop( 'disabled', false );
			} );
		}
	} );
</script>
