<?php
/**
 * Splash Screen.
 *
 * @package BuddyBossApp\Admin
 */

$branding_options_value = \BuddyBossApp\Branding::instance()->get_options();
$spinner_color          = ! empty( $branding_options_value['splash_spinner_color'] ) ? $branding_options_value['splash_spinner_color'] : '#ffffff';
$platform_get           = ( ! empty( $_GET['platform'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['platform'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'android' === $platform_get ) {
	$loader_svg = '<svg class="bbapp-spinner-svg android" viewBox="0 0 50 50" stroke="' . $spinner_color . '"><circle class="path" cx="25" cy="25" r="20" fill="none" stroke-width="5"></circle></svg>';
} else {
	$loader_svg = '<svg class="bbapp-spinner-svg ios" viewBox="0 0 64 64" stroke="' . $spinner_color . '"><g stroke-width="4" stroke-linecap="round"><line y1="12" y2="20" transform="translate(32,32) rotate(180)"><animate attributeName="stroke-opacity" dur="750ms" values="1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(210)"><animate attributeName="stroke-opacity" dur="750ms" values="0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(240)"><animate attributeName="stroke-opacity" dur="750ms" values=".1;0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(270)"><animate attributeName="stroke-opacity" dur="750ms" values=".15;.1;0;1;.85;.7;.65;.55;.45;.35;.25;.15" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(300)"><animate attributeName="stroke-opacity" dur="750ms" values=".25;.15;.1;0;1;.85;.7;.65;.55;.45;.35;.25" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(330)"><animate attributeName="stroke-opacity" dur="750ms" values=".35;.25;.15;.1;0;1;.85;.7;.65;.55;.45;.35" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(0)"><animate attributeName="stroke-opacity" dur="750ms" values=".45;.35;.25;.15;.1;0;1;.85;.7;.65;.55;.45" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(30)"><animate attributeName="stroke-opacity" dur="750ms" values=".55;.45;.35;.25;.15;.1;0;1;.85;.7;.65;.55" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(60)"><animate attributeName="stroke-opacity" dur="750ms" values=".65;.55;.45;.35;.25;.15;.1;0;1;.85;.7;.65" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(90)"><animate attributeName="stroke-opacity" dur="750ms" values=".7;.65;.55;.45;.35;.25;.15;.1;0;1;.85;.7" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(120)"><animate attributeName="stroke-opacity" dur="750ms" values=".85;.7;.65;.55;.45;.35;.25;.15;.1;0;1;.85" repeatCount="indefinite"></animate></line><line y1="12" y2="20" transform="translate(32,32) rotate(150)"><animate attributeName="stroke-opacity" dur="750ms" values="1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1" repeatCount="indefinite"></animate></line></g></svg>';
}

$_class                  = '';
$splash_screen_img_style = '';
$branding_obj            = \BuddyBossApp\Branding::instance();
$branding_data           = $branding_obj->get_branding();
$splash_screen_img       = ( isset( $branding_data['splash_screen_img'] ) ) ? $branding_data['splash_screen_img'] : '';

if ( ! empty( $splash_screen_img ) ) {
	$_class                  = 'preview-fill';
	$splash_screen_img_style = "background-image: url({$splash_screen_img});";
}
?>

<div class="phone-style-stamp splash-bgr splash_screen_img <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $splash_screen_img_style ); ?>">
	<div class="bbapp_spinner bbapp-spinner splash_spinner_color">
		<?php echo $loader_svg; //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</div>
</div>
