<?php
/**
 * Single Lesson Screen.
 *
 * @package BuddyBossApp\Admin
 */

$lesson_data         = bbapp_get_lessons();
$lessons             = $lesson_data[0];
$no_of_lessons       = $lesson_data[2];
$first_lesson        = isset( $lessons[0] ) ? $lessons[0] : array();
$lesson_title        = isset( $first_lesson['title']['rendered'] ) ? $first_lesson['title']['rendered'] : '';
$author_id           = isset( $first_lesson['author'] ) ? $first_lesson['author'] : 0;
$is_lesson_completed = ! empty( $first_lesson['completed'] );
$author_data         = get_userdata( $author_id );
$author_name         = '';

if ( false !== $author_data ) {
	$author_name = $author_data->display_name;
}

$avatar         = get_avatar( $author_id, 40 );
$lesson_content = '';

if ( isset( $first_lesson['content_native'] ) ) {
	foreach ( $first_lesson['content_native'] as $native_content ) {
		$lesson_content .= $native_content['render'];
	}
}

$topics               = isset( $first_lesson['topics'] ) ? $first_lesson['topics'] : array();
$languages            = bbapp_get_rest_app_languages_for_preview();
$topics_title_text    = isset( $languages['lesson.topicsTitle'] ) ? $languages['lesson.topicsTitle'] : 'Topics';
$completed_text       = isset( $languages['lesson.completed'] ) ? $languages['lesson.completed'] : 'Completed';
$complete_lesson_text = isset( $languages['lesson.completeLesson'] ) ? $languages['lesson.completeLesson'] : 'Complete lesson';
$lesson_count_text    = isset( $languages['lesson.count'] ) ? $languages['lesson.count'] : 'Lesson {{current}} of {{total}}';
$lesson_count_text    = str_replace( '{{current}}', 1, $lesson_count_text );
$lesson_count_text    = str_replace( '{{total}}', $no_of_lessons, $lesson_count_text );
?>
<div class="lesson-wrapper">
	<div class="phone-style-stamp bodyBg bgr-attr lesson-wrapper-inner">
		<div class="lesson-header flex">
			<div class="menu-icon-wrap">
				<svg class="headerIconColor stroke-color" width="13" height="21" xmlns="http://www.w3.org/2000/svg">
					<path d="M11 2l-9 8.76 9 8.74" stroke="#385DFF" stroke-width="3" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
			</div>
			<nav class="lesson-nav">
				<span href="#" class="prev"><?php esc_html_e( 'Prev', 'buddyboss-app' ); ?></span>
				<span href="#" class="next active highlightColor color-attr">
					<?php esc_html_e( 'Next', 'buddyboss-app' ); ?>
				</span>
			</nav>
		</div>

		<div class="phone-font-stamp single-heading bbapp-style-appHeadings headingsColor color-attr"><?php echo esc_html( $lesson_title ); ?></div>
		<div class="phone-font-stamp single-sub-heading bbapp-style-bodyText highlightColor color-attr">
			<?php echo esc_html( $lesson_count_text ); ?>
		</div>

		<div class="phone-font-stamp single-entry bbapp-style-bodyText textColor color-attr">
			<?php echo wp_kses_post( $lesson_content ); ?>
		</div>

		<?php if ( isset( $topics ) && ! empty( $topics ) ) : ?>
			<div class="phone-topic-content">
				<div class="topic-header bbapp-style-bodyText headingsColor color-attr"><?php echo esc_html( $topics_title_text ); ?></div>
				<div class="topic-listing">
					<?php
					foreach ( $topics as $topic ) :
						$topic_id           = $topic['id'];
						$topic_title        = get_the_title( $topic_id );
						$is_topic_completed = $topic['completed'];
						?>
						<div class="topic-list">
							<div class="topic-title bbapp-style-bodyText headingsColor color-attr"><?php echo esc_html( $topic_title ); ?></div>

							<?php if ( $is_topic_completed ) { ?>
								<span class="topic-action check">
										<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"stroke-linecap="round" stroke-linejoin="round" class="feather feather-check">
											<polyline points="20 6 9 17 4 12"></polyline>
										</svg>
									</span>
							<?php } else { ?>
								<span class="topic-action uncheck"></span>
							<?php } ?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>

		<div class="phone-bottom-section lesson-footer">
			<?php
			if ( $no_of_lessons > 1 ) :
				?>
				<?php if ( $is_lesson_completed ) : ?>
					<div class="phone-left-button bbapp-style-bodyText">
						<span class="secondaryButtonColor color-attr"><?php echo esc_html( $completed_text ); ?></span>
					</div>
				<?php else : ?>
					<div class="phone-left-button bbapp-style-bodyText">
						<span class="secondaryButtonColor color-attr"><?php echo esc_html( $complete_lesson_text ); ?></span>
					</div>
				<?php endif; ?>
			<?php else : ?>
				<?php if ( $is_lesson_completed ) : ?>
					<div class="phone-button-full-width">
						<span class="secondaryButtonColor color-attr bbapp-style-bodyText"><?php echo esc_html( $completed_text ); ?></span>
					</div>
				<?php else : ?>
					<div class="phone-button-full-width">
						<span class="mark-complete secondaryButtonColor color-attr bbapp-style-bodyText">
							<?php echo esc_html( $complete_lesson_text ); ?>
						</span>
					</div>
				<?php endif; ?>
			<?php endif; ?>
		</div>
	</div>
</div>
