<?php
/**
 * Notification Screen.
 *
 * @package BuddyBossApp\Admin
 */

$notification_icon_key   = 'app_icon_ios';
$notification_icon_class = 'bbapp_notification ios app_icon_ios';
$app_name_key            = 'publish.ios.appname';

if ( 'android' === $platform_active ) {
	$app_name_key            = 'publish.android.appname';
	$notification_icon_key   = 'app_icon_android_notification';
	$notification_icon_class = 'bbapp_notification android app_icon_android_notification';
}

$appname                = \BuddyBossApp\Admin\Configure::instance()->option( 'publish.general.appname' );
$_class                 = '';
$notification_img_style = 'background-image: none;';
$branding_obj           = \BuddyBossApp\Branding::instance();
$branding_data          = $branding_obj->get_branding();
$splash_screen_img      = ( isset( $branding_data[ $notification_icon_key ] ) ) ? $branding_data[ $notification_icon_key ] : '';

if ( ! empty( $splash_screen_img ) ) {
	$_class                 = 'preview-fill';
	$notification_img_style = "background-image: url({$splash_screen_img});";
}
?>

<div class="phone-style-stamp notification-bgr notification_screen_img phone-style-stamp--push-new">
	<div class="bbapp-notification-wrap">
		<header>
			<div class="bbapp-logo-wrap">
				<div class="app-icon <?php echo esc_attr( $notification_icon_class ); ?>" style="<?php echo esc_attr( $notification_img_style ); ?>"></div>
				<span class="bbapp-notification-platform-title">
					<?php
					if ( ! empty( $appname ) ) {
						echo esc_html( $appname );
					} else {
						esc_html_e( 'App Name', 'buddyboss-app' );
					}
					?>
				</span>
			</div>
			<time class="bbapp-push-schedule-stage">
				<span class="bbapp-push-date"><?php esc_html_e( 'now', 'buddyboss-app' ); ?></span>
				<span class="bbapp-push-time"></span>
			</time>
		</header>
		<div class="bbapp-notification-content push-new-stamp">
			<h4 class="bbapp-push-stamp bbapp-push-text bbapp-push-title spin" id='bbapp-push-title'>&nbsp;</h4>
			<p class="bbapp-push-stamp bbapp-push-text spin" id='bbapp-push-text'>&nbsp;</p>
		</div>
	</div>
</div>
