<?php
/**
 * More Screen.
 *
 * @package BuddyBossApp\Admin
 */

$header_title_text       = __( 'More', 'buddyboss-app' );
$search_placeholder_text = __( 'Search', 'buddyboss-app' );
$current_user_id         = get_current_user_id();
$user_avatar             = get_avatar( $current_user_id, 200 );

if ( ! empty( $user_avatar ) && false !== strpos( $user_avatar, 'mystery-man' ) ) {
	$avatar_url  = bbapp_render_default_images( 'member' );
	$user_avatar = '<img src="' . esc_url( $avatar_url ) . '" alt="" />';
}

$profile_tabs  = bbapp_get_profile_tabs( $current_user_id );
$profile_icons = bbapp_profile_tabs_svg();

if ( ! empty( $profile_tabs ) ) {
	$profile_tabs = isset( current( $profile_tabs )['tabs'] ) ? current( $profile_tabs )['tabs'] : array();
}

$single_profile_data = get_transient( 'bbapp_preview_single_profile' );

if ( false === $single_profile_data || empty( $single_profile_data ) ) {
	$member_profile_request = new WP_REST_Request( 'GET', '/buddyboss/v1/members/' . $current_user_id );
	$server                 = rest_get_server();
	$item                   = $server->dispatch( $member_profile_request );
	$member_profile_status  = $item->get_status();
	$single_profile_data    = array();

	if ( 200 === $member_profile_status ) {
		$single_profile_data = $item->get_data();
	}

	set_transient( 'bbapp_preview_single_profile', $single_profile_data, 12 * HOUR_IN_SECONDS );
}

$user_display_name = ( isset( $single_profile_data ) && isset( $single_profile_data['profile_name'] ) ) ? $single_profile_data['profile_name'] : __( 'John', 'buddyboss-app' );
$user_login_name   = ( isset( $single_profile_data ) && isset( $single_profile_data['user_login'] ) ) ? $single_profile_data['user_login'] : __( 'john', 'buddyboss-app' );
?>
<script type="text/html" id="tmpl-buddyboss-app-preview-more">
	<div class="bbapp-more-memu-box">
        <# let defaultColor = 'undefined' !== typeof window.bb_app_preview_data ? window.bb_app_preview_data.colors.bottomTabsColor :"#000" #>
		<# for(i=0;i < data.api.menu.more.length; i++) { #>
		<# var item=data.api.menu.more[i]; #>
		<div class="bbapp-more-section-wrapper bbapp-more-memu {{item.object}} app-menu_more_icon">
			<# if('section'=== item.object) { #>
			<h3 class="bbapp-more-section-title headingsColor bbapp-style-appHeadings" id="preview-edit-menu-item-label-{{item.id}}"> {{{item.label}}} </h3>
			<# if( 0 !==item.section.length) { #>
			<# for(section_i=0;section_i < item.section.length; section_i++) { #>
			<# var section_item=item.section[section_i]; #>
			<# var text_tint_color = '#000000'; #>
			<# let section_item_icon = section_item.icon; #>
			<# var section_box_style = ('box' === section_item_icon.box_style && 'legacy' === section_item_icon.type) ? 'background:'+section_item_icon.color : '' #>
            <# let section_color = 'default' !== section_item_icon.color ? section_item_icon.color : defaultColor #>
			<# var svg_fill_color = ('box' === section_item_icon.box_style && 'legacy' === section_item_icon.type) ? '#ffffff' : section_color #>
								<div class="bbapp-more-section-inner bodyFrontBg">
									<div class="bbapp-more-section more-menu-preview-render bbapp-style-appMenus textColor borderColor color-attr">
					<div class="member-author-icon {{section_item.id}}_container">
						<# if( '' !== section_item_icon.fg_color ) { #>
						<div class="app_menu_item_bg icon-{{section_item_icon.box_style}}" style="background-color: {{{section_item_icon.style === 'filled' && section_item_icon.box_style !== '' ? section_item_icon.fg_color : 'transparent'}}};">
						<# } #>
							<a data-id="{{section_item.id}}" href="javascript:void(0)" style="{{section_box_style}}" class="icon-picker icon-{{section_item_icon.box_style}}">
								<# if( 'undefined' !== typeof section_item_icon ) { #>
								<img class="icon-{{section_item.id}}" style="filter: url(#bbapp-menu-icon-filter-bbapp-icon-{{{section_item.id}}})" src="{{section_item_icon.uri}}"/>
								<# if( 'custom' !== section_item_icon.type || 'custom' === section_item_icon.type && true === section_item_icon.fill_color ) { #>
									<svg id="bbapp-icon-{{{section_item.id}}}" class="hasTint spot1" style="position: absolute; height: 0; visibility: hidden; width: 0;">
										<defs>
											<filter id="bbapp-menu-icon-filter-bbapp-icon-{{section_item.id}}">
												<feFlood  flood-color="{{svg_fill_color}}"></feFlood>
												<feComposite in2="SourceAlpha" operator="atop"></feComposite>
											</filter>
										</defs>
									</svg>
									<# } #>
								<# } #>
							</a>
						<# if( '' !== section_item_icon.fg_color ) { #>
						</div>
						<# } #>
					</div>
					<div class="member-single-author">
						<div class="textColor color-attr member-title bbapp-style-appHeadings" style="color: {{text_tint_color}}" id="preview-edit-menu-item-label-{{section_item.id}}">
							{{section_item.label}}
						</div>
					</div>
					<# if( section_item.object == 'page' || section_item.object == 'custom' ) { #>
					<# let is_hide = ! section_item.data.open_external ? 'display: none;' : ''; #>
					<span class="arrow-svg bbapp-external-link-svg" style="{{ is_hide }}"><i class="bb-icon-l bb-icon-external-link"></i></span>
										<# } else { #>
					<span class="arrow-svg"><i class="bb-icon-f bb-icon-angle-right"></i></span>
										<# } #>
									</div>
								</div>
								<# } #>
							<# } #>
			<# } else { #>
			<# var text_tint_color = '#000000'; #>
			<# let item_icon = item.icon; #>
			<# var box_style = ('box' === item_icon.box_style && 'legacy' === item_icon.type) ? "background:"+item_icon.color : '' #>
            <# let color = 'default' !== item_icon.color ? item_icon.color : defaultColor #>
			<# var svg_fill_color = ('box' === item_icon.box_style && 'legacy' === item_icon.type) ? '#ffffff' : color #>
							<div class="bbapp-more-section-inner bodyFrontBg">
					<div class="bbapp-more-section more-menu-preview-render bbapp-style-appMenus textColor borderColor color-attr">
					<div class="member-author-icon {{item.id}}_container">
						<# if( '' !== item_icon.fg_color ) { #>
						<div class="app_menu_item_bg icon-{{item_icon.box_style}}" style="background-color: {{{item_icon.style === 'filled' && item_icon.box_style !== '' ? item_icon.fg_color : 'transparent'}}};">
						<# } #>
						<a data-id="{{item.id}}" href="javascript:void(0)" style="{{box_style}}" class="icon-picker icon-{{item_icon.box_style}}">
							<img class="icon-{{item.id}}" style="filter: url(#bbapp-menu-icon-filter-bbapp-icon-{{{item.id}}})" src="{{item.icon.uri}}">
							<# if( 'custom' !== item_icon.type || 'custom' === item_icon.type && true === item_icon.fill_color ) { #>
							<svg id="bbapp-icon-{{item.id}}" class="hasTint spot1"style="position: absolute; height: 0; visibility: hidden; width: 0;">
									<defs>
									<filter id="bbapp-menu-icon-filter-bbapp-icon-{{item.id}}">
										<feFlood flood-color="{{svg_fill_color}}"></feFlood>
											<feComposite in2="SourceAlpha" operator="atop"></feComposite>
										</filter>
									</defs>
								</svg>
								<# } #>
							</a>
							<# if( '' !== item_icon.fg_color ) { #>
							</div>
							<# } #>
						</div>
						<div class="member-single-author">
						<div class="textColor color-attr member-title bbapp-style-appHeadings"style="color: {{text_tint_color}}" id="preview-edit-menu-item-label-{{item.id}}">
							{{item.label}}
							</div>
						</div>
						<# if( item.object == 'page' || item.object == 'custom' ) { #>
					<# let is_hide = ! item.data.open_external ? 'display: none;' : ''; #>
					<span class="arrow-svg bbapp-external-link-svg" style="{{is_hide}}"><i class="bb-icon-l bb-icon-external-link"></i></span>
						<# } else { #>
					<span class="arrow-svg"><i class="bb-icon-f bb-icon-angle-right"></i></span>
						<# } #>
					</div>
				</div>
				<# } #>
		</div>
		<# } #>
	</div>
</script>
<script>
	buddybossAppUpdatePreviewStyles(); // make sure when preview loads trigger this.
</script>

<div class="style-over-flow phone-style-stamp bodyBg bgr-attr more-wrapper">
	<div class="headerBg is-search bgr-attr">
		<div class="phone-font-stamp headingsColor color-attr list-heading bbapp-style-appHeaderTitle color-attr text-left">
			<?php echo esc_html( $header_title_text ); ?>
		</div>
		<div class="search-part bbapp-style-bodyText">
			<i class="bb-icon-l bb-icon-search"></i>
			<?php echo esc_html( $search_placeholder_text ); ?>
		</div>
	</div>
	<div class="bb-inside-wrapper">
		<div class="bbapp-more-section-wrapper">
			<div class="bbapp-more-section-inner bodyFrontBg">
				<div class="bbapp-more-section bbapp-more-user-wrap bbapp-style-appMenus textColor color-attr">
					<div class="member-author-img"><?php echo wp_kses_post( $user_avatar ); ?></div>

					<div class="member-single-author">
						<div class="textColor color-attr member-title bbapp-style-appHeadings"><?php echo esc_html( $user_display_name ); ?></div>
						<div class="descLightTextColor color-attr bbapp-style-caption bbapp-style-bodyText member-user-login">
							<?php echo sprintf( '@%s', esc_html( $user_login_name ) ); ?>
						</div>
					</div>

					<span class="arrow-svg">
						<i class="bb-icon-f bb-icon-angle-right"></i>
					</span>
				</div>
			</div>
		</div>
		<div class="bbapp-more-memu-box bbapp-preview-more"></div>
	</div>
</div>
