<?php
/**
 * Member Profile Screen.
 *
 * @package BuddyBossApp\Admin
 */

$_class              = '';
$profile_cover_style = '';

if ( function_exists( 'bp_attachments_get_user_has_cover_image' ) ) {
	$has_cover_img = bp_attachments_get_user_has_cover_image( get_current_user_id() );

	if ( $has_cover_img ) {
		$profile_cover_src   = bp_attachments_get_attachment( 'url', array( 'item_id' => get_current_user_id() ) );
		$_class              = 'preview-fill';
		$profile_cover_style = "background-image: url({$profile_cover_src});";
	}
}

$current_user_id = get_current_user_id();
$user_avatar     = get_avatar( $current_user_id, 200 );

if ( ! empty( $user_avatar ) && false !== strpos( $user_avatar, 'mystery-man' ) ) {
	$avatar_url  = bbapp_render_default_images( 'member' );
	$user_avatar = '<img src="' . esc_url( $avatar_url ) . '" alt="" />';
}

$profile_tabs  = bbapp_get_profile_tabs( $current_user_id );
$profile_icons = bbapp_profile_tabs_svg();

if ( ! empty( $profile_tabs ) ) {
	$profile_tabs = current( $profile_tabs )['tabs'];
}

$single_profile_data = get_transient( 'bbapp_preview_single_profile' );

if ( false === $single_profile_data || empty( $single_profile_data ) ) {
	$member_profile_request = new WP_REST_Request( 'GET', '/buddyboss/v1/members/' . $current_user_id );
	$server                 = rest_get_server();
	$item                   = $server->dispatch( $member_profile_request );
	$member_profile_status  = $item->get_status();
	$single_profile_data    = array();

	if ( 200 === $member_profile_status ) {
		$single_profile_data = $item->get_data();
	}

	set_transient( 'bbapp_preview_single_profile', $single_profile_data, 12 * HOUR_IN_SECONDS );
}
?>
<div class=" profile-wrapper">
	<div class="member-single-profile bodyBg style-over-flow phone-style-stamp">
		<div class="bb-inside-wrapper">
			<?php
			if ( ! empty( $single_profile_data ) && is_array( $single_profile_data ) ) {
				$user_display_name = isset( $single_profile_data['profile_name'] ) ? $single_profile_data['profile_name'] : '';
				$user_login_name   = isset( $single_profile_data['user_login'] ) ? $single_profile_data['user_login'] : '';
				?>
				<div class="member-profile-header bodyFrontBg bgr-attr <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $profile_cover_style ); ?>"></div>
				<div class="member-details-wrapper">
					<div class="back-icon-wrap show headerIconColor">
						<svg width="28" height="28" xmlns="http://www.w3.org/2000/svg">
							<g fill="none" fill-rule="evenodd">
								<circle fill-opacity=".94" fill="#FFF" cx="14" cy="14" r="14"/>
								<path stroke="#92949D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" d="M16 8.497l-6 5.539 6 5.96"/>
							</g>
						</svg>
					</div>

					<div class="member_info">
						<?php echo wp_kses_post( $user_avatar ); ?>
						<div class="member_display_name bbapp-style-appHeadings headingsColor color-attr"><?php echo esc_html( $user_display_name ); ?></div>
						<div class="member_login descLightTextColor color-attr bbapp-style-caption bbapp-style-bodyText"><?php echo sprintf( '@%s', esc_html( $user_login_name ) ); ?></div>
					</div>

					<div class="member-profile-icons">
						<div class="member-icon">
							<svg width="48" height="48" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<rect fill="#EDEEF2" width="48" height="48" rx="24"/>
									<g stroke="#000" stroke-width="1.5">
										<path d="M18 15h12a4 4 0 014 4v7.739a4 4 0 01-4 4h-2.955 0c-.42 0-.814.198-1.063.535l-1.379 1.86a.794.794 0 01-1.279-.003l-1.435-1.958a1.063 1.063 0 00-.858-.434h0H18a4 4 0 01-4-4V19a4 4 0 014-4z"/>
										<path stroke-linejoin="round" d="M24 25.25l-2.645 1.39.505-2.945-2.14-2.086 2.957-.43L24 18.5l1.323 2.68 2.957.43-2.14 2.085.505 2.946z"/>
									</g>
								</g>
							</svg>
							<span class="bbapp-style-bodyText"><?php esc_html_e( 'Following', 'buddyboss-app' ); ?></span>
						</div>

						<div class="member-icon">
							<svg width="48" height="48" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<rect fill="#EDEEF2" width="48" height="48" rx="24"/>
									<g stroke="#000" stroke-width="1.5">
										<path d="M21.233 25.623c-4.188 0-7.483 1.813-7.483 3.778v.335c.02 2.668 1.128 3.447 7.483 3.447 6.579 0 7.484-.72 7.484-3.78 0-1.967-3.296-3.78-7.484-3.78zm0-10.873c-2.362 0-4.281 1.901-4.281 4.233 0 2.333 1.92 4.234 4.281 4.234 2.362 0 4.282-1.902 4.282-4.234s-1.92-4.233-4.282-4.233z"/>
										<path stroke-linecap="round" d="M31.633 17.9v6.067M28.6 20.933h6.067"/>
									</g>
								</g>
							</svg>
							<span class="bbapp-style-bodyText"><?php esc_html_e( 'Connected', 'buddyboss-app' ); ?></span>
						</div>

						<div class="member-icon">
							<svg width="48" height="48" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<rect fill="#EDEEF2" width="48" height="48" rx="24"/>
									<g stroke="#000" stroke-linecap="round" stroke-width="1.5">
										<path d="M17.982 16h11.946c2.199 0 3.982 1.783 3.982 3.982v7.704c0 2.199-1.783 3.981-3.982 3.981H17.982A3.982 3.982 0 0114 27.686v-7.704c0-2.2 1.783-3.982 3.982-3.982z"/>
										<path d="M17.31 20.219l5.106 3.66a2.588 2.588 0 003.016 0l5.08-3.642h0"/>
									</g>
								</g>
							</svg>
							<span class="bbapp-style-bodyText"><?php esc_html_e( 'Message', 'buddyboss-app' ); ?></span>
						</div>

						<div class="member-icon">
							<svg width="48" height="48" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<rect fill="#EDEEF2" width="48" height="48" rx="24"/>
									<g transform="translate(11 11)">
										<path d="M0 0h26v26H0z"/>
										<circle stroke="#000" stroke-width="1.5" cx="13" cy="13" r="10"/>
										<g transform="translate(7.5 11.5)" fill="#000">
											<circle cx="1.5" cy="1.5" r="1.5"/>
											<circle cx="5.5" cy="1.5" r="1.5"/>
											<circle cx="9.5" cy="1.5" r="1.5"/>
										</g>
									</g>
								</g>
							</svg>
							<span class="bbapp-style-bodyText"><?php esc_html_e( 'More', 'buddyboss-app' ); ?></span>
						</div>
					</div>
				</div>
				<?php
			}

			if ( ! empty( $profile_tabs ) ) {
				$removed_keys = array( 'settings', 'notifications', 'messages', 'documents', 'invites' );

				echo '<div class="member-profile-footer bodyFrontBg">';

				foreach ( $profile_tabs as $tab_single ) {
					if ( in_array( $tab_single['id'], $removed_keys, true ) ) {
						continue;
					}
					?>
					<div class="member-action-item textColor color-attr borderColor">
						<?php echo( array_key_exists( $tab_single['id'], $profile_icons ) ? esc_html( $profile_icons[ $tab_single['id'] ] ) : '' ); ?>
						<span class="action-item-label bbapp-style-appMenus"><?php echo esc_html( $tab_single['title'] ); ?></span>
						<?php echo( ( isset( $tab_single['count'] ) && '' !== $tab_single['count'] ) ? '<a class="highlightColor color-attr" href="#"><span class="bb-count"> ' . esc_html( $tab_single['count'] ) . ' </span></a>' : '' ); ?>
						<span class="arrow-svg">
							<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
								<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</span>
					</div>
					<?php
				}
				echo '</div>';
			} elseif ( ! empty( $single_profile_data ) && is_array( $single_profile_data ) ) {
				?>
				<div class="member-profile-footer bodyFrontBg">
					<?php if ( function_exists( 'buddypress' ) && bp_is_active( 'activity' ) ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="24" height="22" xmlns="http://www.w3.org/2000/svg">
								<g stroke="#000" stroke-width="1.5" fill="none" fill-rule="evenodd">
									<rect x=".75" y=".75" width="22.5" height="20.5" rx="4"/>
									<path d="M5 12.199h2.349a.583.583 0 00.514-.308L9.32 9.167h0l2.33 7.333 2.515-11 2.174 6.306a.583.583 0 00.552.393H19" stroke-linecap="round" stroke-linejoin="round"/>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Activities', 'buddyboss-app' ); ?></span>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>

					<div class="member-action-item textColor color-attr borderColor">
						<svg width="20" height="24" xmlns="http://www.w3.org/2000/svg">
							<defs>
								<path d="M15 16.09c5.523 0 10 2.443 10 5.455C25 24.558 25 27 15 27c-9.61 0-9.985-2.256-10-5.105v-.35c0-3.012 4.477-5.454 10-5.454zM15 3c3.37 0 6.111 2.691 6.111 6 0 3.308-2.74 6-6.11 6S8.89 12.309 8.888 9c0-3.309 2.741-6 6.111-6z" id="a"/>
							</defs>
							<path stroke="#000" stroke-width="1.5" d="M10 13.84c-5.164 0-9.25 2.23-9.25 4.704v.347c.018 3.37 1.41 4.359 9.25 4.359 4.538 0 7.104-.504 8.285-1.436.806-.637.965-1.3.965-3.269 0-2.475-4.086-4.704-9.25-4.704zM10 .75C7.041.75 4.64 3.109 4.64 6S7.042 11.25 10 11.25c2.959 0 5.361-2.359 5.361-5.25 0-2.892-2.402-5.25-5.36-5.25z" fill="none" fill-rule="evenodd"/>
						</svg>
						<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Profile', 'buddyboss-app' ); ?></span>
						<span class="arrow-svg">
							<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
								<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
						</span>
					</div>

					<?php if ( function_exists( 'buddypress' ) && bp_is_active( 'friends' ) ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="26" height="24" xmlns="http://www.w3.org/2000/svg">
								<g stroke="#000" stroke-width="1.5" fill="none" fill-rule="evenodd">
									<path d="M9.5 13.795c-4.888 0-8.75 2.126-8.75 4.476v.346c.018 3.197 1.331 4.133 8.75 4.133 4.302 0 6.732-.481 7.845-1.368.756-.602.905-1.23.905-3.11 0-2.351-3.863-4.477-8.75-4.477zm0-12.545c-2.789 0-5.056 2.245-5.056 5 .001 2.755 2.268 5 5.056 5 2.789 0 5.056-2.245 5.056-5s-2.267-5-5.056-5z"/>
									<g stroke-linecap="round">
										<path d="M21.5 5v7M18 8.5h7"/>
									</g>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Connections', 'buddyboss-app' ); ?></span>
							<a class="highlightColor color-attr" href="#"><span
										class="bb-count primaryColor bgr-attr">3</span></a>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>

					<?php if ( function_exists( 'buddypress' ) && bp_is_active( 'groups' ) ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="26" height="22" xmlns="http://www.w3.org/2000/svg">
								<g fill-rule="nonzero" stroke="#000" stroke-width="1.5" fill="none">
									<path d="M16.4 12.65c-4.612 0-8.25 2.005-8.25 4.208v.346c.02 2.988 1.254 3.864 8.25 3.864 4.067 0 6.362-.455 7.407-1.289.704-.56.843-1.148.843-2.92 0-2.203-3.639-4.208-8.25-4.208zm0-11.9c-2.62 0-4.75 2.112-4.75 4.704 0 2.593 2.13 4.705 4.75 4.705s4.75-2.112 4.75-4.704C21.15 2.862 19.02.75 16.4.75z"/>
									<path d="M8.729 11.984a7.911 7.911 0 00-2.329-.333c-2.761 0-5 .788-5 2.432 0 1.56 0 2.839 4.276 2.965" stroke-linecap="round"/>
									<path d="M6.4 9.505c1.407 0 2.55-1.134 2.55-2.523 0-1.39-1.143-2.523-2.55-2.523-1.407 0-2.55 1.134-2.55 2.523 0 1.389 1.143 2.523 2.55 2.523z"/>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Groups', 'buddyboss-app' ); ?></span>
							<a class="highlightColor color-attr" href="#"><span class="bb-count primaryColor bgr-attr">128</span></a>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>

					<?php if ( bbapp_is_learndash_enabled() ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="27" height="23" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<path d="M-2-4h30v30H-2z"/>
									<path d="M1.057 7.309C1.495 3.845 4.624 1 8.117 1h6.597c3.857 0 6.97 3.53 6.854 7.414-.112 3.753-3.388 6.646-7.142 6.646h-2.132c-.514 0-1.013.173-1.416.491l-3.644 2.876h0v-3.166c0-.13-.097-.24-.227-.257 0 0 0 0 0 0a6.857 6.857 0 01-5.95-7.695z" stroke="#000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M14.096 18.514h1.868c.474 0 .933.163 1.3.463l3.225 2.629v-2.914a.23.23 0 01.201-.229c3.264-.417 5.728-3.493 5.29-7.065a6.557 6.557 0 00-.801-2.418" stroke="#000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M7.857 7.06a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285zm3.429 0a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285zm3.428 0a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285z" fill="#000"/>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Courses', 'buddyboss-app' ); ?></span>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>

					<?php if ( function_exists( 'buddypress' ) && bp_is_active( 'media' ) ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="24" height="20" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<path d="M-3-5h30v30H-3z"/>
									<g transform="translate(1 1)" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
										<path d="M3.826 0h14.348A3.826 3.826 0 0122 3.826v10.522a3.826 3.826 0 01-3.826 3.826H3.826A3.826 3.826 0 010 14.348V3.826A3.826 3.826 0 013.826 0z"/>
										<path d="M.29 11.03L3.3 8.069a2.87 2.87 0 014.025 0l2.658 2.615h0l1.781 1.752M10.335 14.192l3.948-3.953a2.87 2.87 0 014.041-.02l3.414 3.353h0"/>
										<circle cx="12.196" cy="5.5" r="1.674"/>
									</g>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Photos', 'buddyboss-app' ); ?></span>
							<a class="highlightColor color-attr" href="#"><span class="bb-count primaryColor bgr-attr">31</span></a>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>

					<?php if ( function_exists( 'bbpress' ) ) { ?>
						<div class="member-action-item textColor color-attr borderColor">
							<svg width="27" height="23" xmlns="http://www.w3.org/2000/svg">
								<g fill="none" fill-rule="evenodd">
									<path d="M-2-4h30v30H-2z"/>
									<path d="M1.057 7.309C1.495 3.845 4.624 1 8.117 1h6.597c3.857 0 6.97 3.53 6.854 7.414-.112 3.753-3.388 6.646-7.142 6.646h-2.132c-.514 0-1.013.173-1.416.491l-3.644 2.876h0v-3.166c0-.13-.097-.24-.227-.257 0 0 0 0 0 0a6.857 6.857 0 01-5.95-7.695z" stroke="#000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M14.096 18.514h1.868c.474 0 .933.163 1.3.463l3.225 2.629v-2.914a.23.23 0 01.201-.229c3.264-.417 5.728-3.493 5.29-7.065a6.557 6.557 0 00-.801-2.418" stroke="#000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M7.857 7.06a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285zm3.429 0a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285zm3.428 0a1.143 1.143 0 110 2.285 1.143 1.143 0 010-2.285z" fill="#000"/>
								</g>
							</svg>
							<span class="action-item-label bbapp-style-appMenus"><?php esc_html_e( 'Forums', 'buddyboss-app' ); ?></span>
							<span class="arrow-svg">
								<svg width="7" height="12" xmlns="http://www.w3.org/2000/svg">
									<path d="M1 1l5 4.84L1 11" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</span>
						</div>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
