<?php
/**
 * Member Listing Screen.
 *
 * @package BuddyBossApp\Admin
 */

$members_data = get_transient( 'bbapp_preview_members' );

if ( false === $members_data || empty( $members_data ) ) {
	$members_request        = new WP_REST_Request( 'GET', '/buddyboss/v1/members' );
	$query_args['per_page'] = '6';
	$members_request->set_query_params( $query_args );
	$server         = rest_get_server();
	$item           = $server->dispatch( $members_request );
	$members_status = $item->get_status();
	$members_data   = array();

	if ( 200 === $members_status ) {
		$members_data = $item->get_data();
	}

	set_transient( 'bbapp_preview_members', $members_data, 12 * HOUR_IN_SECONDS );
}

$user_count_data         = count_users();
$member_count            = $user_count_data['total_users'];
$current_user_id         = get_current_user_id();
$languages               = bbapp_get_rest_app_languages_for_preview();
$header_title_text       = isset( $languages['members.headerTitle'] ) ? $languages['members.headerTitle'] : esc_html__( 'Members', 'buddyboss-app' );
$search_placeholder_text = isset( $languages['common.searchPlaceholder'] ) ? $languages['common.searchPlaceholder'] : esc_html__( 'Search', 'buddyboss-app' );
?>
<div class="style-over-flow phone-style-stamp bodyBg bgr-attr members-list-wrapper">
	<div class="back-icon-wrap">
		<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-left">
			<polyline points="15 18 9 12 15 6"></polyline>
		</svg>
	</div>

	<div class="headerBg is-search bgr-attr">
		<div class="phone-font-stamp headerColor color-attr list-heading bbapp-style-appHeaderTitle color-attr">
			<span class="nav-header-title"><?php echo esc_html( $header_title_text ); ?></span>
		</div>
		<div class="search-part bbapp-style-bodyText">
			<i class="bb-icon-l bb-icon-search"></i>
			<?php echo esc_html( $search_placeholder_text ); ?>
		</div>
	</div>

	<div class="bb-inside-wrapper">
		<div class="bb-filters-wrap borderColor">
			<svg width="30" height="30" xmlns="http://www.w3.org/2000/svg">
				<g fill="none" fill-rule="evenodd">
					<rect stroke="#DCDDDF" x=".5" y=".5" width="29" height="29" rx="14.5"/>
					<g stroke="#92949D" stroke-linecap="round" stroke-width="2">
						<path d="M9 11h12M11 15.5h8M13.75 20h2.5"/>
					</g>
				</g>
			</svg>
			<span class="btn-style bbapp-style-bodyText textColor color-attr">
				<span class="text-nowrap"><?php esc_html_e( 'All Members', 'buddyboss-app' ); ?></span>
				<a class="highlightColor color-attr" href="#">
					<span class="bb-count primaryColor bgr-attr">
						<?php echo esc_html( $member_count ); ?>
					</span>
				</a>
			</span>
			<span class="btn-style last-active bbapp-style-bodyText textColor color-attr">
				<span class="text-nowrap"><?php esc_html_e( 'Recently Active', 'buddyboss-app' ); ?></span>
					<svg width="9" height="6" xmlns="http://www.w3.org/2000/svg">
						<path d="M7.55 1.275L4.275 4.55 1 1.275" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
			</span>
		</div>

		<div class="member-list">
			<?php
			if ( ! empty( $members_data ) && is_array( $members_data ) && count( $members_data ) > 0 ) {

				foreach ( $members_data as $member ) {
					$member_name         = isset( $member['profile_name'] ) ? $member['profile_name'] : '';
					$img_path            = trailingslashit( bbapp()->plugin_url . 'assets/img/' );
					$default_user_avatar = $img_path . '/mystery-man.jpg';

					$avatar        = (array) $member['avatar_urls'];
					$member_avatar = isset( $avatar['thumb'] ) ? $avatar['thumb'] : $default_user_avatar;

					if ( ! empty( $member_avatar ) && false !== strpos( $member_avatar, 'mystery-man' ) ) {
						$member_avatar = bbapp_render_default_images( 'member' );
					}
					?>
					<div class="member-meta member-list-item-group borderColor">
						<div class="member-author-img"><img alt="<?php echo esc_attr( $member_name ); ?>"
															src="<?php echo esc_url( $member_avatar ); ?>"/></div>
						<div class="member-single-author">
							<div class="textColor color-attr member-title bbapp-style-appHeadings"><?php echo esc_html( $member_name ); ?></div>
							<?php
							if ( function_exists( 'bp_member_type_enable_disable' ) && true === bp_member_type_enable_disable() && true === bp_member_type_display_on_profile() ) :
								$member_type = bp_get_user_member_type( bp_get_member_user_id() );
								?>
								<div class="descLightTextColor color-attr bbapp-style-caption bbapp-style-bodyText"><?php echo wp_kses_post( $member_type ); ?></div>
							<?php else : ?>
								<div class="descLightTextColor color-attr bbapp-style-caption bbapp-style-bodyText"><?php echo '@' . wp_kses_post( $member['user_login'] ); ?></div>
							<?php endif; ?>
						</div>

						<?php if ( $member['id'] !== $current_user_id ) { ?>
							<div class="member-item-group-right">
								<svg width="16" height="4" xmlns="http://www.w3.org/2000/svg">
									<g fill="#92949D" fill-rule="evenodd">
										<circle cx="2" cy="2" r="2"/>
										<circle cx="8" cy="2" r="2"/>
										<circle cx="14" cy="2" r="2"/>
									</g>
								</svg>
							</div>
						<?php } ?>
					</div>
					<?php
				}
			}
			?>
		</div>
	</div>
</div>

<?php
require bbapp()->plugin_dir . 'views/preview/common/tabbar.php';
