<?php
/**
 * Login Screen.
 *
 * @package BuddyBossApp\Admin
 */

$_class                     = '';
$login_logo_style           = '';
$login_background_img_style = '';
$branding_obj               = \BuddyBossApp\Branding::instance();
$branding_data              = $branding_obj->get_branding();

if ( isset( $branding_data ) && ! empty( $branding_data ) ) {
	$login_logo = ( isset( $branding_data['login_logo'] ) ) ? $branding_data['login_logo'] : '';

	if ( ! empty( $login_logo ) ) {
		$_class           = 'preview-fill';
		$login_logo_style = "background-image: url({$login_logo});";
	}

	$login_background_img = ( isset( $branding_data['login_background_img'] ) ) ? $branding_data['login_background_img'] : '';

	if ( ! empty( $login_background_img ) ) {
		$_class                     = 'preview-fill';
		$login_background_img_style = "background-image: url({$login_background_img});";
	}
}

$is_registration_enabled = true;
$app_settings            = \BuddyBossApp\AppSettings::instance();
$is_registration_enabled = \BuddyBossApp\Auth\Auth::instance()->is_app_registration_enabled();
$signup_style            = 'visibility:hidden';

if ( $is_registration_enabled ) {
	$signup_style = 'visibility:visible';
}

$languages              = bbapp_get_rest_app_languages_for_preview();
$login_title            = isset( $languages['login.title'] ) ? $languages['login.title'] : esc_html__( 'Sign in', 'buddyboss-app' );
$username_or_email_text = isset( $languages['login.username'] ) ? $languages['login.username'] : esc_html__( 'Username or email', 'buddyboss-app' );
$password_text          = isset( $languages['login.password'] ) ? $languages['login.password'] : esc_html__( 'Password', 'buddyboss-app' );
$forgot_text            = isset( $languages['login.forgot'] ) ? $languages['login.forgot'] : esc_html__( 'Forgot Password?', 'buddyboss-app' );
$login_text             = isset( $languages['login.login'] ) ? $languages['login.login'] : esc_html__( 'Login', 'buddyboss-app' );
$have_account_text      = isset( $languages['login.haveAccount'] ) ? $languages['login.haveAccount'] : esc_html__( 'Don\'t have an account?', 'buddyboss-app' );
$signup_text            = isset( $languages['login.signup'] ) ? $languages['login.signup'] : esc_html__( 'Sign Up', 'buddyboss-app' );
?>
<div class="phone-style-stamp login-bgr authBgColor bgr-attr login_background_img <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $login_background_img_style ); ?>">
	<div class="login-inside-wrapper">
		<div class="logo-container login_logo <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $login_logo_style ); ?>"></div>
		<div class="bb-signin-title bbapp-style-bodyText color-attr authHeading authTextColor">
			<?php echo esc_html( $login_title ); ?>
		</div>
		<div class="app-field-set authFieldTextColor color-attr">
			<div class="app-field flex-row icon-left">
					<span class="icon-wrap">
						<i class="bb-icon-l bb-icon-user"></i>
					</span>
				<span class="placeholder bbapp-style-bodyText"><?php echo esc_html( $username_or_email_text ); ?></span>
			</div>
		</div>
		<div class="app-field-set authFieldTextColor color-attr">
			<div class="app-field flex-row icon-left">
					<span class="icon-wrap">
						<i class="bb-icon-l bb-icon-lock"></i>
					</span>
				<span class="placeholder bbapp-style-bodyText"><?php echo esc_html( $password_text ); ?></span>
				<i class="bb-icon-l bb-icon-eye-slash"></i>
			</div>
			<div class="phone-forgot color-attr bbapp-style-bodyText authTextColor"><?php echo esc_html( $forgot_text ); ?></div>
		</div>
		<div class="app-login-btn authButtonBgColor bgr-attr">
			<span class="authButtonTextColor color-attr bbapp-style-bodyText"><?php echo esc_html( $login_text ); ?></span>
		</div>
		<div style="<?php echo esc_attr( $signup_style ); ?>" class="app-login-exclude">
			<div class="color-attr authTextColor bbapp-style-bodyText">
				<?php echo esc_html( $have_account_text ); ?>
				<strong class="authTextColor color-attr"><?php echo esc_html( $signup_text ); ?></strong>
				<i class="bb-icon-f bb-icon-arrow-right"></i>
			</div>
		</div>
	</div>
</div>
