<?php
/**
 * Headerbar Screen.
 *
 * @package BuddyBossApp\Admin
 */

require bbapp()->plugin_dir . 'views/preview/common/tabbar.php';

$user_avatar = get_avatar_url( get_current_user_id() );
?>
<script type="text/html" id="tmpl-buddyboss-app-preview-headerbar">
	<div class="app-menu <# if(data.settings.app_menu.appmenu_labels) { #> app-menu--labels <# } else { #> app-menu--icons <# } #>">
		<# for(i=0;i < data.api.menu.headerbar.length; i++) { #>
			<# var item = data.api.menu.headerbar[i];
			if (item.object === 'profile' || ( 'undefined' !== typeof item.icon_type && 'avatar' === item.icon_type )) { #>
				<div class="bbapp-user-avatar">
					<img src="<?php echo esc_url( $user_avatar ); ?>" alt="<?php esc_attr_e( 'User Avatar', 'buddyboss-app' ); ?>">
				</div>
			<# }else{ #>
				<# let item_icon = item.icon; #>
				<# let defaultColor = 'undefined' !== typeof window.bb_app_preview_data ? window.bb_app_preview_data.colors.bottomTabsColor :"#000" #>
				<# let color = 'default' !== item_icon.color ? item_icon.color :defaultColor #>
				<# var box_style = ('box' === item_icon.box_style && 'legacy' === item_icon.type) ? "background:"+color : '' #>
				<# var svg_fill_color = ('box' === item_icon.box_style && 'legacy' === item_icon.type) ? '#ffffff' : color #>
				<# var label_fill_color = ('box' === item_icon.box_style && 'legacy' === item_icon.type) ? '#ffffff' : color #>
				<# var bottom_color_class = ''; #>
				<# if( 'bbapp-menus' !== bbappCore.helper.bbapp_get_url_parameter( 'page' ) ) { #>
				<# bottom_color_class = (i==0) ? 'bottomTabsActiveColor' : 'bottomTabsColor';  #>
				<# } #>
				<div class="{{{item.object}}} <# if(i==0) { #> active_menu bottomTabsActiveColor <# } else { #> bottomTabsColor <# } #> app-menu__icon">
					<# if( '' !== item_icon.fg_color ) { #>
					<div class="app_menu_item_bg icon-{{item_icon.box_style}}" style="background-color: {{{item_icon.style === 'filled' && item_icon.box_style !== '' ? item_icon.fg_color : 'transparent' }}};">
						<# } #>
						<a data-id="{{{item.id}}}" href="javascript:void(0)" style="{{box_style}}" class="icon-picker {{item_icon.type}}">
							<img alt="" class="icon-{{{item.id}}}" style="filter: url(#bbapp-menu-icon-filter-bbapp-icon-{{{item.id}}})" src="{{{item_icon.uri}}}">
						</a>
						<# if( '' !== item_icon.fg_color ) { #>
					</div>
					<# } #>
					<# if( 'custom' !== item_icon.type || 'custom' === item_icon.type && true === item_icon.fill_color ) { #>
					<svg id="bbapp-icon-{{item.id}}" class="hasTint spot1" style="position: absolute; height: 0; visibility: hidden; width: 0;">
						<defs>
							<filter id="bbapp-menu-icon-filter-bbapp-icon-{{item.id}}">
								<feFlood class="{{bottom_color_class}}" flood-color="{{{svg_fill_color}}}"></feFlood>
								<feComposite in2="SourceAlpha" operator="atop"></feComposite>
							</filter>
						</defs>
					</svg>
					<# } #>
				</div>
			<# } #>
		<# } #>
	</div>
</script>

<div class="header-bar-block phone-style-stamp bodyBg bodyFrontBg bgr-attr phone-style-stamp--figure-header">
	<div class="bbapp-preview-headerbar headerBg bgr-attr">
		<h1 class="headerColor color-attr bbapp-style-appHeaderTitle">
			<?php esc_html_e( 'Title', 'buddyboss-app' ); ?>
		</h1>
		<div class="header-bar-block_actions">
		</div>
	</div>
</div>
