<?php
/**
 * Forum Screen.
 *
 * @package BuddyBossApp\Admin
 */

$forum_data              = bbapp_get_forums();
$forums                  = $forum_data[0];
$forum_count             = count( $forums );
$languages               = bbapp_get_rest_app_languages_for_preview();
$header_title_text       = isset( $languages['forums.headerTitle'] ) ? $languages['forums.headerTitle'] : 'Forums';
$search_placeholder_text = isset( $languages['common.searchPlaceholder'] ) ? $languages['common.searchPlaceholder'] : esc_html__( 'Search', 'buddyboss-app' );
?>
<div class="forums-wrapper">
	<div class="style-over-flow phone-style-stamp bodyBg bgr-attr">
		<div class="back-icon-wrap">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-left">
				<polyline points="15 18 9 12 15 6"></polyline>
			</svg>
		</div>

		<div class="headerBg is-search bgr-attr">
			<div class="phone-font-stamp headerColor color-attr list-heading bbapp-style-appHeaderTitle">
				<span class="nav-header-title"><?php echo esc_html( $header_title_text ); ?></span>
			</div>
			<div class="search-part bbapp-style-bodyText">
				<i class="bb-icon-l bb-icon-search"></i>
				<?php echo esc_html( $search_placeholder_text ); ?>
			</div>
		</div>

		<div class="bb-inside-wrapper">
			<div class="bb-filters-wrap borderColor">
				<svg width="30" height="30" xmlns="http://www.w3.org/2000/svg">
					<g fill="none" fill-rule="evenodd">
						<rect stroke="#DCDDDF" x=".5" y=".5" width="29" height="29" rx="14.5"/>
						<g stroke="#92949D" stroke-linecap="round" stroke-width="2">
							<path d="M9 11h12M11 15.5h8M13.75 20h2.5"/>
						</g>
					</g>
				</svg>
				<span class="btn-style bbapp-style-bodyText textColor color-attr">
					<span class="text-nowrap"><?php esc_html_e( 'All Forums', 'buddyboss-app' ); ?></span>
					<a class="highlightColor color-attr" href="#">
						<span class="bb-count primaryColor bgr-attr"><?php echo esc_html( $forum_count ); ?></span>
					</a>
				</span>
				<span class="btn-style last-active bbapp-style-bodyText textColor color-attr">
					<span class="text-nowrap"><?php esc_html_e( 'Last Active', 'buddyboss-app' ); ?></span>
					<svg width="9" height="6" xmlns="http://www.w3.org/2000/svg">
						<path d="M7.55 1.275L4.275 4.55 1 1.275" stroke="#92949D" stroke-width="2" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
				</span>
			</div>

			<?php
			if ( ! empty( $forums ) ) {
				foreach ( $forums as $forum ) {
					$status_forum = isset( $forum['status'] ) ? $forum['status'] : '';
					$forum_title  = isset( $forum['title']['rendered'] ) ? $forum['title']['rendered'] : '';

					if ( 'private' === $status_forum ) {
						$forum_title = 'Private: ' . $forum_title;
					}

					$forum_content = isset( $forum['short_content'] ) ? $forum['short_content'] : '';
					$discussion    = ! empty( $forum['total_topic_count'] ) ? absint( $forum['total_topic_count'] ) : 0;
					$reply         = ! empty( $forum['total_reply_count'] ) ? absint( $forum['total_reply_count'] ) : 0;
					$avatar        = bbapp_render_default_images( 'forum' );
					$forum_group   = isset( $forum['group'] ) ? $forum['group'] : '';

					if ( ! empty( $forum_group ) ) {
						$avatar = bbapp_render_default_images( 'group-r' );

						if ( isset( $forum_group->avatar_urls ) ) {
							$group_avatar = $forum_group->avatar_urls['thumb'];

							if ( ! empty( $group_avatar ) && false === strpos( $group_avatar, 'mystery-group' ) ) {
								$avatar = $group_avatar;
							}
						}
					} elseif ( ! empty( $forum['featured_media'] ) && ! empty( $forum['featured_media']['thumb'] ) ) {
						$avatar = $forum['featured_media']['thumb'];
					}
					?>
					<div class="phone-font-stamp list-item-block">
						<div class="list-item-avatar">
							<img class="forum-group-avatar" src="<?php echo esc_url( $avatar ); ?>" alt=""/>
						</div>
						<div class="list-item-entry borderColor">
							<?php if ( ! empty( $forum_title ) ) { ?>
								<h5 class="list-item-heading bbapp-style-appHeadings textColor color-attr"><?php echo esc_html( $forum_title ); ?></h5>
							<?php } ?>

							<?php if ( ! empty( $forum_content ) ) { ?>
								<div class="bbapp-group-description bbapp-style-bodyText descTextColor color-attr"><?php echo wp_kses_post( wp_trim_words( $forum_content, 8, '...' ) ); ?></div>
							<?php } ?>

							<div class="list-item-meta forum-meta-footer bbapp-style-caption bbapp-style-bodyText descLightTextColor color-attr">
								<span>
									<?php echo esc_html( $discussion ); ?>
									<?php ( $discussion <= 1 ) ? esc_html_e( 'discussion', 'buddyboss-app' ) : esc_html_e( 'discussions', 'buddyboss-app' ); ?>
								</span>
								<span class="middot">&middot;</span>
								<span>
									<?php echo esc_html( $reply ); ?>
									<?php ( $reply <= 1 ) ? esc_html_e( 'reply', 'buddyboss-app' ) : esc_html_e( 'replies', 'buddyboss-app' ); ?>
								</span>
							</div>
						</div>
						<div class="list-item-group">
							<div class="list-item-group-right">
								<svg width="16" height="4" xmlns="http://www.w3.org/2000/svg">
									<g fill="#92949D" fill-rule="evenodd">
										<circle cx="2" cy="2" r="2"/>
										<circle cx="8" cy="2" r="2"/>
										<circle cx="14" cy="2" r="2"/>
									</g>
								</svg>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>
		</div>
	</div>
	<?php require bbapp()->plugin_dir . 'views/preview/common/tabbar.php'; ?>
</div>
