<?php
/**
 * Colors Register Screen.
 *
 * @package BuddyBossApp\Admin
 */

$_class                        = '';
$register_background_img_style = '';
$branding_obj                  = \BuddyBossApp\Branding::instance();
$branding_data                 = $branding_obj->get_branding();

if ( isset( $branding_data ) && ! empty( $branding_data ) ) {
	$register_background_img = ( isset( $branding_data['register_background_img'] ) ) ? $branding_data['register_background_img'] : '';

	if ( ! empty( $register_background_img ) ) {
		$_class                        = 'preview-fill';
		$register_background_img_style = "background-image: url({$register_background_img});";
	}
}

$registration_fields = get_transient( 'bbapp_preview_registration' );

if ( empty( $registration_fields ) ) {
	$registration_fields_request = wp_remote_get( home_url( '/wp-json/buddyboss/v1/signup/form' ) );
	$registration_fields         = array();

	if ( is_array( $registration_fields_request ) && ! is_wp_error( $registration_fields_request ) ) {
		$registration_fields = json_decode( $registration_fields_request['body'] ); // Use the content.
	}

	set_transient( 'bbapp_preview_registration', $registration_fields, 12 * HOUR_IN_SECONDS );
}

$fields              = $registration_fields;
$languages           = bbapp_get_rest_app_languages_for_preview();
$page_title_text     = isset( $languages['signup.pageTitle'] ) ? $languages['signup.pageTitle'] : esc_html__( 'Create Account', 'buddyboss-app' );
$create_account_text = isset( $languages['signup.createAccount'] ) ? $languages['signup.createAccount'] : esc_html__( 'Create Account', 'buddyboss-app' );
$have_account_text   = isset( $languages['signup.haveAccount'] ) ? $languages['signup.haveAccount'] : esc_html__( 'Already have an account?', 'buddyboss-app' );
$login_text          = isset( $languages['signup.login'] ) ? $languages['signup.login'] : esc_html__( 'Login', 'buddyboss-app' );
?>

<div class="phone-style-stamp register-bgr regBgColor bgr-attr register_background_img <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $register_background_img_style ); ?>">
	<div class="register-inside-wrapper">
		<div class="back-icon-wrap color-white show register-back regTextColor">
			<i class="bb-icon-f bb-icon-arrow-left"></i>
		</div>
		<div class="phone-font-stamp login-heading color-attr bbapp-style-bodyText regHeading regTextColor"><?php echo esc_html( $page_title_text ); ?></div>
		<?php
		foreach ( $fields as $field ) {
			bbapp_render_registration_field( $field );
		}
		?>
		<div class="app-login-btn regButtonBgColor bgr-attr bbapp-style-bodyText">
			<span class="regButtonTextColor color-attr"><?php echo esc_html( $create_account_text ); ?></span>
		</div>
	</div>
</div>

<div class="app-login-exclude bbapp-style-bodyText">
	<div class="color-attr regTextColor bbapp-style-bodyText">
		<?php echo esc_html( $have_account_text ); ?>
		<span><?php echo esc_html( $login_text ); ?></span>
	</div>
</div>
