<?php
/**
 * Colors In-App Purchases Screen.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! bbapp_is_active( 'iap' ) ) {
	return '';
}

?>
<div class="phone-style-stamp phone-style-fonts bodyBg bodyFrontBg bgr-attr">
	<div class="headerBg headerBg--short bgr-attr">
		<div class="nav-header-ico">
			<i class="bb-icon-f bb-icon-angle-left headerIconColor color-attr"></i>
			<span class="headerIconColor color-attr bbapp-style-bodyText"><?php esc_html_e( 'Back', 'buddyboss-app' ); ?></span>
		</div>
	</div>
	<div class="bb-inside-wrapper bb-inside-wrapper--iap">
		<div class="bbapp-preview-colors bbapp-preview-colors--iap">
			<div class="iap-preview-wrap">
				<div class="iap-block bodyBg">
					<div class="iap-block__head">
						<div class="iap-block__ico">
							<i class="bb-icon-rf bb-icon-check"></i>
						</div>
						<div class="iap-block__title textColor bbapp-style-appHeadings"><?php esc_html_e( 'Product Name', 'buddyboss-app' ); ?></div>
						<div class="iap-block__tag descTextColor bbapp-style-bodyText"><?php esc_html_e( 'Product Tagline', 'buddyboss-app' ); ?></div>
						<div class="iap-block__btn">
							<span class="secondaryButtonBg secondaryButtonColor bbapp-style-bodyText">
								<?php esc_html_e( '$49.99', 'buddyboss-app' ); ?>
							</span>
						</div>
						<div class="iap-block__deal descTextColor bbapp-style-bodyText"><?php esc_html_e( 'Per {{number}} months', 'buddyboss-app' ); ?></div>
					</div>
					<div class="iap-block__body borderColor">
						<div class="iap-block__info textColor bbapp-style-bodyText">
							<?php esc_html_e( 'Below are some example benefits for this product', 'buddyboss-app' ); ?>
						</div>
						<div class="iap-block__list-item textColor bbapp-style-bodyText">
							<span class="iap-block__list-check">
								<span class="iapBenefitsCheckmark"></span>
								<i class="bb-icon-l bb-icon-check"></i>
							</span>
							<?php esc_html_e( 'First Benefit', 'buddyboss-app' ); ?>
						</div>
						<div class="iap-block__list-item textColor bbapp-style-bodyText">
							<span class="iap-block__list-check">
								<span class="iapBenefitsCheckmark"></span>
								<i class="bb-icon-l bb-icon-check"></i>
							</span>
							<?php esc_html_e( 'Second Benefit', 'buddyboss-app' ); ?>
						</div>
					</div>
				</div>
				<div class="iap-terms">
					<span class="textColor bbapp-style-bodyText">
						<?php echo sprintf( '<span class="primaryColor color-attr">%1$s</span> %2$s <span class="primaryColor color-attr"></span>', esc_html__( 'Terms of Service', 'buddyboss-app' ), esc_html__( 'and', 'buddyboss-app' ), esc_html__( 'Privacy Policy', 'buddyboss-app' ) ); ?>
					</span>
				</div>
			</div>
		</div>
	</div>
	<div class="iap-status bodyBg">
		<div class="iap-status__label">
			<div class="iap-block__ico">
				<i class="bb-icon-rf bb-icon-check"></i>
			</div>
			<div class="iap-status__title textColor bbapp-style-appHeadings"><?php esc_html_e( 'Purchased', 'buddyboss-app' ); ?></div>
		</div>
	</div>
</div>
