<?php
/**
 * Colors Courses Screen.
 *
 * @package BuddyBossApp\Admin
 */

$languages         = bbapp_get_rest_app_languages_for_preview();
$in_progress       = isset( $languages['course.inProgress'] ) ? $languages['course.inProgress'] : esc_html__( 'In Progress', 'buddyboss-app' );
$paid_course_start = isset( $languages['course.paidCourseStart'] ) ? $languages['course.paidCourseStart'] : esc_html__( 'Start Course', 'buddyboss-app' );
$completed         = isset( $languages['course.completed'] ) ? $languages['course.completed'] : esc_html__( 'Completed', 'buddyboss-app' );
$free              = isset( $languages['course.free'] ) ? $languages['course.free'] : esc_html__( 'Free', 'buddyboss-app' );
$not_enrolled      = isset( $languages['course.notEnrolled'] ) ? $languages['course.notEnrolled'] : esc_html__( 'Not Enrolled', 'buddyboss-app' );
?>

<div class="phone-style-stamp phone-style-fonts bodyBg bodyFrontBg bgr-attr">
	<div class="bb-inside-wrapper bb-inside-wrapper--courses">
		<div class="bbapp-preview-colors bbapp-preview-colors--courses">
			<div class="bbapp-course-row flex">
				<div class="bbapp-course-thumb">
					<span class="bbapp-courses-label coursesLabelCompleted bbapp-style-bodyText"><?php echo esc_html( $completed ); ?></span>
				</div>
				<div class="bbapp-course-data borderColor">
					<div class="bbapp-course-header bbapp-style-appHeadings headingsColor"><?php esc_html_e( 'Ut non enim eleifend felis', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-author bbapp-style-bodyText textColor"><?php esc_html_e( 'John Smith', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-date bbapp-style-bodyText descLightTextColor">
						<?php esc_html_e( 'June 09, ', 'buddyboss-app' ); ?><?php echo esc_html( gmdate( 'Y', strtotime( '-1 year' ) ) ); ?>
					</div>
				</div>
			</div>

			<div class="bbapp-course-row flex">
				<div class="bbapp-course-thumb">
					<span class="bbapp-courses-label coursesLabelProgress bbapp-style-bodyText"><?php echo esc_html( $in_progress ); ?></span>
				</div>
				<div class="bbapp-course-data borderColor">
					<div class="bbapp-course-header bbapp-style-appHeadings headingsColor"><?php esc_html_e( 'Vestibulum suscipit nulla', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-author bbapp-style-bodyText textColor"><?php esc_html_e( 'John Smith', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-date bbapp-style-bodyText descLightTextColor">
						<?php esc_html_e( 'May 10, ', 'buddyboss-app' ); ?><?php echo esc_html( gmdate( 'Y', strtotime( '-1 year' ) ) ); ?>
					</div>
				</div>
			</div>

			<div class="bbapp-course-row flex">
				<div class="bbapp-course-thumb">
					<span class="bbapp-courses-label coursesLabelStart bbapp-style-bodyText"><?php echo esc_html( $paid_course_start ); ?></span>
				</div>
				<div class="bbapp-course-data borderColor">
					<div class="bbapp-course-header bbapp-style-appHeadings headingsColor"><?php esc_html_e( 'Sed mollis eros et', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-author bbapp-style-bodyText textColor"><?php esc_html_e( 'John Smith', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-date bbapp-style-bodyText descLightTextColor">
						<?php esc_html_e( 'May 15, ', 'buddyboss-app' ); ?><?php echo esc_html( gmdate( 'Y', strtotime( '-1 year' ) ) ); ?>
					</div>
				</div>
			</div>

			<div class="bbapp-course-row flex">
				<div class="bbapp-course-thumb">
					<span class="bbapp-courses-label coursesLabelFree bbapp-style-bodyText"><?php echo esc_html( $free ); ?></span>
				</div>
				<div class="bbapp-course-data borderColor">
					<div class="bbapp-course-header bbapp-style-appHeadings headingsColor"><?php esc_html_e( 'Mauris turpis nunc', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-author bbapp-style-bodyText textColor"><?php esc_html_e( 'John Smith', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-date bbapp-style-bodyText descLightTextColor">
						<?php esc_html_e( 'August 01, ', 'buddyboss-app' ); ?><?php echo esc_html( gmdate( 'Y', strtotime( '-1 year' ) ) ); ?>
					</div>
				</div>
			</div>

			<div class="bbapp-course-row flex">
				<div class="bbapp-course-thumb">
					<span class="bbapp-courses-label coursesLabelNotEnrolled bbapp-style-bodyText"><?php echo esc_html( $not_enrolled ); ?></span>
				</div>
				<div class="bbapp-course-data borderColor">
					<div class="bbapp-course-header bbapp-style-appHeadings headingsColor"><?php esc_html_e( 'In hac habitasse platea dictumst', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-author bbapp-style-bodyText textColor"><?php esc_html_e( 'John Smith', 'buddyboss-app' ); ?></div>
					<div class="bbapp-course-date bbapp-style-bodyText descLightTextColor">
						<?php esc_html_e( 'September 19, ', 'buddyboss-app' ); ?><?php echo esc_html( gmdate( 'Y', strtotime( '-1 year' ) ) ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
