<?php
/**
 * Color Login Screen.
 *
 * @package BuddyBossApp\Admin
 */

$_class                     = '';
$login_background_img_style = '';
$branding_obj               = \BuddyBossApp\Branding::instance();
$branding_data              = $branding_obj->get_branding();

if ( ! empty( $branding_data ) ) {
	$login_background_img = ( isset( $branding_data['login_background_img'] ) ) ? $branding_data['login_background_img'] : '';

	if ( ! empty( $login_background_img ) ) {
		$_class                     = 'preview-fill';
		$login_background_img_style = "background-image: url({$login_background_img});";
	}
}

$languages               = bbapp_get_rest_app_languages_for_preview();
$forgot_page_title       = isset( $languages['forgot.pageTitle'] ) ? $languages['forgot.pageTitle'] : esc_html__( 'Forgot Password?', 'buddyboss-app' );
$forgot_page_description = isset( $languages['forgot.pageDescription'] ) ? $languages['forgot.pageDescription'] : esc_html__( 'Enter your email address and we’ll send instructions to reset your password.', 'buddyboss-app' );
$login_email             = isset( $languages['login.email'] ) ? $languages['login.email'] : esc_html__( 'Email Address', 'buddyboss-app' );
$forgot_submit           = isset( $languages['forgot.submit'] ) ? $languages['forgot.submit'] : esc_html__( 'Submit', 'buddyboss-app' );
?>

<div class="phone-style-stamp login-bgr authBgColor bgr-attr authFpass login_background_img <?php echo esc_attr( $_class ); ?>" style="<?php echo esc_attr( $login_background_img_style ); ?>">
	<div class="login-inside-wrapper">
		<div class="back-icon-wrap color-white show register-back authTextColor">
			<i class="bb-icon-f bb-icon-arrow-left"></i>
		</div>
		<div class="bb-fpass-title bbapp-style-bodyText color-attr authHeading authTextColor">
			<?php echo esc_html( $forgot_page_title ); ?>
		</div>
		<div class="bb-auth-data bbapp-style-bodyText color-attr authTextColor">
			<?php echo esc_textarea( $forgot_page_description ); ?>
		</div>
		<div class="app-field-set authFieldTextColor color-attr">
			<div class="app-field flex-row icon-left">
				<span class="placeholder bbapp-style-bodyText"><?php echo esc_html( $login_email ); ?></span>
			</div>
		</div>
		<div class="app-login-btn app-login-btn--fpass bgr-attr authButtonBgColor">
			<span class="authButtonTextColor color-attr bbapp-style-bodyText"><?php echo esc_html( $forgot_submit ); ?></span>
		</div>
	</div>
</div>
