<?php
/**
 * Menu tabs.
 *
 * @package BuddyBossApp\Admin
 */

$forum_data              = bbapp_get_forums();
$show_forums             = $forum_data[1];
$topic_data              = bbapp_get_topics();
$show_topics             = $topic_data[2];
$lesson_data             = bbapp_get_lessons();
$show_lesson             = $lesson_data[1];
$is_registration_enabled = true;
$app_settings            = \BuddyBossApp\AppSettings::instance();
$is_registration_enabled = \BuddyBossApp\Auth\Auth::instance()->is_app_registration_enabled();
$bbapp_screens_tabs      = array();
$setting_get             = ( ! empty( $_GET['setting'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'typography' === $setting_get ) {
	$bbapp_screens_tabs['font_preview'] = __( 'Font Preview', 'buddyboss-app' );
}

$bbapp_screens_tabs['home']           = __( 'Home', 'buddyboss-app' );
$bbapp_screens_tabs['login']          = __( 'Login', 'buddyboss-app' );
$bbapp_screens_tabs['member_listing'] = __( 'Members', 'buddyboss-app' );
$bbapp_screens_tabs['member_profile'] = __( 'Profile', 'buddyboss-app' );

if ( $is_registration_enabled ) {
	$bbapp_screens_tabs['register'] = __( 'Register', 'buddyboss-app' );
}

if ( function_exists( 'bbpress' ) && $show_forums ) {
	$bbapp_screens_tabs['forum'] = __( 'Forums', 'buddyboss-app' );
	if ( $show_topics ) {
		$bbapp_screens_tabs['topic'] = __( 'Discussion Topic', 'buddyboss-app' );
	}
}

if ( bbapp_is_learndash_enabled() && $show_lesson ) {
	$bbapp_screens_tabs['single_lesson'] = __( 'Single Lesson', 'buddyboss-app' );
}

if ( 'app_menu' === $setting_get ) {
	$bbapp_screens_tabs['more'] = __( 'More', 'buddyboss-app' );
}

?>
<div class="bbapp-styling-dropdown text-center">
	<select class="bbapp-screens-list" name="bbapp-screen">
		<?php foreach ( $bbapp_screens_tabs as $screen_key => $bbapp_screen_tab ) { ?>
			<option <?php selected( $screen_active, $screen_key ); ?> value="<?php echo esc_attr( $screen_key ); ?>">
				<?php echo esc_html( $bbapp_screen_tab ); ?>
			</option>
		<?php } ?>
	</select>
</div>
