<?php
/**
 * Main preview screen.
 *
 * @package BuddyBossApp\Admin
 */

$platform_active = isset( $_GET['platform'] ) ? bbapp_input_clean( wp_unslash( $_GET['platform'] ) ) : 'ios'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$ios_active      = ( 'ios' === $platform_active ) ? 'active' : '';
$android_active  = ( 'android' === $platform_active ) ? 'active' : '';
$page_get        = ( ! empty( $_GET['page'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$setting_get     = ( ! empty( $_GET['setting'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'bbapp-notification' === $page_get && 'new' === $setting_get ) {
	$screen_active = 'push-notification';
} elseif ( 'bbapp-appearance' === $page_get && 'typography' === $setting_get ) {
	$screen_active = 'font-body';
} elseif ( 'bbapp-appearance' === $page_get && 'styling' === $setting_get ) {
	$screen_active = 'color-general';
}

if ( 'bbapp-menus' !== $page_get ) {
	require bbapp()->plugin_dir . 'views/preview/common/styles.php';
}
?>
<div class="bbapp-phone-pane active" data-screen="<?php echo esc_attr( $screen_active ); ?>">
	<div class="bbapp-phone-frame ios <?php echo esc_attr( $ios_active ); ?>">
		<img src="<?php echo esc_url( bbapp()->plugin_url . 'assets/img/device-frame-iphone.png' ); ?>" class="phone-frame" alt="<?php esc_attr_e( 'iPhone', 'buddyboss-app' ); ?>"/>
		<div class="style-out">
			<span class="bbapp-loader-wrap">
				<span class="spinner ab-spinner is-active"></span>
				<span>
					<?php echo esc_html__( 'Loading Preview...', 'buddyboss-app' ); ?>
				</span>
			</span>
		</div>
	</div>
	<div class="bbapp-phone-frame android <?php echo esc_attr( $android_active ); ?>">
		<img src="<?php echo esc_url( bbapp()->plugin_url . 'assets/img/device-frame-android.png' ); ?>" class="phone-frame" alt="<?php esc_attr_e( 'Android', 'buddyboss-app' ); ?>"/>
		<div class="style-out">
			<span class="bbapp-loader-wrap">
				<span class="spinner ab-spinner is-active"></span>
				<span>
					<?php echo esc_html__( 'Loading Preview...', 'buddyboss-app' ); ?>
				</span>
			</span>
		</div>
	</div>
	<!-- Platform Screen Preview -->
	<div class="bbapp-phone-tabs">
		<div class="bbapp-phone-tab ios <?php echo esc_attr( $ios_active ); ?>" data-tab="ios">
			<i class="bb-icon-f bb-icon-brand-apple"></i>
			<span><?php esc_html_e( 'iPhone', 'buddyboss-app' ); ?></span>
		</div>
		<div class="bbapp-phone-tab android <?php echo esc_attr( $android_active ); ?>" data-tab="android">
			<i class="bb-icon-f bb-icon-brand-android"></i>
			<span><?php esc_html_e( 'Android', 'buddyboss-app' ); ?></span>
		</div>
	</div>
	<!-- End Platform Screen Preview -->
</div>
