<?php
/**
 * Holds preview fonts HTML.
 *
 * @package BuddyBossApp\Admin
 */

use BuddyBossApp\Admin\Appearance;
use BuddyBossApp\AppSettings;
use BuddyBossApp\Branding;
use BuddyBossApp\Common\IconPicker;
use BuddyBossApp\Menu;
use BuddyBossApp\Styling;
use BuddyBossApp\Typography;

/**
 * Function to Google fonts.
 */
/**
 * Font output.
 *
 * @since 1.7.0
 */
function buddyboss_app_fonts_output() {
	$default_fonts = array(
		array(
			'font-family' => 'SF UI Text',
			'src'         => bbapp()->plugin_aws_url . 'fonts/default/SFUIText-LightItalic.ttf',
			'font-weight' => 300,
			'font-style'  => 'italic',
		),
		array(
			'font-family' => 'SF UI Text',
			'src'         => bbapp()->plugin_aws_url . 'fonts/default/SFUIText-Regular.ttf',
			'font-weight' => 400,
			'font-style'  => 'normal',
		),
		array(
			'font-family' => 'SF UI Text',
			'src'         => bbapp()->plugin_aws_url . 'fonts/default/SFUIText-RegularItalic.ttf',
			'font-weight' => 400,
			'font-style'  => 'italic',
		),
		array(
			'font-family' => 'SF UI Text',
			'src'         => bbapp()->plugin_aws_url . 'fonts/default/SFUIText-Medium.ttf',
			'font-weight' => 500,
			'font-style'  => 'normal',
		),
		array(
			'font-family' => 'SF UI Text',
			'src'         => bbapp()->plugin_aws_url . 'fonts/default/SFUIText-Semibold.ttf',
			'font-weight' => 600,
			'font-style'  => 'normal',
		),
	);

	$typography      = Typography::instance();
	$installed_fonts = $typography->get_installed_fonts( true );
	$fonts           = array();
	$font_url        = Typography::instance()->get_fonts_upload_url();
	if ( isset( $installed_fonts ) && is_array( $installed_fonts ) ) {
		$i = 0;

		foreach ( $installed_fonts as $font_name => $installed_font ) {
			if ( 'Default' === $font_name ) {
				continue;
			}

			foreach ( $installed_font['fonts_family'] as $variant_name => $font_file_name ) {
				$parse_variant              = Typography::instance()->parse_variant_name( $variant_name );
				$font_src                   = $font_url . '/' . $font_file_name['base_name'];
				$fonts[ $i ]['font-family'] = $font_name;
				$fonts[ $i ]['src']         = $font_src;
				$fonts[ $i ]['font-weight'] = $parse_variant['weight'];
				$fonts[ $i ]['font-style']  = ( $parse_variant['italic'] ) ? 'italic' : '';
				++$i;
			}
		}
	}

	$fonts = array_merge( $fonts, $default_fonts );
	echo "<style>\n";
	if ( isset( $fonts ) && is_array( $fonts ) ) {
		foreach ( $fonts as $font ) { ?>
			@font-face {
			font-family: '<?php echo esc_attr( $font['font-family'] ); ?>';
			<?php if ( isset( $font['font-style'] ) ) : ?>
				font-style: <?php echo esc_attr( $font['font-style'] ); ?>;
			<?php endif; ?>
			font-weight: <?php echo isset( $font['font-weight'] ) ? esc_attr( $font['font-weight'] ) : ''; ?>;
			src: url(<?php echo esc_url( $font['src'] ); ?>) format('truetype');
			}
			<?php
		}
	}
	echo "\n</style>";
}

buddyboss_app_fonts_output();


$platform             = isset( $_GET['platform'] ) ? sanitize_text_field( wp_unslash( $_GET['platform'] ) ) : 'ios'; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$default_ios_font     = 'SF UI Text';
$default_android_font = $default_ios_font;

$styling_obj     = Styling::instance();
$styling_options = $styling_obj->get_options();

$branding_data = Branding::instance()->get_branding();

$typography_obj  = Typography::instance();
$typography_data = $typography_obj->get_bbapp_typography();

// For Typography options.
$body_text_data        = $typography_data['bodyText'];
$app_header_title_data = $typography_data['appHeaderTitle'];
$app_headings_data     = $typography_data['appHeadings'];
$app_tab_bar_data      = $typography_data['appTabBar'];
$app_menus_data        = $typography_data['appMenus'];


$preview_data = array();
$preview_data = $styling_obj->get_styling_colors();

$preview_data['typography'] = $typography_data;
$preview_data['fonts']      = $typography_obj->get_installed_fonts( true );
$preview_data['api']        = array();
$preview_data['platform']   = Appearance::instance()->get_branding_platform_preview(); // Get default platform preview.


// this condition use for existing menus.
$nav_menu_id_tabbar    = \BuddyBossApp\Menus\MenuManager::instance()->get_default_menu_id( 'tabbar' );
$nav_menu_id_more      = \BuddyBossApp\Menus\MenuManager::instance()->get_default_menu_id( 'more' );
$nav_menu_id_headerbar = \BuddyBossApp\Menus\MenuManager::instance()->get_default_menu_id( 'headerbar' );

if ( ! empty( $_GET['setting'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	if ( 'tabbar' === sanitize_text_field( wp_unslash( $_GET['setting'] ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$nav_menu_id_tabbar    = !empty( $_REQUEST['menu'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['menu'] ) ) : $nav_menu_id_tabbar; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$nav_menu_id_headerbar = \BuddyBossApp\Menus\MenuManager::instance()->get_headerbar_menu_from_tabbar_id( $nav_menu_id_tabbar );
	}

	if ( 'more' === sanitize_text_field( wp_unslash( $_GET['setting'] ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$nav_menu_id_more = ! empty( $_REQUEST['menu'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['menu'] ) ) : $nav_menu_id_more; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	}

	if ( 'headerbar' === sanitize_text_field( wp_unslash( $_GET['setting'] ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$nav_menu_id_headerbar = ! empty( $_REQUEST['menu'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['menu'] ) ) : $nav_menu_id_headerbar; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$nav_menu_id_tabbar    = \BuddyBossApp\Menus\MenuManager::instance()->get_tabbar_menu_from_headerbar_id( $nav_menu_id_headerbar );
	}
}

$request = new WP_REST_Request();
$request->set_param( 'allow_more', true );
/**
 * Menu API.
 */
$response = Menu::instance()->rest_response( $request, $nav_menu_id_tabbar, $nav_menu_id_more );
$menus    = (object) array(
	'tabbar'    => array(),
	'more'      => array(),
	'headerbar' => array(),
);

if ( 200 === $response->get_status() ) {
	$menus = $response->get_data();
}

$app_settings = AppSettings::instance();

$preview_data['settings']['app_menu']['appmenu_labels']     = $app_settings->get_setting_value( 'app_menu.appmenu_labels' );
$preview_data['settings']['bbapp_icons']['path']            = IconPicker::instance()->icon_picker_app_icon_url();
$preview_data['settings']['bbapp_icons']['bb_path']         = IconPicker::instance()->icon_picker_bb_icon_url();
$preview_data['settings']['bbapp_icons']['custom_path']     = IconPicker::instance()->icon_picker_custom_icon_dir();
$preview_data['settings']['bbapp_icons']['custom_url']      = IconPicker::instance()->icon_picker_custom_icon_url();
$preview_data['settings']['branding']['show_spinner']       = isset( $branding_data['splash_show_spinner'] ) ? $branding_data['splash_show_spinner'] : 0;
$preview_data['settings']['app_menu']['more_menu_position'] = \BuddyBossApp\Menus\MenuManager::instance()->get_more_menu_position( $nav_menu_id_headerbar );
$preview_data['settings']['app_menu']['headerbar_count']    = count( $menus['headerbar'] ) + 1;

$preview_data['api']['menu'] = $menus;
?>
<script>
	const _typeofBbpreview = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? function( obj ) {
		return typeof obj;
	} : function( obj ) {
		return obj && typeof Symbol === 'function' && obj.constructor === Symbol ? 'symbol' : typeof obj;
	};

	function _toConsumableArrayBbpreview( arr ) {
		if ( Array.isArray( arr ) ) {
			const arr2 = Array( arr.length );
			let i = 0;

			for ( ; i < arr.length; i++ ) {
				arr2[ i ] = arr[ i ];
			}

			return arr2;
		}

		return Array.from( arr );
	}

	function previewDataDeepMerge() {
		const _len = arguments.length;
		const objects = Array( _len );
		let _key = 0;
		const isObject = function isObject( obj ) {
			return obj && (
				typeof obj === 'undefined' ? 'undefined' : _typeofBbpreview( obj )
			) === 'object';
		};

		for ( ; _key < _len; _key++ ) {
			objects[ _key ] = arguments[ _key ];
		}

		return objects.reduce( function( prev, obj ) {
			Object.keys( obj ).forEach( function( key ) {
				const pVal = prev[ key ];
				const oVal = obj[ key ];

				if ( Array.isArray( pVal ) && Array.isArray( oVal ) ) {
					prev[ key ] = pVal.concat.apply( pVal, _toConsumableArrayBbpreview( oVal ) );
				} else if ( isObject( pVal ) && isObject( oVal ) ) {
					prev[ key ] = previewDataDeepMerge( pVal, oVal );
				} else {
					prev[ key ] = oVal;
				}
			} );

			return prev;
		}, {} );
	}

	window.bb_app_preview_data = <?php echo wp_json_encode( $preview_data ); ?>;

	/**
	 * Device platform select.
	 *
	 * @param {string} platform - The platform.
	 */
	function buddybossAppDevicePlatform( platform = '' ) {
		if ( '' !== platform ) {
			window.bb_app_preview_data.platform = platform;
		}

		jQuery( '.manage-menus form input[name="platform"]' ).val( window.bb_app_preview_data.platform );
		jQuery( '.buddyboss-app-screen ul.subsubsub li' ).each( function( index, element ) {
			let uri = jQuery( element ).find( 'a' ).attr( 'href' );
			uri = bbappCore.helper.bbapp_remove_url_parameter( uri, 'platform' );
			uri = uri + (
				uri.indexOf( '?' ) > 0 ? '&' : '?'
			) + 'platform' + '=' + window.bb_app_preview_data.platform;

			jQuery( element ).find( 'a' ).attr( 'href', uri );
		} );

		const windowURL = window.location.href;
		const newWindowURL = bbappCore.helper.bbapp_remove_url_parameter( windowURL, 'platform' );

		window.history.pushState( null, null, newWindowURL );

		let uri = window.location.toString();
		uri = uri + (
			uri.indexOf( '?' ) > 0 ? '&' : '?'
		) + 'platform' + '=' + window.bb_app_preview_data.platform;

		window.history.replaceState( {}, document.title, uri );
	}

	function buddybossAppUpdatePreviewStyles( newData = {} ) {
		window.bb_app_preview_data = previewDataDeepMerge( window.bb_app_preview_data, newData );

		/**
		 * Style Template
		 */
		if ( wp.template === null || wp.template === '' || 'undefined' === typeof wp.template ) {
			return;
		}

		let template = wp.template( 'buddyboss-app-preview-styles' );
		const style = template( bb_app_preview_data );
		const element = document.createElement( 'style' );

		element.setAttribute( 'type', 'text/css' );
		element.setAttribute( 'id', 'buddyboss-app-preview' );

		if ( 'textContent' in element ) {
			element.textContent = style;
		} else {
			element.styleSheet.cssText = style;
		}

		document.getElementsByTagName( 'head' )[ 0 ].appendChild( element );

		// remove the old one.
		if ( jQuery( "style[id='buddyboss-app-preview']" ).length > 1 ) {
			jQuery( "style[id='buddyboss-app-preview']" ).first().remove();
		}

		/**
		 * Tabbar Template
		 */
		if ( jQuery( '.bbapp-preview-tabbar' ).length > 0 ) {
			template = wp.template( 'buddyboss-app-preview-tabbar' );
			const tabbar = template( bb_app_preview_data );

			jQuery( '.bbapp-preview-tabbar' ).html( '' ).append( tabbar );
		}

		/**
		 * More Template
		 */
		if ( jQuery( '.bbapp-preview-more' ).length > 0 ) {
			template = wp.template( 'buddyboss-app-preview-more' );
			const more = template( bb_app_preview_data );

			jQuery( '.bbapp-preview-more' ).html( '' ).append( more );
		}

		/**
		 * Headerbar Template.
		 */
		if ( jQuery( '.bbapp-preview-headerbar' ).length > 0 ) {
			template = wp.template( 'buddyboss-app-preview-headerbar' );
			const headerBar = template( bb_app_preview_data );

			jQuery( '.bbapp-preview-headerbar' ).find( '.header-bar-block_actions' ).html( '' ).append( headerBar );
		}
	}

	/**
	 * Return the correct family.
	 *
	 * @param {string} family - The font family.
	 */
	function buddybossAppFilterFamily( family ) {
		if ( family === 'Default' ) {
			return 'SF UI Text';
		}

		return family;
	}

	function buddybossAppFontByFamily( family, data ) {
		if ( family === 'SF UI Text' ) {
			family = 'Default';
		}

		let rval = {
			name: 'System Default',
			fonts_family: {
				regular: {
					ext: '',
					default: true,
					base64: '',
					family: 'Default',
				},
			},
			scale: '100',
		};

		jQuery.each( data.fonts, function( i, v ) {
			if ( i === family ) {
				rval = v;
			}

			jQuery.each( v.fonts_family, function( variantName ) {
				if ( i + '-' + variantName.toLowerCase().replace( /\b[a-z]/g, function( letter ) {
					return letter.toUpperCase();
				} ) === family ) {
					rval = v;
				}
			} );
		} );

		return rval;
	}

	jQuery( document ).ready( function() {
		buddybossAppUpdatePreviewStyles();
		// buddybossAppDevicePlatform();

		// When ever preview changes refresh styles.
		jQuery( '.bbapp-phone-tab' ).click( function () {
			buddybossAppUpdatePreviewStyles( {} );
		} );

		// binds colors fields.
		jQuery( '.quick-field' ).change( function() {
			const colorname = jQuery( this ).attr( 'name' ).replace( 'styles[styles.colors.', '' ).replace( ']', '' );
			const obj = {
				colors: {},
			};
			obj.colors[ colorname ] = jQuery( this ).val();

			buddybossAppUpdatePreviewStyles( obj );
		} );

		// Branding splash colors fields.
		jQuery( '#bbapp_field_splash_spinner_color' ).change( function() {
			const colorname = jQuery( this ).attr( 'name' );
			const obj = {
				colors: {},
			};
			obj.colors[ colorname ] = jQuery( this ).val();

			buddybossAppUpdatePreviewStyles( obj );
		} );

		// Branding splash show spinner checkbox.
		jQuery( '#bbapp_field_splash_show_spinner' ).click( function() {
			const obj = {
				settings: {
					branding: {
						show_spinner: jQuery( this ).is( ':checked' ),
					},
				},
			};

			buddybossAppUpdatePreviewStyles( obj );
		} );

		// Bind the font scale selection fields.
		jQuery( '.font-scale__opt-text' ).change( function() {
			const scaleWrap = jQuery( this ).closest( '.font-scale' );

			scaleWrap.find( '.font-scale__opt' ).val( jQuery( this ).val() ).change();
		} );

		jQuery( '.font-scale__opt' ).on( 'input', function() {
			const scaleWrap = jQuery( this ).closest( '.font-scale' );

			scaleWrap.find( '.font-scale__opt-text' ).val( jQuery( this ).val() );
			scaleWrap.find( '.font-scale__opt' ).change();
		} );

		jQuery( '.font-scale__opt' ).change( function() {
			const $fontname = jQuery( this ).attr( 'name' ).replace( 'font_scale[', '' ).replace( ']', '' );
			const obj = {
				fonts: {},
			};
			obj.fonts[ $fontname ] = {
				scale: 100,
			};
			obj.fonts[ $fontname ].scale = jQuery( this ).val();

			buddybossAppUpdatePreviewStyles( obj );
		} );

		// Bind the font family selection typography fields.
		jQuery( '.bbapp-font-select-wrap select.bbapp-app-fonts' ).change( function() {
			const fieldname = jQuery( this ).attr( 'name' ).replace( 'fonts[styles.fonts.', '' ).replace( '][name]', '' );

			const obj = {
				typography: {},
			};

			if ( jQuery( this ).val() === 'Default' ) {
				obj.typography[ fieldname ] = {
					family: 'SF UI Text',
				};
			} else {
				obj.typography[ fieldname ] = {
					family: jQuery( this ).val(),
				};
			}

			buddybossAppUpdatePreviewStyles( obj );
		} );

		// Bind tabbar label
		jQuery( '#appmenu_settings_labels' ).change( function() {
			const obj = {
				settings: {
					app_menu: {
						appmenu_labels: jQuery( this ).is( ':checked' ),
					},
				},
			};

			buddybossAppUpdatePreviewStyles( obj );
		} );

		jQuery( '.bbapp-screens-list--tab' ).change( function() {
			setTimeout( function() {
				moreIconBoxedStyle();
			}, 500 );
		} );

		jQuery( '.sidebar-name--colors' ).each( function() {
			moreIconBoxedStyle();
		} );

		jQuery( '.sidebar-name--colors' ).click( function() {
			moreIconBoxedStyle();
		} );
	} );

	/**
	 * Check more icon style
	 * This is called on colors tab bar and more screen/s.
	 */
	function moreIconBoxedStyle() {
		const currentScreen = bbappCore.helper.bbapp_get_url_parameter( 'screen' );
		const iconStyle = bb_app_preview_data.settings.app_menu.more_icon_style;

		jQuery( 'body' ).removeClass( 'more-icon-boxed-style' );

		if ( 'boxed' === iconStyle && 'color-more' === currentScreen ) {
			jQuery( 'body' ).addClass( 'more-icon-boxed-style' );
		} else {
			jQuery( 'body' ).removeClass( 'more-icon-boxed-style' );
		}
	}

	/**
	 * Alter the preview data api data based on live edit screen.
	 * This should be called by all events & changes on menu edit screen.
	 */
	function bbappPreviewRenderTabbarMenus() {
		let currentMenu = bbappCore.helper.bbapp_get_url_parameter( 'setting' );

		if ( 'undefined' === typeof currentMenu ) {
			currentMenu = 'tabbar';
		}

		if ( 'headerbar' === currentMenu ) {
			return;
		}

		if ( 'more' !== currentMenu ) {
			bb_app_preview_data.api.menu.tabbar = []; // empty the old entries

			const tabbar = [];
			const $allMenus = jQuery( 'ul#appmenu-to-edit li' );

			$allMenus.each( function() {
				const $li = jQuery( this );

				if ( true === $li.hasClass( 'bbapp-mark-red' ) ) {
					return;
				}

				const id = $li.find( '.menu-item-id' ).val();
				const menuLabel = $li.find( '.edit-menu-item-label' ).val();
				const menuObject = $li.find( '.menu-item-object' ).val();
				const menuType = $li.find( '.menu-item-data-type' ).val();
				const iconType = ('undefined' !== typeof $li.find( '.menu-item-icon-type' ).val()) ? $li.find( '.menu-item-icon-type' ).val() : '';
				const iconFiledData = JSON.parse( $li.find( '.bbapp_app_icon_picker_data' ).val() );
				const iconData = {
					id: iconFiledData.id,
					uri: iconFiledData.extra.img_url,
					type: iconFiledData.type,
					style: iconFiledData.style,
					box_style: iconFiledData.box_style,
					color: iconFiledData.color,
					fill_color: iconFiledData.fill_color,
					fg_color: iconFiledData.fg_color ? iconFiledData.fg_color : 'transparent',
				};
				const item = {
					data: {},
					icon: iconData,
					id,
					label: menuLabel,
					object: menuObject,
					type: menuType,
					icon_type: iconType,
				};
				tabbar.push( item );
			} );

			buddybossAppUpdatePreviewStyles( {
				api: {
					menu: {
						tabbar,
					},
				},
			} );
		}
	}

	/**
	 * Alter the preview data api data based on live edit screen.
	 * This should be called by all events & changes on menu edit screen.
	 */
	function bbappPreviewRenderMoreMenus() {
		bb_app_preview_data.api.menu.more = []; // empty the old entries

		const more = [];
		const $allMenus = jQuery( 'ul#appmenu-to-edit li' );

		$allMenus.each( function() {
			const $li = jQuery( this );

			if ( true === $li.hasClass( 'bbapp-mark-red' ) ) {
				return;
			}

			const id = $li.find( '.menu-item-id' ).val();
			const menuLabel = $li.find( '.edit-menu-item-label' ).val();
			const menuObject = $li.find( '.menu-item-object' ).val();
			const menuType = $li.find( '.menu-item-data-type' ).val();
			let item = {};

			if ( 'section' === menuObject ) {
				item = {
					id,
					label: menuLabel,
					object: menuObject,
					type: menuType,
					data: {},
					section: [],
				};

				$li.nextAll().each( function( liIndex, element ) {
					if ( true === jQuery( element ).hasClass( 'menu-item-depth-1' ) ) {
						if ( true === jQuery( element ).hasClass( 'bbapp-mark-red' ) ) {
							return;
						}

						const $sectionItem = jQuery( element );
						const liId = $sectionItem.find( '.menu-item-id' ).val();
						const liMenuLabel = $sectionItem.find( '.edit-menu-item-label' ).val();
						const liMenuObject = $sectionItem.find( '.menu-item-object' ).val();
						const liMenuType = $sectionItem.find( '.menu-item-data-type' ).val();
						const iconFiledData = JSON.parse( $sectionItem.find( '.bbapp_app_icon_picker_data' ).val() );
						const iconData = {
							id: iconFiledData.id,
							uri: iconFiledData.extra.img_url,
							type: iconFiledData.type,
							style: iconFiledData.style,
							box_style: iconFiledData.box_style,
							color: iconFiledData.color,
							fill_color: iconFiledData.fill_color,
							fg_color: iconFiledData.fg_color ? iconFiledData.fg_color : 'transparent',
						};

						const sectionItems = {
							id: liId,
							label: liMenuLabel,
							object: liMenuObject,
							type: liMenuType,
							data: {},
							icon: iconData,
						};
						item.section.push( sectionItems );
					} else {
						return false; // break the loop.
					}
				} );
			} else if ( true !== $li.hasClass( 'menu-item-depth-1' ) ) {
				if ( true === $li.hasClass( 'bbapp-mark-red' ) ) {
					return;
				}

				const iconFiledData = JSON.parse( $li.find( '.bbapp_app_icon_picker_data' ).val() );
				const iconData = {
					id: iconFiledData.id,
					uri: iconFiledData.extra.img_url,
					type: iconFiledData.type,
					style: iconFiledData.style,
					box_style: iconFiledData.box_style,
					color: iconFiledData.color,
					fill_color: iconFiledData.fill_color,
					fg_color: iconFiledData.fg_color ? iconFiledData.fg_color : 'transparent',
				};

				item = {
					id,
					label: menuLabel,
					object: menuObject,
					type: menuType,
					data: {},
					icon: iconData,
				};
			}

			if ( ! jQuery.isEmptyObject( item ) ) {
				more.push( item );
			}
		} );

		buddybossAppUpdatePreviewStyles( {
			api: {
				menu: {
					more,
				},
			},
		} );
	}

	/**
	 * Alter the preview data api data based on live edit screen.
	 * This should be called by all events & changes on menu edit screen.
	 */
	function bbappPreviewRenderHeaderBarMenus() {
		let currentMenu = bbappCore.helper.bbapp_get_url_parameter( 'setting' );

		if ( 'undefined' === typeof currentMenu ) {
			return;
		}

		if ( 'headerbar' !== currentMenu ) {
			return;
		}

		bb_app_preview_data.api.menu.headerbar = []; // empty the old entries
		const headerbar = [];
		const $allMenus = jQuery( 'ul#appmenu-to-edit li' );

		$allMenus.each( function() {
			const $li = jQuery( this );

			if ( true === $li.hasClass( 'bbapp-mark-red' ) ) {
				return;
			}

			const id = $li.find( '.menu-item-id' ).val();
			const menuLabel = $li.find( '.edit-menu-item-label' ).val();
			const menuObject = $li.find( '.menu-item-object' ).val();
			const menuType = $li.find( '.menu-item-data-type' ).val();
			const iconType = ('undefined' !== typeof $li.find( '.menu-item-icon-type' ).val()) ? $li.find( '.menu-item-icon-type' ).val() : '';
			
			const iconFiledData = JSON.parse( $li.find( '.bbapp_app_icon_picker_data' ).val() );
			const iconData = {
				id: iconFiledData.id,
				uri: iconFiledData.extra.img_url,
				type: iconFiledData.type,
				style: iconFiledData.style,
				box_style: iconFiledData.box_style,
				color: iconFiledData.color,
				fill_color: iconFiledData.fill_color,
				fg_color: iconFiledData.fg_color ? iconFiledData.fg_color : 'transparent',
			};

			const item = {
				data: {},
				icon: iconData,
				id,
				label: menuLabel,
				object: menuObject,
				type: menuType,
				icon_type: iconType,
			};
			headerbar.push( item );
		} );

		buddybossAppUpdatePreviewStyles( {
			api: {
				menu: {
					headerbar: headerbar,
				},
			},
		} );
	}
</script>

<script type="text/html" id="tmpl-buddyboss-app-preview-styles">
	.bbapp-phone-frame .style-out .primaryColor.bgr-attr {
	background-color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .bb-count.primaryColor.bgr-attr {
	background-color: {{{ data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .authBgColor,
	.bbapp-phone-frame .style-out .authBgColor.bgr-attr {
	background-color: {{{data.colors.authBgColor}}}
	}

	/*.font-scale-Default {
	zoom: 110%
	}*/

	.bbapp-phone-frame .style-out .highlightColor.bgr-attr {
	background-color: {{{data.colors.primaryColor}}}
	}


	.bbapp-phone-frame .style-out .bodyFrontBg,
	.bbapp-phone-frame .style-out .bodyFrontBg.bgr-attr,
	.bbapp-phone-frame .style-out .bodyBg.bodyFrontBg,
	.bbapp-phone-frame .style-out .bodyBg.bodyFrontBg.bgr-attr {
	background-color: {{{data.colors.bodyFrontBg}}}
	}

	.bbapp-phone-frame .style-out .bodyBg,
	.bbapp-phone-frame .style-out .bodyBg.bgr-attr {
	background-color: {{{data.colors.bodyBg}}}
	}

	.bbapp-phone-frame .style-out .borderColor.bgr-attr {
	background-color: {{{data.colors.borderColor}}}
	}

	.bbapp-phone-frame .style-out .headerBg.bgr-attr {
	background-color: {{{data.colors.headerBg}}}
	}

	.bbapp-phone-frame .style-out .headerColor.bgr-attr {
	color: {{{data.colors.headerColor}}}
	}

	.bbapp-phone-frame .style-out .headerIconColor.bgr-attr {
	background-color: {{{data.colors.headerIconColor}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsBg,
	.bbapp-phone-frame .style-out .bottomTabsBg.bgr-attr {
	background-color: {{{data.colors.bottomTabsBg}}}
	}

	.bbapp-phone-frame .style-out .drawerActiveBgColor,
	.bbapp-phone-frame .style-out .drawerActiveBgColor.bgr-attr {
	background-color: {{{data.colors.drawerActiveBgColor}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonBg,
	.bbapp-phone-frame .style-out .primaryButtonBg.bgr-attr {
	background-color: {{{data.colors.primaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonColor,
	.bbapp-phone-frame .style-out .primaryButtonColor.bgr-attr {
	color: {{{data.colors.primaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonBg,
	.bbapp-phone-frame .style-out .secondaryButtonBg.bgr-attr,
	.iap-prdt-preview__price span {
	background-color: {{{data.colors.secondaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonColor,
	.bbapp-phone-frame .style-out .secondaryButtonColor.bgr-attr,
	.iap-prdt-preview__price span {
	color: {{{data.colors.secondaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .textColor.bgr-attr {
	background-color: {{{data.colors.textColor}}}
	}

	.bbapp-phone-frame .style-out .headingsColor.bgr-attr {
	background-color: {{{data.colors.headingsColor}}}
	}

	.bbapp-phone-frame .style-out .descTextColor.bgr-attr {
	background-color: {{{data.colors.descTextColor}}}
	}

	.bbapp-phone-frame .style-out .descLightTextColor.bgr-attr {
	background-color: {{{data.colors.descLightTextColor}}}
	}

	.bbapp-phone-frame .style-out .androidStatusBgColor,
	.bbapp-phone-frame .style-out .androidStatusBgColor.bgr-attr {
	background-color: {{{data.colors.androidStatusBgColor}}}
	}

	<?php /* Auth screen/s */ ?>
	.bbapp-phone-frame .style-out .authTextColor,
	.bbapp-phone-frame .style-out .authFieldTextColor label {
	color: {{{data.colors.authTextColor}}}
	}

	.authTextColor path,
	.authTextColor g {
	stroke: {{{data.colors.authTextColor}}}
	}

	.bbapp-spinner-svg {
	stroke: {{{data.colors.splash_spinner_color}}}
	}
	.bbapp_spinner{
	display:{{{(false !== data.settings.branding.show_spinner) ? 'block' : 'none'}}}
	}

	.bbapp-phone-frame .style-out .login-inside-wrapper .app-field {
	background-color: {{{data.colors.authFieldBgColor}}}
	}

	.bbapp-phone-frame .style-out .authFieldTextColor,
	.bbapp-phone-frame .style-out .authFieldTextColor.color-attr {
	color: {{{data.colors.authFieldTextColor}}}
	}

	.authFieldTextColor g,
	.authFieldTextColor path {
	stroke: {{{data.colors.authFieldTextColor}}}
	}

	.bbapp-phone-frame .style-out .authButtonBgColor {
	background-color: {{{data.colors.authButtonBgColor}}}
	}

	.bbapp-phone-frame .style-out .authButtonTextColor {
	color: {{{data.colors.authButtonTextColor}}}
	}

	<?php /* Register screen/s */ ?>
	.bbapp-phone-frame .style-out .regBgColor,
	.bbapp-phone-frame .style-out .regBgColor.bgr-attr {
	background-color: {{{data.colors.regBgColor}}}
	}
	.bbapp-phone-frame .style-out .regTextColor,
	.bbapp-phone-frame .style-out .regFieldTextColor label {
	color: {{{data.colors.regTextColor}}}
	}

	.regTextColor path,
	.regTextColor g {
	stroke: {{{data.colors.regTextColor}}}
	}

	.bbapp-phone-frame .style-out .register-inside-wrapper .app-field {
	background-color: {{{data.colors.regFieldBgColor}}}
	}

	.bbapp-phone-frame .style-out .regFieldTextColor,
	.bbapp-phone-frame .style-out .regFieldTextColor.color-attr {
	color: {{{data.colors.regFieldTextColor}}}
	}

	.regFieldTextColor g,
	.regFieldTextColor path {
	stroke: {{{data.colors.regFieldTextColor}}}
	}

	.bbapp-phone-frame .style-out .regButtonBgColor {
	background-color: {{{data.colors.regButtonBgColor}}}
	}

	.bbapp-phone-frame .style-out .regButtonTextColor {
	color: {{{data.colors.regButtonTextColor}}}
	}

	/** Apply color Start**/
	.bbapp-phone-frame .style-out .primaryColor.color-attr {
	color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .bbapp-loading-bg {
	background-color: {{{data.colors.contentLoaderColor}}}
	}

	.bbapp-phone-frame .style-out .highlightColor,
	.bbapp-phone-frame .style-out .highlightColor.color-attr {
	color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .highlightColor.stroke-color:not(.live) path {
	stroke: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out a {
	color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .bodyFrontBg.color-attr {
	color: {{{data.colors.bodyFrontBg}}}
	}

	.bbapp-phone-frame .style-out .bodyBg.color-attr {
	color: {{{data.colors.bodyBg}}}
	}

	.bbapp-phone-frame .style-out .borderColor.color-attr {
	color: {{{data.colors.borderColor}}}
	}

	.bbapp-phone-frame .style-out .headerBg.color-attr {
	color: {{{data.colors.headerBg}}}
	}

	.bbapp-phone-frame .style-out .headerColor.color-attr {
	color: {{{data.colors.headerColor}}};
	}

	.bbapp-phone-frame .style-out .headerIconColor.color-attr {
	color: {{{data.colors.headerIconColor}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsBg.color-attr {
	color: {{{data.colors.bottomTabsBg}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsColor.color-attr {
	color: {{{data.colors.bottomTabsColor}}}
	}

	feFlood.bottomTabsColor {
	flood-color: {{{data.colors.bottomTabsColor}}}
	}

	feFlood.bottomTabsActiveColor {
	flood-color: {{{data.colors.bottomTabsActiveColor}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsActiveColor.color-attr {
	color: {{{data.colors.bottomTabsActiveColor}}}
	}

	.bbapp-phone-frame .style-out .phone-menu-section .active_menu span {
	color: {{{data.colors.bottomTabsActiveColor}}}
	}

	.bbapp-phone-frame .style-out .drawerActiveBgColor.color-attr {
	color: {{{data.colors.drawerActiveBgColor}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonBg.color-attr {
	color: {{{data.colors.primaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonColor.color-attr {
	color: {{{data.colors.primaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonBg.color-attr {
	color: {{{data.colors.secondaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonColor.color-attr {
	color: {{{data.colors.secondaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .textColor,
	.bbapp-phone-frame .style-out .textColor.color-attr,
	.iap-prdt-preview-wrapper .textColor {
	color: {{{data.colors.textColor}}}
	}

	.bbapp-phone-frame .style-out svg.textColor path,
	.bbapp-phone-frame .style-out svg.textColor g {
	stroke: {{{data.colors.textColor}}}
	}

	.bbapp-phone-frame .style-out svg.arrow-svg path,
	.bbapp-phone-frame .style-out svg.arrow-svg g,
	.bbapp-phone-frame .style-out .arrow-svg svg path,
	.bbapp-phone-frame .style-out .arrow-svg svg g {
	stroke: {{{data.colors.textColor}}}
	}

	.bbapp-phone-frame .style-out .headingsColor,
	.bbapp-phone-frame .style-out .headingsColor.color-attr {
	color: {{{data.colors.headingsColor}}};
	}

	.bbapp-phone-frame .style-out .descTextColor,
	.bbapp-phone-frame .style-out .descTextColor.color-attr,
	.iap-prdt-preview-wrapper .descTextColor {
	color: {{{data.colors.descTextColor}}}
	}

	.bbapp-phone-frame .style-out .descLightTextColor,
	.bbapp-phone-frame .style-out .descLightTextColor.color-attr {
	color: {{{data.colors.descLightTextColor}}}
	}

	.bbapp-phone-frame .style-out .androidStatusBgColor.color-attr {
	color: {{{data.colors.androidStatusBgColor}}}
	}

	/** Apply color End **/

	/** Apply Border color Start **/
	.bbapp-phone-frame .style-out .primaryColor.iCon {
	border-color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .highlightColor.iCon {
	border-color: {{{data.colors.primaryColor}}}
	}

	.bbapp-phone-frame .style-out .bodyFrontBg.iCon {
	border-color: {{{data.colors.bodyFrontBg}}}
	}

	.bbapp-phone-frame .style-out .bodyBg.iCon {
	border-color: {{{data.colors.bodyBg}}}
	}

	.bbapp-phone-frame .style-out .borderColor.iCon {
	border-color: {{{data.colors.borderColor}}}
	}

	.bbapp-phone-frame .style-out .headerBg.iCon {
	border-color: {{{data.colors.headerBg}}}
	}

	.bbapp-phone-frame .style-out .headerColor.iCon {
	border-color: {{{data.colors.headerColor}}}
	}

	.bbapp-phone-frame .style-out .headerIconColor.iCon {
	border-color: {{{data.colors.headerIconColor}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsBg.iCon {
	border-color: {{{data.colors.bottomTabsBg}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsColor.iCon {
	border-color: {{{data.colors.bottomTabsColor}}}
	}

	.bbapp-phone-frame .style-out .bottomTabsActiveColor.iCon {
	border-color: {{{data.colors.bottomTabsActiveColor}}}
	}

	.bbapp-phone-frame .style-out .drawerActiveBgColor.iCon {
	border-color: {{{data.colors.drawerActiveBgColor}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonBg.iCon {
	border-color: {{{data.colors.primaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .primaryButtonColor.iCon {
	border-color: {{{data.colors.primaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonBg.iCon {
	border-color: {{{data.colors.secondaryButtonBg}}}
	}

	.bbapp-phone-frame .style-out .secondaryButtonColor.iCon {
	border-color: {{{data.colors.secondaryButtonColor}}}
	}

	.bbapp-phone-frame .style-out .textColor.iCon {
	border-color: {{{data.colors.textColor}}}
	}

	.bbapp-phone-frame .style-out .headingsColor.iCon {
	border-color: {{{data.colors.headingsColor}}}
	}

	.bbapp-phone-frame .style-out .descTextColor.iCon {
	border-color: {{{data.colors.descTextColor}}}
	}

	.bbapp-phone-frame .style-out .descLightTextColor.iCon {
	border-color: {{{data.colors.descLightTextColor}}}
	}

	.bbapp-phone-frame .style-out .androidStatusBgColor.iCon {
	border-color: {{{data.colors.androidStatusBgColor}}}
	}

	.bbapp-phone-frame .style-out .headerIconColor path {
	stroke: {{{data.colors.headerIconColor}}}
	}

	.bbapp-phone-frame .style-out .borderColor {
	border-color: {{{data.colors.borderColor}}}
	}

	.bbapp-phone-frame .style-out .coursesLabelCompleted {
	background-color: {{{data.colors.coursesLabelCompleted}}}
	}

	.bbapp-phone-frame .style-out .coursesLabelProgress {
	background-color: {{{data.colors.coursesLabelProgress}}}
	}

	.bbapp-phone-frame .style-out .coursesLabelStart {
	background-color: {{{data.colors.coursesLabelStart}}}
	}

	.bbapp-phone-frame .style-out .coursesLabelFree {
	background-color: {{{data.colors.coursesLabelFree}}}
	}

	.bbapp-phone-frame .style-out .coursesLabelNotEnrolled {
	background-color: {{{data.colors.coursesLabelNotEnrolled}}}
	}

	.bbapp-phone-frame .style-out .bbapp-style-bodyText,
	.bbapp-phone-frame .style-out .bbapp-style-bodyText p,
	.iap-prdt-preview-wrapper .bbapp-style-bodyText {
	font-family: {{{buddybossAppFilterFamily(data.typography.bodyText.family)}}};
	}

	.bbapp-style-bodyText,
	.bbapp-style-bodyText p {
	font-size: {{{data.typography.bodyText.size}}}px;
	}

	.bbapp-style-bodyText {
	<#
	var font_scale=buddybossAppFontByFamily(data.typography.bodyText.family,data).scale #>
	zoom: {{{font_scale}}}%;
	}

	.bbapp-phone-frame .style-out .bbapp-style-appHeaderTitle {
	font-family: {{{buddybossAppFilterFamily(data.typography.appHeaderTitle.family)}}};
	}

	.bbapp-style-appHeaderTitle {
	font-size: {{{data.typography.appHeaderTitle.size}}}px;
	}

	.bbapp-style-appHeaderTitle {
	<# var font_scale=buddybossAppFontByFamily(data.typography.appHeaderTitle.family,data).scale #>
	zoom: {{{font_scale}}}%;
	}

	.bbapp-phone-frame .style-out .bbapp-style-appHeadings,
	.iap-prdt-preview-wrapper .bbapp-style-appHeadings {
	font-family: {{{buddybossAppFilterFamily(data.typography.appHeadings.family)}}};
	}

	.bbapp-style-appHeadings {
	font-size: {{{data.typography.appHeadings.size}}}px;
	}

	.bbapp-style-appHeadings {
	<# var font_scale=buddybossAppFontByFamily(data.typography.appHeadings.family,data).scale #>
	zoom: {{{font_scale}}}%;
	}

	.bbapp-phone-frame .style-out .bbapp-style-appTabBar {
	font-family: {{{buddybossAppFilterFamily(data.typography.appTabBar.family)}}};
	}

	.bbapp-style-appTabBar {
	font-size: {{{data.typography.appTabBar.size}}}px;
	}

	.bbapp-style-appTabBar {
	<# var font_scale=buddybossAppFontByFamily(data.typography.appTabBar.family,data).scale #>
	zoom: {{{font_scale}}}%;
	}

	.bbapp-phone-frame .style-out .bbapp-style-appMenus {
	font-family: {{{buddybossAppFilterFamily(data.typography.appMenus.family)}}};
	}

	.bbapp-style-appMenus {
	font-size: {{{data.typography.appMenus.size}}}px;
	}

	.bbapp-style-appMenus {
	<# var font_scale=buddybossAppFontByFamily(data.typography.appMenus.family,data).scale #>
	zoom: {{{font_scale}}}%;
	}

	.bbapp-phone-frame .style-out .iapStatusCheckmark {
	fill: {{{data.colors.iapStatusCheckmark}}}
	}

	.bbapp-phone-frame .style-out .iap-block__ico i {
	color: {{{data.colors.iapStatusCheckmark}}}
	}

	.bbapp-phone-frame .style-out .iapBenefitsCheckmark {
	fill: {{{data.colors.iapBenefitsCheckmark}}};
	}

	.bbapp-phone-frame .style-out .iap-block__list-check i {
	color: {{{data.colors.iapBenefitsCheckmark}}};
	}

	.bbapp-phone-frame .style-out span.iapBenefitsCheckmark,
	.iap-prdt-preview__benefits li span.iapBenefitsCheckmark {
	background-color: {{{data.colors.iapBenefitsCheckmark}}};
	}

	.iap-prdt-preview__benefits li span.iap-prdt-benefit-ico span.dashicons {
	color: {{{data.colors.iapBenefitsCheckmark}}};
	}

	.bbapp-phone-frame .bbapp-group-directory-button.labelBgColor {
	background-color: {{{data.colors.labelBgColor}}}
	}

	.bbapp-phone-frame .bbapp-group-directory-button .labelTextColor {
	color: {{{data.colors.labelTextColor}}}
	}
	<?php /* JS CODE Below */ ?>
</script>
