<?php
/**
 * Menu Common Screen
 *
 * @package BuddyBossApp\Admin
 */

$setting_tabs = array(
	'login_information' => array(
		'label' => __( 'Phasellus gravida', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-l bb-icon-user"></i>',
		'count' => '',
	),
	'privacy_settings'  => array(
		'label' => __( 'Nam quam', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-l bb-icon-lock"></i>',
		'count' => '',
	),
	'group_invites'     => array(
		'label' => __( 'Donec vitae', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-l bb-icon-user-friends"></i>',
		'count' => '<a class="primaryColor color-attr bb-count-wrap" href="#"><span class="bb-count primaryColor bgr-attr"></span><span class="bb-count-text primaryColor color-attr">26</span></a>',
	),
	'about'             => array(
		'label' => __( 'Duis', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-rl bb-icon-exclamation"></i>',
		'count' => '<a class="primaryColor color-attr bb-count-wrap" href="#"><span class="bb-count primaryColor bgr-attr"></span><span class="bb-count-text primaryColor color-attr">12</span></a>',
	),
	'send_feedback'     => array(
		'label' => __( 'Morbi', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-l bb-icon-thumbs-up"></i>',
		'count' => '',
	),
	'report_bug'        => array(
		'label' => __( 'Morbi mollis tellus', 'buddyboss-app' ),
		'icon'  => '<i class="bb-icon-l bb-icon-bug"></i>',
		'count' => '',
	),
);
?>

<div class="style-over-flow phone-style-stamp bodyBg bgr-attr settings-list-wrapper">
	<div class=" profile-wrapper">
		<div class="bb-inside-wrapper">
			<div class="member-profile-footer bodyFrontBg">
				<?php foreach ( $setting_tabs as $key => $tab_single ) { ?>
					<div class="member-action-item textColor color-attr borderColor <?php echo esc_attr( $key ); ?>">
						<?php
						if ( $tab_single['icon'] ) {
							echo wp_kses_post( $tab_single['icon'] );
						} else {
							?>
							<svg width="24" height="22" xmlns="http://www.w3.org/2000/svg">
								<g stroke="#000" stroke-width="1.5" fill="none" fill-rule="evenodd">
									<rect x=".75" y=".75" width="22.5" height="20.5" rx="4"/>
									<path d="M5 12.199h2.349a.583.583 0 00.514-.308L9.32 9.167h0l2.33 7.333 2.515-11 2.174 6.306a.583.583 0 00.552.393H19" stroke-linecap="round" stroke-linejoin="round"/>
								</g>
							</svg>
						<?php } ?>
						<span class="action-item-label bbapp-style-appMenus"><?php echo esc_html( $tab_single['label'] ); ?></span>
						<?php
						if ( '' !== $tab_single['count'] ) {
							echo wp_kses_post( $tab_single['count'] );
						}
						?>
						<span class="arrow-svg">
							<i class="bb-icon-f bb-icon-angle-right"></i>
						</span>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
