<?php
/**
 * Holds open on app HTML.
 *
 * @package BuddyBossApp
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		#bbapp_mobile_verification {
			text-align: center;
			display: block;
			width: 130px;
			margin: auto;
			color: #46b450;
			text-decoration: none;
			font-family: sans-serif;
			margin-top: 40px;
		}
	</style>
</head>
<body>
<!-- we can't change to esc_url because the url not is web formatted, it's for app only -->
<a href="<?php echo esc_attr( $url ); ?>" id="bbapp_mobile_verification"><?php esc_html_e( 'Open in App', 'buddyboss-app' ); ?>
</a>
<script>
	const el = document.getElementById( 'bbapp_mobile_verification' );
	if ( el.onclick ) {
		el.onclick();
	} else if ( el.click ) {
		el.click();
	}
</script>
</body>
