<?php
/**
 * Holds menus settings.
 *
 * @package BuddyBossApp\Admin\Menus
 */

$tab_bar_icon_style = \BuddyBossApp\AppSettings::instance()->get_setting_value( 'app_menu.tab_bar_icon_style' );
$appmenu_labels     = \BuddyBossApp\AppSettings::instance()->get_setting_value( 'app_menu.appmenu_labels' );
$tab_bar_visibility = \BuddyBossApp\AppSettings::instance()->get_setting_value( 'app_menu.tab_bar_visibility' );
$tab_bar_visibility = $tab_bar_visibility ? $tab_bar_visibility : 'show_on_tab_bar_menu';

?>
<div id="bbapp-widgets">
	<div class="bbapp-widget-liquid">
		<div class="widgets-holder-wrap menu-settings bbapp-active">
			<div class="widgets-sortables">
				<div class="sidebar-name sidebar-name--menus" data-tab="menu-settings" data-add-to="Add to: <?php echo esc_html__( 'Tab Bar Settings', 'buddyboss-app' ); ?>">
					<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
						<span class="screen-reader-text">
							<?php echo esc_html__( 'Tab Bar Settings', 'buddyboss-app' ); ?>
						</span>
						<span class="toggle-indicator" aria-hidden="true"></span>
					</button>
					<h3 class="bbapp-widget-title">
						<?php echo esc_html__( 'Tab Bar Settings', 'buddyboss-app' ); ?>
						<span class="spinner"></span>
					</h3>
				</div>
				<div class="bbapp-widget-content sidebar-description">
					<form id="bbapp-update-menu-setting" method="post">
						<?php wp_nonce_field( 'update-nav-appmenu-setting', 'update-nav-appmenu-setting-nonce' ); ?>
						<input type="hidden" name="action" value="app_menu_setting_save"/>
						<div class="bbapp-palette-flow bbapp-menu-settings">
							<div class="bbapp-menu-setting-list">
								<label for="menu-setting">
										<span class="bbapp-menu-setting-label">
											<?php esc_html_e( 'Icon Labels', 'buddyboss-app' ); ?>
										</span>
									<input <?php checked( $appmenu_labels, true ); ?> <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>
										type="checkbox" name="appmenu_settings[appmenu_labels]"
										id="appmenu_settings_labels" value="1">
									<?php esc_html_e( 'Show label text below tab icons', 'buddyboss-app' ); ?>
								</label>
							</div>
							<div class="bbapp-menu-setting-list menu-settings-input">
								<label for="menu-setting">
										<span class="bbapp-menu-setting-label">
											<?php esc_html_e( 'Tab Bar Visibility', 'buddyboss-app' ); ?></span>
										<select id="tab_bar_visibility"
												name="appmenu_settings[tab_bar_visibility]" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>>
										<option value="show_on_tab_bar_menu" <?php selected( $tab_bar_visibility, 'show_on_tab_bar_menu', true ); ?>>
											<?php esc_html_e( 'Show on Tab Bar Menu', 'buddyboss-app' ); ?>
										</option>
										<option value="show_on_all_screen" <?php selected( $tab_bar_visibility, 'show_on_all_screen', true ); ?> >
											<?php esc_html_e( 'Show on All Screens', 'buddyboss-app' ); ?>
										</option>
									</select>
								</label>
									<p id="bbapp_show_on_tab_bar_menu"
									class="description tab_bar_visibility <?php echo ! empty( $tab_bar_visibility ) && 'show_on_tab_bar_menu' === $tab_bar_visibility ? 'tab_bar_visibility_active' : 'tab_bar_visibility_inactive'; ?>">
									<?php esc_html_e( 'Tab Bar will only show on screens added to the Tab Bar menu', 'buddyboss-app' ); ?>
								</p>
									<p id="bbapp_show_on_all_screen"
									class="description tab_bar_visibility <?php echo ! empty( $tab_bar_visibility ) && 'show_on_all_screen' === $tab_bar_visibility ? 'tab_bar_visibility_active' : 'tab_bar_visibility_inactive'; ?>">
									<?php esc_html_e( 'Tab Bar will show on all screens', 'buddyboss-app' ); ?>
								</p>
							</div>

						</div>
						<input type="submit" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>class="button button-primary menu-save" value="<?php esc_attr_e( 'Save Settings', 'buddyboss-app' ); ?>" name="save_menu_setting" id="<?php echo esc_attr( 'save_appmenu_setting' ); ?>"/>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
