<?php
/**
 * Holds menus settings.
 *
 * @package BuddyBossApp\Admin\Menus
 */

$all_menus = $menu_manager->get_menus(
	array(
		'menu_type' => $menu_type_slug,
		'order_by'  => 'priority',
		'order'     => 'ASC',
		'count'     => false,
	)
);

/**
 * Do not render priority settings if there is no sortable menus more then 1.
 */
if ( count( $all_menus['menus'] ) < 4 ) {
	return false;
}

?>
<div id="bbapp-widgets">
	<div class="bbapp-widget-liquid">
		<div class="widgets-holder-wrap menu-priority bbapp-active">
			<div class="widgets-sortables">
				<div class="sidebar-name sidebar-name--menus" data-tab="menu-priority" data-add-to="Add to: <?php echo esc_html__( 'Menu Priority', 'buddyboss-app' ); ?>">
					<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
						<span class="screen-reader-text"><?php echo esc_html__( 'Menu Priority', 'buddyboss-app' ); ?></span>
						<span class="toggle-indicator" aria-hidden="true"></span>
					</button>
					<h3 class="bbapp-widget-title"><?php echo esc_html__( 'Menu Priority', 'buddyboss-app' ); ?><span class="spinner"></span></h3>
				</div>
				<div class="bbapp-widget-content sidebar-description">
					<p>
						<?php printf( '%s <strong>%s</strong> %s ', esc_html__( 'Order your', 'buddyboss-app' ), esc_html( $menu_type_label ), esc_html__( 'menus by priority to set which one your members should see if they have access to multiple menus.', 'buddyboss-app' ) ); ?>
					</p>
					<button id="bbapp-menu-priority" name="bbapp-menu-priority" class="button bbapp-button-menu-priority">
						<?php echo esc_attr__( 'Set Menu Priority', 'buddyboss-app' ); ?>
					</button>
				</div>
			</div>
		</div>
	</div>
</div>
<div id="bbapp-modal-box" class="supports-drag-drop bbapp-modal-box" style="display: none; position: relative;">
	<div tabindex="0" class="media-modal wp-core-ui">
		<button type="button" id="bbapp_modal_close" class="media-modal-close">
			<span class="media-modal-icon">
				<span class="screen-reader-text">
					<?php esc_html_e( 'Close', 'buddyboss-app' ); ?>
				</span>
			</span>
		</button>
		<div class="media-modal-content">
			<div class="bbapp-modal-body bbapp-modal-box__wrapper">
				<div class="wrap">
					<div class="bbapp-modal-box__header">
						<h3><?php esc_html_e( 'Set Menu Priority', 'buddyboss-app' ); ?></h3>
					</div>
					<form name="bbapp-set-menu-priority" id="bbapp-set-menu-priority" method="post">
						<div class="bbapp-modal-box__body">
							<?php wp_nonce_field( "bbapp_set_menu_priority{$menu_type_slug}_nonce", 'bbapp_set_menu_priority' ); ?>
							<input type="hidden" name="action" value="save-menu-priority"/>
							<input type="hidden" name="setting" value="<?php echo esc_attr( $menu_type_slug ); ?>"/>
							<input type="hidden" id="nav_menu_order" name="nav_menu_order" value=""/>
							<p>
								<?php printf( '%s <strong>%s</strong> %s', esc_html__( 'Drag and drop the menus and order your', 'buddyboss-app' ), esc_html( $menu_type_label ), esc_html__( 'menus from highest to lowest priority.', 'buddyboss-app' ) ); ?>
							</p>
							<div class="bbapp-menu-priority-items-box">
								<ul id="bbapp-menu-priority-items" class="ui-sortable">
									<?php
									if ( ! empty( $all_menus['menus'] ) ) {
										foreach ( $all_menus['menus'] as $key => $menu_priority ) {
											$is_disabled = false;
											if ( $menu_manager->is_default_menu_name( $menu_priority->menu_name ) ) {
												$is_disabled = true;
											}
											?>
											<li id="<?php echo esc_attr( $menu_priority->id ); ?>" class="bbapp-menu-priority-item <?php echo ( $is_disabled ) ? 'ui-state-disabled' : ''; ?>">
												<?php if ( ! $is_disabled ) { ?>
													<span class="menu-reorder"><i class="bb-icon-l bb-icon-bars"></i></span>
												<?php } ?>
												<h3 class="menu-title">
													<?php
													echo esc_html( $menu_priority->menu_name );
													if ( $is_disabled ) {
														echo '&nbsp;';
														echo esc_html( $menu_type_label );
													}
													?>
												</h3>
											</li>
											<?php
										}
									}
									?>
								</ul>
							</div>
						</div>
						<div class="bbapp-modal-box__footer bbapp-priority-item menu-item-submit">
							<input type="submit" id="menu-priority-saved" name="save_priority" class="button-primary" value="<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>">
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="media-modal-backdrop"></div>
</div>
