<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

// Get menu type from URL parameter or set to default.
$menu_type_slug  = isset( $_GET['setting'] ) ? sanitize_key( $_GET['setting'] ) : 'tabbar'; // phpcs:ignore
$menu_type_label = bbapp_get_menu_type_label( $menu_type_slug );
$redirect_args   = array(
	'page' => 'bbapp-menus',
	'lang' => isset( $_GET['lang'] ) ? sanitize_key( $_GET['lang'] ) : 'en', // phpcs:ignore
);

$redirect_url = add_query_arg(
	$redirect_args,
	bbapp_get_admin_url( 'admin.php' )
);
?>
<div class="manage-menus bbapp-manage-menus">
	<p>
		<?php
		printf(
		// translators: %s: Menu type label.
			esc_html__( 'No %s menu item found. Please create menu items.', 'buddyboss-app' ),
			esc_html( $menu_type_label )
		);
		?>
	</p>
	<a href="<?php echo esc_url( $redirect_url ); ?>" class="button button-primary">
		<?php esc_html_e( 'Go to Default Menu Page', 'buddyboss-app' ); ?>
	</a>
</div>
