<?php
/**
 * Holds menu HTML structure.
 *
 * @package BuddyBossApp\Admin\Menus
 */

use BuddyBossApp\Admin\Menus;
use BuddyBossApp\AppSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$uniq_id        = $menu_item_argument['id'];
$original       = $menu_item_argument['original'];
$index          = $menu_item_argument['index'];
$item_name_key  = 'appmenu-item[' . $uniq_id . ']';
$depth          = $menu_item_argument['depth'];
$item_slug      = $menu_item_argument['item_slug'];
$label          = $menu_item_argument['label'];
$item_type      = $menu_item_argument['item_type'];
$type_label     = $menu_item_argument['type_label'];
$menu_data      = $menu_item_argument['data'];
$menu_icon      = $menu_item_argument['icon'];
$deeplink_url   = $menu_item_argument['deeplink_url'];
$menu_type_slug = Menus::instance()->get_current_sub_tab();
$current_menu   = ( ! empty( $_REQUEST['current_menu'] ) ) ? sanitize_text_field( wp_unslash( $_REQUEST['current_menu'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Recommended
$license_type   = AppSettings::instance()->get_setting_value( 'app_license_type' );

$is_disable = false;

if ( true === $menu_item_argument['has_disable'] ) {
	$menu_class[] = 'bbapp-mark-red';
	$menu_class[] = 'disable';
	$is_disable   = true;
}

$menu_class[] = 'non_static_menu';

if ( 'more' === $item_slug ) {
	$menu_class[] = 'bbapp-more-menu';
}

if ( 'profile' === $item_slug && ( 'headerbar' === $menu_type_slug || 'headerbar' === $current_menu ) ) {
	$menu_class[] = 'bbapp-profile-menu';
	$menu_class[] = 'more_static_menu';
}

if ( ! empty( $item_type ) && 'headerbar' === $item_type ) {
	$menu_class[] = 'bbapp-headerbar-action';
}

if ( 'more' === $item_slug ) {
	$menu_class[] = 'more_static_menu';
}
?>

<li id="menu-item-<?php echo esc_attr( $index ); ?>"
	class="menu-item menu-item-depth-<?php echo esc_attr( $depth ); ?> menu-item-core pending menu-item-edit-inactive <?php echo esc_attr( implode( ' ', $menu_class ) ); ?>">
	<div class="menu-item-bar">
		<div class="menu-item-handle">
			<span class="item-title">
				<span class="menu-item-title">
					<?php echo esc_attr( $label ); ?>
					<?php
					if ( bbapp_is_lite_app() && in_array( $item_slug, bbapp_lite_app_license_locked_pages(), true ) ) {
						$bb_icon_args = array(
							'icon'  => 'bb-icon-lock-alt',
							'class' => 'menu-locked-icon',
						);
						echo bbapp_custom_tooltip( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							esc_html__( 'Requires Full Edition. Can be used in test app only.', 'buddyboss-app' ),
							'tooltip__smaller',
							true,
							$bb_icon_args
						);
					}
					?>
				</span>
			</span>
			<span class="item-controls">
				<span class="item-type"><?php echo esc_attr( $type_label ); ?></span>
				<a class="item-edit" id="edit-<?php echo esc_attr( $index ); ?>" href="#menu-item-settings-<?php echo esc_attr( $index ); ?>"
					aria-label="<?php echo esc_attr( $label ); ?>">
					<span class="screen-reader-text"><?php echo esc_attr( $label ); ?></span>
				</a>
			</span>
		</div>
	</div>

	<div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr( $index ); ?>">
		<input type="hidden" id="edit-menu-item-label-<?php echo esc_attr( $uniq_id ); ?>" class="widefat edit-menu-item-label menu-item-data-label"
				name="<?php echo esc_attr( $item_name_key ); ?>[label]" value="<?php echo esc_attr( $label ); ?>"/>
		<?php

		if ( ! empty( $menu_item_argument['item_type'] ) && 'headerbar' === $menu_item_argument['item_type'] ) {
			$action_menu_icons = ( ! empty( $menu_item_argument['icons'] ) ) ? $menu_item_argument['icons'] : array();

			if ( ! empty( $action_menu_icons ) ) {
				foreach ( $action_menu_icons as $key => $action_menu_icon ) {
					?>
			<div class="edit-menu-item-icon-container">
				<div class="edit-menu-item-icon">
					<label>
						<?php echo esc_html( $action_menu_icon['extra']['label'] ); ?>
					</label>
					<div class="bbapp_icon_picker bbapp_render_icon_<?php echo esc_attr( $action_menu_icon['extra']['uniq_id'] ); ?>"></div>
				</div>
				<script>
					window.bbappIconMenuData = <?php echo wp_json_encode( $action_menu_icon ); ?>;

					buddybossAppRenderIcon( "<?php echo esc_attr( $action_menu_icon['extra']['uniq_id'] ); ?>" );
				</script>
			</div>
					<?php
				}
			}
		} else {
			if ( ( in_array( $menu_type_slug, array( 'tabbar', 'more' ), true ) || in_array( $current_menu, array( 'tabbar', 'more' ), true ) ) ) {
				?>
			<p class="field-label description description-wide">
				<label for="edit-menu-item-label-<?php echo esc_attr( $index ); ?>">
					<?php esc_html_e( 'Label', 'buddyboss-app' ); ?><br>
					<input type="text" id="edit-menu-item-label-<?php echo esc_attr( $uniq_id ); ?>" class="widefat edit-menu-item-label menu-item-data-label"
							name="<?php echo esc_attr( $item_name_key ); ?>[label]"
						<?php function_exists( 'wp_readonly' ) ? wp_readonly( $is_disable, true ) : readonly( $is_disable, true ); ?> value="<?php echo esc_attr( $label ); ?>">
				</label>
			</p>
				<?php
			}
			?>
			<p class="field-css-classes description description-wide" style="display: none;">
				<label for="edit-menu-item-classes-<?php echo esc_attr( $index ); ?>">
					<?php esc_html_e( 'Make it Section', 'buddyboss-app' ); ?>&nbsp;
					<input class="edit-menu-item-data-on appmenu-item-section" type="checkbox" name="<?php echo esc_attr( $item_name_key ); ?>[section]" 
																												<?php
																												checked(
																													1,
																													$menu_section
																												);
																												?>
						value="1">
				</label>
			</p>

			<?php if ( 'custom' === $item_type || 'page' === $item_slug ) { ?>

			<p class="field-link description description-wide">
				<label for="edit-menu-item-link-<?php echo esc_attr( $index ); ?>">
					<?php esc_html_e( 'URL', 'buddyboss-app' ); ?><br>
					<input type="text" id="edit-menu-item-link-<?php echo esc_attr( $index ); ?>" class="widefat edit-menu-item-link menu-item-data-link form-required"
							name="<?php echo esc_attr( $item_name_key ); ?>[data][link]" placeholder="https://"
											<?php
											wp_readonly(
												1,
												$menu_data['is_readonly']
											);
											?>
						value="<?php echo esc_attr( $menu_data['link'] ); ?>">
				</label>
			</p>
				<?php
			}

			// Only more screen allow external browser feature.
			$menu_type = ( isset( $_POST['current_menu'] ) ) ? sanitize_text_field( wp_unslash( $_POST['current_menu'] ) ) : bbapp_get_menu_type(); // phpcs:ignore WordPress.Security.NonceVerification.Missing

			/**
			 * Disallow external link for provided filter.
			 *
			 * @param $disallow_screen array Group screen name.
			 *
			 * @since 1.7.0
			 */
			$screen_disallow_external_link = apply_filters( 'bbapp_menu_disallow_external_link', array() );
			if ( ! in_array( $item_type, $screen_disallow_external_link, true ) && 'app_page' !== $item_slug && 'more' === $menu_type ) {
				?>

			<p class="field-open-external description">
				<input type="checkbox" class="bbapp-custom-link-field" id="edit-menu-item-open-external-<?php echo esc_attr( $index ); ?>"
						name="<?php echo esc_attr( $item_name_key ); ?>[data][open_external]" <?php checked( $menu_data['external'], 'yes' ); ?> value="yes">
				<label for="edit-menu-item-open-external-<?php echo esc_attr( $index ); ?>">
					<span class="item-open-external-text">
						<?php esc_html_e( 'Always open in external browser', 'buddyboss-app' ); ?><br>
					</span>
					<span>
						<?php
						printf(
							'%1$s <a href="%2$s">%3$s</a> %4$s',
							esc_html__( 'When enabled, this link will always open in an external browser, regardless of your', 'buddyboss-app' ),
							esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-settings&setting=compatibility#app_settings_compatibility__link__header' ) ),
							esc_html__( 'Link Handling', 'buddyboss-app' ),
							esc_html__( 'preferences.', 'buddyboss-app' )
						);
						?>
					</span>
				</label>
			</p>
			<?php } ?>
			<?php if ( ! in_array( $item_type, array( 'section', 'custom' ), true ) ) { ?>

				<?php
				/**
				 * FIlters menu feature.
				 *
				 * @param object $menu_item Menu item.
				 * @param string $uniq_id   Unique id.
				 */
				do_action( 'bbapp_menu_feature', $menu_item, $uniq_id );
				?>

		<?php } ?>

			<?php if ( 'section' !== $item_type ) { ?>
			<div>
				<?php
				/**
				 * Custom Settings.
				 */
				do_action( 'bbapp_menu_metabox_render', $uniq_id, $menu_item, $item_slug );
				?>
			</div>
				<?php printf( '<b>%1$s:</b> %2$s', esc_html__( 'Original', 'buddyboss-app' ), esc_html( $original ) ); ?>

			<div class="edit-menu-item-icon-container">
				<div class="edit-menu-item-icon">
					<label><?php esc_html_e( 'Item Icon', 'buddyboss-app' ); ?></label>
					<?php
					if ( 'more' === $item_slug ) {
						$icon_type       = $menu_item_argument['icon_type'];
						$avatar_cls      = ( 'avatar' === $icon_type ) ? 'bbapp-hide' : '';
						$icon_picker_cls = ( 'icon' === $icon_type ) ? 'bbapp-hide' : '';
						$icon_text       = ( 'avatar' === $icon_type ) ? esc_html__( 'Show Icon', 'buddyboss-app' ) : esc_html__( 'Show User Avatar', 'buddyboss-app' );
						?>
						<div class="bbapp_icon_picker bbapp_render_icon_<?php echo esc_attr( $uniq_id ); ?> <?php echo esc_attr( $avatar_cls ); ?>"></div>
						<div class="bbapp-user-avatar <?php echo esc_attr( $icon_picker_cls ); ?>">
							<img alt="" src="<?php echo esc_url( get_avatar_url( get_current_user_id() ) ); ?>"/>
						</div>
						<div class="bbapp-change-more-icon-wrp">
							<a href="javascript:void(0)" class="bbapp-more-menu-icon"
								data-icon-type="<?php echo esc_attr( $icon_type ); ?>">
								<?php echo esc_html( $icon_text ); ?>
							</a>
						</div>
						<?php
					} elseif ( ( 'headerbar' === $menu_type_slug || 'headerbar' === $current_menu ) && 'profile' === $item_slug ) {
						?>
						<div class="bbapp_icon_picker bbapp-hide bbapp_render_icon_<?php echo esc_attr( $uniq_id ); ?>"></div>
						<div class="bbapp-user-avatar">
							<img alt="" src="<?php echo esc_url( get_avatar_url( get_current_user_id() ) ); ?>"/>
						</div>
						<?php
					} else {
						?>
						<div class="bbapp_icon_picker bbapp_render_icon_<?php echo esc_attr( $uniq_id ); ?>"></div>
						<?php
					}
					?>
				</div>
			</div>

				<?php
			}
			if ( ! $linked ) {
				$posts_obj = get_posts(
					array(
						'post_type'   => $item_slug,
						'numberposts' => - 1,
					)
				);
				?>
			<p><?php esc_attr_e( 'This menu item is connected to a missing item. Please select it below again.', 'buddyboss-app' ); ?></p>
			<p>
				<label for="edit-menu-item-search-<?php echo esc_attr( $index ); ?>"><?php esc_attr_e( 'Select New Item', 'buddyboss-app' ); ?></label>
				<select id="edit-menu-item-search-<?php echo esc_attr( $index ); ?>" name="<?php echo esc_attr( $item_name_key ); ?>[data][id]" class="widefat">
					<option value="0"><?php esc_attr_e( 'Select New', 'buddyboss-app' ); ?></option>
					<?php foreach ( $posts_obj as $m_post ) { ?>
						<option value="<?php echo esc_attr( $m_post->ID ); ?>">
							<?php echo esc_attr( $m_post->post_title ); ?>
						</option>
					<?php } ?>
				</select>
				<input class="menu-item-not-available" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[data][old-id]"
						value="<?php echo esc_attr( $menu_data['id'] ); ?>">
			</p>
		<?php } ?>


			<div class="menu-item-actions description-wide submitbox">
				<?php
				if ( ! in_array( $item_slug, array( 'more', 'section', 'custom' ), true ) ) {
					if ( ! empty( $deeplink_url ) ) {
						?>
						<p class="description deeplinking-box submitbox">
							<b><?php echo esc_html__( 'Deep Link:', 'buddyboss-app' ); ?></b><br/>
							<span>
							<label>
								<a id='bbapp_<?php echo esc_attr( $item_slug . '_' . $uniq_id ); ?>_url'><?php echo esc_url( $deeplink_url ); ?></a>
								<span class="bbapp-sub-tooltip">
									<a class="_copy" onclick="window.bbappCore.core.bbapp_copy_paste_url('bbapp_<?php echo esc_attr( $item_slug . '_' . $uniq_id ); ?>_url')">
										<span class="bbapp-tooltip-text" id="bbapp-span-tooltip-bbapp_<?php echo esc_attr( $item_slug . '_' . $uniq_id ); ?>_url"></span>
										<i class="bb-icon-bf bb-icon-clipboard"></i>
									</a>
								</span>
							</label>
							<br>
						</span>
							<?php
							echo esc_html__(
								"If this URL is clicked outside of the app (i.e. from a browser), it will redirect to your site's homepage.",
								'buddyboss-app'
							);
							?>
						</p>
						<?php
					}
				}
				?>
				<?php if ( 'more' !== $item_slug ) { ?>
					<a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr( $index ); ?>" href="#">
						<?php esc_html_e( 'Remove', 'buddyboss-app' ); ?>
					</a>
					<span class="meta-sep hide-if-no-js"> | </span>
					<a class="item-cancel submitcancel hide-if-no-js" id="cancel-<?php echo esc_attr( $index ); ?>" href="#">
						<?php esc_html_e( 'Cancel', 'buddyboss-app' ); ?>
					</a>
				<?php } ?>
			</div>

			<?php
			if ( bbapp_is_lite_app() && in_array( $item_slug, bbapp_lite_app_license_locked_pages(), true ) ) {
				require bbapp()->plugin_dir . 'views/app-full-access.php';
			}
			?>
			<script>
				window.bbappIconMenuData = <?php echo wp_json_encode( $menu_icon ); ?>;

				buddybossAppRenderIcon( '<?php echo esc_attr( $uniq_id ); ?>' );
			</script>
			<?php
		}
		?>

		<input class="menu-item-original" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[original]" value="<?php echo esc_attr( $original ); ?>">
		<input class="menu-item-id" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[id]" value="<?php echo esc_attr( $uniq_id ); ?>">
		<input class="menu-item-object" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[object]" value="<?php echo esc_attr( $item_slug ); ?>">
		<?php
		if ( 'more' === $item_slug ) {
			?>
			<input class="menu-item-icon-type" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[icon_type]" value="<?php echo esc_attr( $icon_type ); ?>">
			<?php
		}
		if ( $linked ) {
			?>
			<input class="menu-item-data-id" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[data][id]"
					value="<?php echo esc_attr( $menu_data['id'] ); ?>">
			<?php
		}
		if ( ! empty( $menu_item_argument['item_type'] ) && 'headerbar' === $menu_item_argument['item_type'] ) {
			?>
			<input class="menu-item-original" type="hidden"
					name="<?php echo esc_attr( $item_name_key ); ?>[label]"
					value="<?php echo esc_attr( $menu_item_argument['label'] ); ?>">
			<?php
		}
		?>
		<input class="menu-item-data-parent-id" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[data][parent]"
				value="<?php echo esc_attr( $menu_data['parent'] ); ?>">
		<input class="menu-item-data-type" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[type]" value="<?php echo esc_attr( $item_type ); ?>">
		<input class="menu-item-type" type="hidden" name="<?php echo esc_attr( $item_name_key ); ?>[item_type]" value="<?php echo esc_attr( $item_type ); ?>">
	</div><!-- .menu-item-settings-->
</li>
