<?php
/**
 * Holds menu list HTML.
 *
 * @package BuddyBossApp\Admin\Menus
 */

use BuddyBossApp\Admin\Menus\Menus;
use BuddyBossApp\AppLanguages;
use BuddyBossApp\Helpers\Custom_Multiselect_Dropdown;

wp_print_scripts( array( 'wp-util' ) );

$menu_items                = ! empty( $main_menu->items ) ? $main_menu->items : array();
$main_menu_selected_title  = isset( $main_menu->menu_name ) ? $main_menu->menu_name : __( 'Default', 'buddyboss-app' );
$is_logged_out_menu_exists = $menu_manager->get_logout_menu_id( $menu_type_slug );
$is_default_logged_out     = $menu_manager->is_default_logged_out( $nav_menu_selected_id, $menu_type_slug, $main_menu );
$is_disable_create_btn     = false;
$access_controls_groups    = array();

$headerbar_id       = $nav_menu_selected_id;
$more_menu_position = '';
if ( 'tabbar' === $menu_type_slug ) {
	$headerbar_id       = $menu_manager->get_headerbar_menu_from_tabbar_id( $main_menu );
	$more_menu_position = $menu_manager->get_more_menu_position( $headerbar_id );
}

// Check if we're in the create menu mode (either via $add_new_screen or when $nav_menu_selected_id is '0').
$is_create_mode = ( $add_new_screen || '0' === $nav_menu_selected_id );

if ( ! bbapp_is_active( 'access_controls' ) ) {
	if ( $is_create_mode ) {
		$is_default_menu = $menu_manager->is_default_menu( $nav_menu_selected_id, $menu_type_slug );

		if ( ! $is_default_menu ) {
			$is_disable_create_btn = true;
		}
	}
} else {
	$access_controls_groups = bb_access_controls_groups_list();

	if ( empty( $access_controls_groups['list_items'] ) ) {
		$is_default_menu = $menu_manager->is_default_menu( $nav_menu_selected_id, $menu_type_slug );

		if ( ! $is_default_menu && ! $is_default_logged_out ) {
			$is_disable_create_btn = true;
		}
	}
}
?>

<div class="appmenu-edit-wrapper">
	<!-- Edit menu -->
	<?php
	$app_languages    = AppLanguages::instance();
	$active_languages = $app_languages->get_active_languages();
	$active_languages = $menu_manager->get_active_languages_with_menu_items_count( $active_languages, $menu_type_slug, $nav_menu_selected_id );
	$number           = 0;

	$lang_url_args = array(
		'page'    => 'bbapp-menus',
		'action'  => 'edit',
		'setting' => $menu_type_slug,
	);

	$lang_url = add_query_arg(
		$lang_url_args,
		bbapp_get_admin_url( 'admin.php' )
	);
	?>
	<div class="menu-lang-wrapper">
		<ul class="subsubsub">
			<?php
			foreach ( $active_languages as $lang_code => $lang ) {
				printf(
					'<li class="sub-item %s"><a href="%s" %s>%s<span class="count">(%s)</span></a>%s</li>',
					esc_attr( $lang_code ),
					esc_url( $lang_url . '&lang=' . $lang_code ),
					$menu_manager->current_lang_code === $lang_code ? ' class="current" aria-current="page"' : '',
					esc_html( $lang['name'] ),
					esc_html( $lang['items_count'] ),
					$number < count( $active_languages ) - 1 ? ' |' : ''
				);
				++$number;
			}
			?>
		</ul>
	</div>
	<div class="menu-edit appmenu-edit">
		<form id="update-nav-appmenu" method="post" enctype="multipart/form-data">
			<?php wp_nonce_field( 'update-nav_appmenu', 'update-nav-appmenu-nonce' ); ?>
			<input type="hidden" name="action" value="<?php echo ( '0' === (string) $nav_menu_selected_id ) ? 'create' : 'update'; ?>"/>
			<input type="hidden" name="setting" value="<?php echo esc_attr( $menu_type_slug ); ?>"/>
			<input type="hidden" name="menu" value="<?php echo esc_attr( $nav_menu_selected_id ); ?>"/>
            <input type="hidden" name="lang" value="<?php echo esc_attr( $menu_manager->current_lang_code ); ?>"/>
			<div id="nav-menu-header">
				<div class="major-publishing-actions wp-clearfix">
					<label class="menu-name-label" for="menu-name">
						<strong><?php esc_html_e( 'Menu Name', 'buddyboss-app' ); ?></strong>
					</label>
					<?php
					if ( ! $is_default_logged_out ) {
						$main_menu_selected_title = ( '0' !== $nav_menu_selected_id ) ? $main_menu_selected_title : '';
						?>
						<div class="menu-name-wrap">
							<input name="menu-name" id="menu-name" type="text" data-old-val="<?php esc_attr_e( 'Logged-out', 'buddyboss-app' ); ?>"
									class="menu-name regular-text menu-item-textbox bb-validate-field-cmn"
									data-err-msg="<?php esc_attr_e( 'This field is required', 'buddyboss-app' ); ?>"
									value="<?php echo esc_attr( $main_menu_selected_title ); ?>" <?php wp_readonly( ( 'headerbar' === $menu_type_slug ) ); ?>/>
						</div>
						<span class="bbapp-logged-out-title hidden">
							<?php printf( '%1$s %2$s', esc_html__( 'Logged-out', 'buddyboss-app' ), esc_html( $menu_type_label ) ); ?>
						</span>
						<?php
					} else {
						?>
						<span class="default-label">
						<?php printf( '%s %s', esc_html( $main_menu_selected_title ), esc_html( $menu_type_label ) ); ?>
						</span>
						<input type="hidden" name="menu-name" value="<?php echo esc_attr( $main_menu_selected_title ); ?>"/>
						<?php
					}
					?>
					<div class="publishing-action">
						<div class="bbapp_loading menu-loader" style="display: none;"></div>
						<?php
						$bb_menu_button_type  = 'primary large menu-save';
						$bb_menu_button_type .= ( empty( $nav_menu_selected_id ) ) ? ' bb-create-menu' : ' bb-save-menu';
						submit_button(
							empty( $nav_menu_selected_id ) ? __( 'Create Menu', 'buddyboss-app' ) : __( 'Save Menu', 'buddyboss-app' ),
							$bb_menu_button_type,
							'save_menu',
							false,
							array( 'id' => 'save_menu_header' )
						);
						?>
					</div><!-- END .publishing-action -->
				</div><!-- END .major-publishing-actions -->
				<?php
				if ( '0' !== $nav_menu_selected_id ) {
					// Get all menus of the current type and login state.
					$login_state = ! empty( $main_menu->login_state ) ? $main_menu->login_state : 1;
					$menus_data  = $menu_manager->get_menus(
						array(
							'menu_type' => $menu_type_slug,
							'order_by'  => 'priority',
							'order'     => 'ASC',
						)
					);

					if ( ! empty( $menus_data['menus'] ) ) {
						$menus         = $menus_data['menus'];
						$current_menu  = null;
						$total_menus   = count( $menus );
						$menu_position = 0;

						// Sort menus by priority in ascending order (1, 2, 3...).
						usort(
							$menus,
							function ( $a, $b ) {
								return $a->priority - $b->priority;
							}
						);

						// Find the current menu to get its priority and position.
						foreach ( $menus as $position => $single_menu ) {
							if ( $single_menu->id === $nav_menu_selected_id ) {
								$current_menu  = $single_menu;
								$menu_position = $position + 1; // Position is 1-based.
								break;
							}
						}

						if ( $current_menu && isset( $current_menu->priority ) ) {
							$priority_value = (int) $current_menu->priority;
							?>
							<div class="bb-menu-priority-wrp">
								<?php
								/* translators: %1$s: menu position, %2$s: total menus */
								$txt = sprintf( __( 'Priority: %1$s of %2$s', 'buddyboss-app' ), $menu_position, $total_menus );
								echo '<span class="bb-menu-priority">' . esc_html( $txt ) . '</span>';
								?>
								<span></span>
							</div>
							<?php
						}
					}
				}
				?>
			</div><!-- END .nav-menu-header -->
			<div id="post-body">
				<div id="post-body-content" class="wp-clearfix">
					<?php if ( $is_create_mode ) { ?>
						<p class="post-body-plain" id="menu-name-desc">
							<?php esc_html_e( 'Give your menu a name, then click Create Menu.', 'buddyboss-app' ); ?>
						</p>
					<?php } else { ?>
						<div id="menu-instructions" class="post-body-plain">
							<?php
							if ( 'tabbar' === $menu_type_slug ) {
								printf(
									'<p>%1$s <strong><a href="%2$s" target="_blank">%3$s</a></strong> %4$s <strong>%5$s</strong> %6$s.</p>',
									esc_html__( 'Configure the', 'buddyboss-app' ),
									'https://developer.apple.com/design/human-interface-guidelines/ios/bars/tab-bars/',
									esc_html__( 'Tab Bar', 'buddyboss-app' ),
									esc_html__(
										'menu to be displayed at the bottom of your app. Drag each item into the order you prefer. Tab Bar can only display 4 tabs (plus a More Tab). Additional items should be added to the',
										'buddyboss-app'
									),
									esc_html__( 'More Screen', 'buddyboss-app' ),
									esc_html__( 'menu', 'buddyboss-app' )
								);
							} elseif ( 'headerbar' === $menu_type_slug ) {
								esc_html_e(
									'Configure the Header to be displayed at the top of your app. Drag each item into the order you prefer. Header can only display 3 buttons. Additional post/add button should be placed in a floating position if it enabled, Otherwise it will remain within the header.',
									'buddyboss-app'
								);
							} else {
								printf(
									'<p>%1$s <strong>%2$s</strong> %3$s</p>',
									esc_html__( 'Configure the', 'buddyboss-app' ),
									esc_html__( 'More Menu', 'buddyboss-app' ),
									esc_html__(
										'to be displayed when tapping on "More" in the Tab Bar. Drag each item into the order you prefer. Add "Sections" with indented sub-items to separate content by section headers.',
										'buddyboss-app'
									)
								);
							}
							?>
						</div>
						<script>
							function buddybossAppRenderIcon( uniqId = '' ) {
								/**
								 * Style Template
								 */
								if ( wp.template === null ) {
									return;
								}

								/**
								 * Icon Template
								 */
								const template = wp.template( 'buddyboss-app-render-icon' );
								const menuIcon = template( bbappIconMenuData );

								jQuery( '.bbapp_render_icon_' + uniqId ).html( menuIcon );
							}
						</script>
						<ul class="menu <?php echo esc_attr( $menu_type_slug ) . '_menu_edit'; ?>" id="appmenu-to-edit">
							<?php

							if ( ! empty( $menu_items ) ) {
								$menu_items_count = count( $menu_items );

								foreach ( $menu_items as $menu_index => $menu_item ) {
									// if ( false === \BuddyBossApp\Menu::instance()->filter_app_menu_by_dependency( $menu_item ) ) {
									// $menu_item['has_disable'] = true;
									// }

									Menus::instance()->render_appmenu_page( $menu_item, $menu_index );

									if ( 'more' === $menu_type_slug ) {
										if ( ! empty( $menu_item['section'] ) && is_array( $menu_item['section'] ) ) {
											foreach ( $menu_item['section'] as $section_index => $section_item ) {
												$menu_items_count = ++$menu_items_count;

												// if ( false === \BuddyBossApp\Menu::instance()->filter_app_menu_by_dependency( $section_item ) ) {
												// $section_item['has_disable'] = true;
												// }

												Menus::instance()->render_appmenu_page( $section_item, $menu_items_count, 1 );
											}
										}
									}
								}
							}
							?>
						</ul>
						<?php
					}

					if ( ! $is_default_logged_out && 'headerbar' !== $menu_type_slug ) {
						$login_state = ! empty( $main_menu->login_state ) ? $main_menu->login_state : '';

						?>
						<div class="menu-settings">
							<h3><?php esc_html_e( 'Menu Rules', 'buddyboss-app' ); ?></h3>
							<fieldset class="menu-settings-group auto-add-pages">
								<legend class="menu-settings-group-name howto">
									<?php esc_html_e( 'Login Status', 'buddyboss-app' ); ?>
								</legend>
								<div class="menu-settings-input checkbox-input">
									<div class="menu-settings-input-option">
										<input type="radio" class="bbapp-login-status" id="logged-in-members" name="login_status" value="1" <?php checked( $login_state, '1' ); ?>/>
										<label for="logged-in-members">
											<?php esc_html_e( 'Logged-in Members', 'buddyboss-app' ); ?>
										</label>
									</div>
									<div class="menu-settings-input-option">
										<input type="radio" class="bbapp-login-status" id="logged-out-members" name="login_status" value="0"
											<?php
											checked(
												$login_state,
												'0'
											);
											?>
											<?php disabled( ! empty( $is_logged_out_menu_exists ) ); ?>/>
										<label for="logged-out-members">
											<?php
											esc_html_e( 'Logged-out Members', 'buddyboss-app' );

											if ( $is_logged_out_menu_exists ) {
												$logged_out_menu_id = $menu_manager->get_logout_menu_id( $menu_type_slug );
												$menu_name          = $menu_manager->get_menu_name_by_menu_id( $logged_out_menu_id );
												$nav_url            = add_query_arg(
													array(
														'page'    => 'bbapp-menus',
														'action'  => 'edit',
														'setting' => $menu_type_slug,
														'menu'    => $logged_out_menu_id,
														'lang'    => $menu_manager->current_lang_code, // phpcs:ignore
													),
													admin_url( 'admin.php' )
												);
												printf(
													' %1$s <a href="%2$s" target="_blank">%3$s</a>',
													esc_html__( '- Assigned to', 'buddyboss-app' ),
													esc_url( $nav_url ),
													esc_html( $menu_name )
												);
											}
											?>
										</label>
									</div>
								</div>
							</fieldset>
							<fieldset class="bb-menu-access-groups menu-settings-group menu-theme-locations">
								<legend class="menu-settings-group-name howto">
									<?php esc_html_e( 'Access Group', 'buddyboss-app' ); ?>
								</legend>
								<div class="menu-settings-dropdown select-dropdown">
									<?php
									$access_group_link = bbapp_get_admin_url(
										add_query_arg(
											array(
												'page'    => 'bbapp-access-controls',
												'setting' => 'access-groups',
											),
											'admin.php'
										)
									);
									if ( bbapp_is_active( 'access_controls' ) ) {
										if ( ! empty( $access_controls_groups['list_items'] ) ) {
											Custom_Multiselect_Dropdown::instance()->render(
												'access_groups',
												array(
													'list_items' => $access_controls_groups['list_items'],
													'selected_items' => ! empty( $main_menu->access_groups ) ? $main_menu->access_groups : array(),
													'disabled_items' => $access_controls_groups['disabled_items'],
													'add_button_label' => __( 'Add Group', 'buddyboss-app' ),
													'validation_error_message' => sprintf(
														'%1$s <a href="%2$s" target="blank">%3$s</a>.',
														esc_html__( 'You must select at least one', 'buddyboss-app' ),
														esc_url( $access_group_link ),
														esc_html__( 'access group', 'buddyboss-app' )
													),
													'disable' => false,
													'option_disable' => false,
													'placeholder' => __( '-- Select Access Group --', 'buddyboss-app' ),
													'type' => 'select2',
													'class' => 'bbapp-menu-access-groups bb-validate-field-cmn bbapp-select2-cmn-wrp',
												),
												array(
													'menu_type' => $menu_type_slug,
													'menu_id' => $nav_menu_selected_id,
													'lang'    => $menu_manager->current_lang_code, // phpcs:ignore
													'nonce' => wp_create_nonce( 'bbapp-get-dropdown' ),
													'ajax' => false,
												)
											);
										} else {
											printf(
												'<div class="bbapp-notice-box bbapp-notice-box--warning">%1$s <strong><a href="%2$s" target="_blank">%3$s</a></strong> %4$s</div>',
												esc_html__( 'Create an', 'buddyboss-app' ),
												esc_url( $access_group_link ),
												esc_html__( 'access group', 'buddyboss-app' ),
												esc_html__( 'to limit this menu to specific members.', 'buddyboss-app' )
											);
										}
									} else {
										printf(
											'<div class="bbapp-notice-box bbapp-notice-box--warning">%1$s <strong><a href="%2$s" target="_blank">%3$s</a></strong> %4$s</div>',
											esc_html__( 'Enable', 'buddyboss-app' ),
											esc_url( bb_access_controls_enable_link() ),
											esc_html__( 'App Access Controls', 'buddyboss-app' ),
											esc_html__( 'to limit menus to specific logged-in members.', 'buddyboss-app' )
										);
									}

									printf(
										'<div class="bbapp-description description hidden">%1$s <a href="%2$s" target="_blank">%3$s</a>, %4$s</div>',
										esc_html__( 'If a member is in multiple', 'buddyboss-app' ),
										esc_url( $access_group_link ),
										esc_html__( 'access groups', 'buddyboss-app' ),
										esc_html__( 'the menu for the group with the highest priority will be used.', 'buddyboss-app' )
									);
									?>
								</div>
							</fieldset>
						</div>
					<?php } ?>
				</div><!-- /#post-body-content -->
			</div><!-- /#post-body -->
			<div id="nav-menu-footer">
				<div class="major-publishing-actions wp-clearfix">
					<?php
					$default_menu_id = $menu_manager->get_default_menu_id( $menu_type_slug );
					if ( '0' !== $nav_menu_selected_id && $default_menu_id !== $nav_menu_selected_id ) {
						?>
						<div class="bbapp-nav-menu-delete">
							<?php
							$delete_url = wp_nonce_url(
								add_query_arg(
									array(
										'page'    => 'bbapp-menus',
										'action'  => 'delete',
										'setting' => $menu_type_slug,
										'menu'    => $nav_menu_selected_id,
									),
									admin_url( 'admin.php' )
								),
								'delete-nav_menu-' . $nav_menu_selected_id,
								'delete_nav'
							);

							if ( 'headerbar' !== $menu_type_slug ) {
								?>
								<a class="delete-link" onclick="return showNotice.warn();" id="delete-nav" href="<?php echo esc_url( $delete_url ); ?>">
									<?php echo esc_html__( 'Delete Menu', 'buddyboss-app' ); ?>
								</a>
								<?php
							}
							?>
						</div>
					<?php } elseif ( '0' === $nav_menu_selected_id ) { ?>
						<div class="bbapp-nav-menu-cancel">
							<?php
							$cancel_url = add_query_arg(
								array(
									'page'    => 'bbapp-menus',
									'setting' => $menu_type_slug,
								),
								admin_url( 'admin.php' )
							);
							?>
							<a class="cancel-link" id="cancel-nav" href="<?php echo esc_url( $cancel_url ); ?>">
								<?php echo esc_html__( 'Cancel', 'buddyboss-app' ); ?>
							</a>
						</div>
					<?php } ?>
					<div class="publishing-action">
						<div class="publishing-action">
							<div class="bbapp_loading menu-loader" style="display: none;"></div>
							<?php
							$other_attributes = array(
								'id' => 'save_menu_footer',
							);
							if ( $is_disable_create_btn ) {
								$other_attributes['disabled'] = true;
							}
							$bb_menu_button_type  = 'primary large menu-save';
							$bb_menu_button_type .= ( empty( $nav_menu_selected_id ) ) ? ' bb-create-menu' : ' bb-save-menu';
							submit_button(
								empty( $nav_menu_selected_id ) ? __( 'Create Menu', 'buddyboss-app' ) : __( 'Save Menu', 'buddyboss-app' ),
								$bb_menu_button_type,
								'save_menu',
								false,
								$other_attributes
							);
							?>
						</div><!-- END .publishing-action -->
					</div><!-- END .major-publishing-actions -->
				</div><!-- /#nav-menu-footer -->
			</div><!-- /.menu-edit -->
		</form>
	</div>
</div>

<script>
	jQuery( document ).ready( function () {
		let isGroupMenuAlreadyAssigned = false;

		// Run the menu access control select.
		jQuery( document ).bind( 'bbapp_dropdown_after_clone', function () {
			jQuery( '.bbapp-menu-access-groups' ).last().val( [ '0' ] ).trigger( 'change' );
		} );

		// Run the menu access control select.
		jQuery( document ).bind( 'bbapp_dropdown_after_remove_clone', function () {
			jQuery( '#save_menu_footer' ).prop( 'disabled', false );
		} );

		//On change menu access group dropdown check the group exists or not.
		jQuery( document ).on( 'change', '.bbapp-menu-access-groups', function () {
			const checkedVal = jQuery( '.bbapp-login-status:checked' ).val();

			if ( '0' === checkedVal ) {
				return true;
			}

			const curObj = jQuery( this );

			if ( curObj.val() && curObj.hasClass( 'bbapp-has-err' ) ) {
				curObj.parent().find( '.bbapp-field-err-cmn' ).remove();
				curObj.removeClass( 'bbapp-has-err' );
			}

			bbAccessControlToggleLoader( curObj, true );

			const name = jQuery( this ).attr( 'name' ).replace( '[]', '' );
			const extras = jQuery.parseJSON( jQuery( this ).attr( 'data-extras' ) );
			extras.value = curObj.val();

			jQuery.ajax( {
				url: bbappAjax.ajaxurl,
				type: 'POST',
				data: {
					action: 'bbapp_dropdown_result',
					term: '',
					slug: name,
					extras,
				},
				beforeSend() {
					jQuery( '#save_menu_footer' ).prop( 'disabled', true );
				},
				success( response ) {
					if ( true === response.success ) {
						if ( '' === response.data.html ) {
							jQuery( '.bbapp-description' ).addClass( 'hidden' );
							jQuery( '#save_menu_footer' ).prop( 'disabled', false );
						} else {
							isGroupMenuAlreadyAssigned = true;
							curObj.addClass( 'bbapp-has-err' );
							jQuery( '.bbapp-description' ).removeClass( 'hidden' );
							jQuery( '#save_menu_footer' ).prop( 'disabled', true );
							curObj.after( '<div class="bbapp-field-err-cmn bbapp-field-err">' + response.data.html + '</div>' );
						}
					} else {
						jQuery( '.bbapp-description' ).addClass( 'hidden' );
						curObj.removeClass( 'bbapp-has-err' );

						// eslint-disable-next-line no-alert
						alert( response.data.message );
					}

					bbAccessControlToggleLoader( curObj, false );
				},
			} );
		} );

		/**
		 * Function to use loader for hide and show loader.
		 *
		 * @param {string}  selector - selector to show loader.
		 * @param {boolean} disable  - true to disable and false to enable.
		 */
		function bbAccessControlToggleLoader( selector, disable = true ) {
			selector.prop( 'disabled', disable );

			const loader = selector.parent().find( '.bbapp_loading' );

			if ( true === disable ) {
				loader.show();
			} else {
				loader.hide();
			}
		}

		// On submit check the validation are correct or not.
		jQuery( '#update-nav-appmenu' ).submit( function () {
			const checkedVal = jQuery( '.bbapp-login-status:checked' ).val();

			if ( '0' === checkedVal ) {
				bbAccessControlToggleLoader( jQuery( '#save_menu_footer.bb-create-menu' ), true );

				// Disable all save menu buttons to prevent multiple submissions
				disableSaveButtons();

				return true;
			}

			jQuery( '.bbapp-menu-access-groups' ).addClass( 'bb-validate-field-cmn' );
			jQuery( '.bbapp-field-err-cmn' ).remove();

			const form = jQuery( this );
			let validate = true;
			const selectCmn = form.find( '.bb-validate-field-cmn' );
			const selectCmnIds = jQuery( selectCmn ).map( function () {
				return jQuery( this ).attr( 'id' );
			} );

			jQuery( selectCmnIds ).each( function ( index, value ) {
				const selectEl = jQuery( '#' + value );
				const selectVal = selectEl.val();

				if ( 'undefined' === typeof selectVal || '' === selectVal || 0 === parseInt( selectVal ) ) {
					validate = false;
					selectEl.addClass( 'bbapp-has-err' );
					jQuery( '.bbapp-description' ).removeClass( 'hidden' );

					if ( selectEl.hasClass( 'bbapp-select2-cmn-wrp' ) ) {
						selectEl.parent().append( '<p class="bbapp-field-err-cmn bbapp-field-err bbapp-error-msg">' + selectEl.attr( 'data-err-msg' ) + '</p>' );
					} else {
						selectEl.after( '<div class="bbapp-field-err-cmn bbapp-field-err">' + selectEl.attr( 'data-err-msg' ) + '</div>' );
					}
				} else if ( selectEl.hasClass( 'bbapp-has-err' ) ) {
					jQuery( '.bbapp-description' ).addClass( 'hidden' );
					selectEl.removeClass( 'bbapp-has-err' );
				}
			} );

			if ( false === validate ) {
				return false;
			}

			// Disable all save menu buttons to prevent multiple submissions
			disableSaveButtons();

			bbAccessControlToggleLoader( jQuery( '#save_menu_footer.bb-create-menu' ), true );
		} );

		// Function to disable all save menu buttons
		function disableSaveButtons() {
			// Find all save menu buttons
			var $saveButtons = jQuery('.bb-save-menu, .bb-create-menu');

			// Disable all buttons to prevent multiple submissions
			$saveButtons.each(function() {
				var $button = jQuery(this);
				$button.addClass('disabled').prop('disabled', true);
				$button.val($button.hasClass('bb-create-menu') ? 'Creating...' : 'Saving...');
			});

			// Show the loader if it exists
			jQuery('.bbapp_loading.menu-loader').show();
		}

		const loginStatus = jQuery( '.bbapp-login-status' );

		if ( loginStatus.length ) {
			let checkedVal = jQuery( '.bbapp-login-status:checked' ).val();

			if ( 'undefined' === typeof checkedVal ) {
				jQuery( '#logged-in-members' ).prop( 'checked', true );
				checkedVal = jQuery( '.bbapp-login-status:checked' ).val();
			}

			const isDisabled = jQuery( '#logged-out-members' ).prop( 'disabled' );

			setLoggedOutRoles( checkedVal );

			if ( true !== isDisabled ) {
				loginStatus.change( function ( e ) {
					e.preventDefault();

					const currentVal = jQuery( this ).val();

					setLoggedOutRoles( currentVal, true );
				} );
			}

			function setLoggedOutRoles( checkedItemVal, onChange = false ) {
				const menuName = jQuery( '#menu-name' );
				const oldVal = menuName.val();
				const val = menuName.attr( 'data-old-val' );

				if ( '0' === checkedItemVal ) {
					jQuery( '.bb-menu-access-groups' ).hide();

					jQuery( '.bbapp-menu-access-groups' ).each( function ( i, obj ) {
						if ( !jQuery( obj ).is( '[disabled=disabled]' ) ) {
							jQuery( obj ).val( '0' ).trigger( 'change' ).prop( 'disabled', true ); // set default value 0 position.
						}
					} );

					jQuery( '.bb-add-dropdown' ).prop( 'disabled', true );
					jQuery( '.bbapp-logged-out-title' ).show();
					menuName.attr( 'data-old-val', oldVal ).val( val ).hide();
					jQuery( '.bbapp-field-err-cmn' ).remove();
					jQuery( '.bbapp-description' ).addClass( 'hidden' );

					<?php if ( $is_disable_create_btn ) { ?>
					jQuery( '#save_menu_footer' ).prop( 'disabled', false );
					<?php } ?>

					if ( true === isGroupMenuAlreadyAssigned ) {
						jQuery( '#save_menu_footer' ).prop( 'disabled', false );
					}
				} else {
					jQuery( '.bb-menu-access-groups' ).show();

					jQuery( '.bbapp-menu-access-groups' ).each( function ( i, obj ) {
						if ( !jQuery( obj ).is( '[disabled=disabled]' ) ) {
							jQuery( obj ).prop( 'disabled', false );
						}
					} );

					jQuery( '.bb-add-dropdown' ).prop( 'disabled', false );
					jQuery( '.bbapp-logged-out-title' ).hide();
					menuName.show();

					if ( true === onChange ) {
						menuName.val( val ).attr( 'data-old-val', oldVal );
					}

					<?php if ( $is_disable_create_btn ) { ?>
					jQuery( '#save_menu_footer' ).prop( 'disabled', true );
					<?php } ?>
				}
			}
		}
	} );
</script>
