<?php
/**
 * Holds menu markup.
 *
 * @package BuddyBossApp\Admin\Menus
 */

use BuddyBossApp\AppSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

global $nav_menu_selected_id;
$tab_name = $screen_group . '-tab';

?>
<div id="posttype-<?php echo esc_attr( $screen_group ); ?>-app-menu" class="posttypediv div-<?php echo esc_attr( $screen_group ); ?>-app-menu">

	<?php if ( isset( $menu_desc ) && ! empty( $menu_desc ) ) { ?>
		<p><?php echo esc_html( $menu_desc ); ?></p>
	<?php } ?>

	<div id="tabs-panel-posttype-<?php echo esc_attr( $screen_group ); ?>-app-menu-most-recent" class="tabs-panel tabs-panel-active" <?php echo isset( $is_hide ) && true === $is_hide ? 'style="display: none;"' : ''; ?>>
		<ul id="pagechecklist-most-recent" class="categorychecklist form-no-clear">
			<?php
			switch ( $screen_group ) {
				case 'core':
				case 'bb_logged_in':
				case 'app_settings':
					$k                      = 0;
					$menu_type              = bbapp_get_menu_type();
					$logged_out_menu_id     = \BuddyBossApp\Menus\MenuManager::instance()->get_logout_menu_id( $menu_type );
					$menu_type_slug         = \BuddyBossApp\Admin\Menus::instance()->get_current_sub_tab();
					$default_menu_id        = \BuddyBossApp\Menus\MenuManager::instance()->get_default_menu_id( $menu_type );
					$bbapp_menu_selected_id = isset( $_REQUEST['menu'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['menu'] ) ) : $default_menu_id; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
					$license_type           = AppSettings::instance()->get_setting_value( 'app_license_type' );

					if ( ! empty( $bbapp_menus ) ) {
						foreach ( $bbapp_menus as $key => $bbapp_menu ) {
							if ( isset( $bbapp_menu['logged_in'] ) && $bbapp_menu['logged_in'] && $logged_out_menu_id === $bbapp_menu_selected_id ) {
								continue;
							}
							$index              = $k + 1;
							$menu_item          = "menu-item[-{$index}]";
							$menu_deeplink_path = ( $bbapp_menu['slug'] !== $deeplink_base ) ? $deeplink_base . '/' . $bbapp_menu['slug'] : $bbapp_menu['slug'];
							?>
							<li>
								<label class="menu-item-title">
									<input type="checkbox"
											class="menu-item-checkbox" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>
											name="<?php echo esc_attr( $menu_item ); ?>[menu-item-object-id]"
											value="<?php echo esc_attr( $bbapp_menu['object'] ); ?>">
									<?php echo esc_html( $bbapp_menu['label'] ); ?>
									<?php
									if ( bbapp_is_lite_app() && in_array( $bbapp_menu['slug'], bbapp_lite_app_license_locked_pages(), true ) ) {
										$bb_icon_args = array(
											'icon'  => 'bb-icon-lock-alt',
											'class' => 'menu-locked-icon',
										);

										echo bbapp_custom_tooltip( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
											esc_html__( 'Requires Full Edition. Can be used in test app only.', 'buddyboss-app' ),
											'tooltip__smaller',
											true,
											$bb_icon_args
										);
									}
									?>
								</label>
								<input type="hidden" class="menu-item-object" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-object]" value="<?php echo esc_attr( $bbapp_menu['data']['id'] ); ?>">
								<input type="hidden" class="menu-item-type" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-type]" value="<?php echo esc_attr( $screen_group ); ?>">
								<input type="hidden" class="menu-item-title" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-title]" value="<?php echo esc_attr( $bbapp_menu['label'] ); ?>">
								<input type="hidden" class="menu-item-deeplink-path" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-deeplink-path]" value="<?php echo esc_attr( $menu_deeplink_path ); ?>">
							</li>
							<?php
							++$k;
						}
					}
					break;
				case 'section':
					?>
					<li>
						<label class="menu-item-title">
							<input type="checkbox" class="menu-item-checkbox" checked="checked" name="menu-item[-1][menu-item-object-id]" value="section">
							<?php esc_html_e( 'Section', 'buddyboss-app' ); ?>
						</label>
						<input type="hidden" class="menu-item-object" name="menu-item[-1][menu-item-object]" value="section">
						<input type="hidden" class="menu-item-type" name="menu-item[-1][menu-item-type]" value="<?php echo esc_attr( $screen_group ); ?>">
						<input type="hidden" class="menu-item-title" name="menu-item[-1][menu-item-title]" value="<?php esc_attr_e( 'Section', 'buddyboss-app' ); ?>">
					</li>
					<?php
					break;
				default:
					$k                      = 0;
					$menu_type              = bbapp_get_menu_type();
					$logged_out_menu_id     = \BuddyBossApp\Menus\MenuManager::instance()->get_logout_menu_id( $menu_type );
					$menu_type_slug         = \BuddyBossApp\Admin\Menus::instance()->get_current_sub_tab();
					$default_menu_id        = \BuddyBossApp\Menus\MenuManager::instance()->get_default_menu_id( $menu_type );
					$bbapp_menu_selected_id = isset( $_REQUEST['menu'] ) ? wp_unslash( $_REQUEST['menu'] ) : $default_menu_id; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

					if ( ! empty( $bbapp_menus ) ) {
						foreach ( $bbapp_menus as $key => $bbapp_menu ) {

							if ( isset( $bbapp_menu['logged_in'] ) && $bbapp_menu['logged_in'] && $logged_out_menu_id === $bbapp_menu_selected_id ) {
								continue;
							}
							$index              = $k + 1;
							$menu_item          = "menu-item[-{$index}]";
							$menu_deeplink_path = ( $bbapp_menu['slug'] !== $deeplink_base ) ? $deeplink_base . '/' . $bbapp_menu['slug'] : $bbapp_menu['slug'];
							?>
							<li>
								<label class="menu-item-title">
									<input type="checkbox" class="menu-item-checkbox" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> name="<?php echo esc_attr( $menu_item ); ?>[menu-item-object-id]" value="<?php echo esc_attr( $bbapp_menu['object'] ); ?>">
									<?php echo esc_html( $bbapp_menu['label'] ); ?>
								</label>
								<input type="hidden" class="menu-item-object" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-object]" value="<?php echo esc_attr( $bbapp_menu['data']['id'] ); ?>">
								<input type="hidden" class="menu-item-type" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-type]" value="<?php echo esc_attr( $screen_group ); ?>">
								<input type="hidden" class="menu-item-title" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-title]" value="<?php echo esc_attr( $bbapp_menu['label'] ); ?>">
								<input type="hidden" class="menu-item-deeplink-path" name="<?php echo esc_attr( $menu_item ); ?>[menu-item-deeplink-path]" value="<?php echo esc_attr( $menu_deeplink_path ); ?>">
							</li>
							<?php
							++$k;
						}
					}
					break;

			}
			?>
		</ul>
	</div><!-- /.tabs-panel -->

	<p class="button-controls wp-clearfix" data-items-type="posttype-<?php echo esc_attr( $screen_group ); ?>-app-menu">
		<?php if ( 'section' !== $screen_group ) { ?>
			<span class="list-controls hide-if-no-js">
				<input type="checkbox" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> id="<?php echo esc_attr( $tab_name ); ?>" class="select-all"/>
				<label for="<?php echo esc_attr( $tab_name ); ?>"><?php esc_html_e( 'Select All', 'buddyboss-app' ); ?></label>
			</span>
		<?php } ?>
		<span class="add-to-menu">
			<input type="submit" class="button submit-add-to-menu right" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> value="<?php echo esc_attr__( 'Add to Menu', 'buddyboss-app' ); ?>" name="add-<?php echo esc_attr( $screen_group ); ?>-app-menu-item" id="submit-posttype-<?php echo esc_attr( $screen_group ); ?>-app-menu">
			<span class="spinner"></span>
		</span>
	</p>
</div>
