<?php
/**
 * Holds menu HTML structure.
 *
 * @package BuddyBossApp\Admin\Menus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$main_menus_result = $menu_manager->get_menus(
	array(
		'menu_type' => $menu_type_slug,
		'count'     => true,
	)
);
$main_menus        = $main_menus_result['menus'];
$menu_count        = $main_menus_result['count'];
?>

<div class="manage-menus bbapp-manage-menus">
	<?php if ( $menu_count < 2 && 'headerbar' !== $menu_type_slug ) { ?>
		<span class="first-menu-message">
			<?php
			printf(
			/* translators: %s: URL to create a new menu. */
				'%1$s <strong>%2$s</strong> %3$s <a href="%4$s">%5$s</a>',
				esc_html__( 'To show a different', 'buddyboss-app' ),
				esc_html( $menu_type_label ),
				esc_html__( 'to specific groups of members,', 'buddyboss-app' ),
				esc_url(
					add_query_arg(
						array(
							'page'    => 'bbapp-menus',
							'action'  => 'create',
							'setting' => $menu_type_slug,
							'lang'    => $menu_manager->current_lang_code, // phpcs:ignore
						),
						admin_url( 'admin.php' )
					)
				),
				esc_html__( 'create a new menu', 'buddyboss-app' )
			);
			?>
		</span><!-- /first-menu-message -->
	<?php } else { ?>
		<form method="get" action="<?php echo esc_url( admin_url( 'admin.php' ) ); ?>">
			<input type="hidden" name="action" value="edit"/>
			<input type="hidden" name="page" value="bbapp-menus"/>
			<?php
			if ( ! empty( $_GET['lang'] ) ) { // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.NonceVerification.Recommended
				printf( '<input type="hidden" name="lang" value="%s"/>', esc_attr( wp_unslash( $_GET['lang'] ) ) ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.NonceVerification.Recommended
			}
			?>
			<input type="hidden" name="setting" value="<?php echo esc_attr( $menu_type_slug ); ?>"/>
			<label for="select-menu-to-edit" class="selected-menu"><?php esc_html_e( 'Select a menu to edit:', 'buddyboss-app' ); ?></label>
			<select name="menu" id="select-menu-to-edit">
				<?php
				if ( $add_new_screen ) {
					?>
					<option value="default-<?php echo esc_attr( $menu_type_slug ); ?>" selected="selected">
						<?php esc_html_e( '&mdash; Select &mdash;', 'buddyboss-app' ); ?>
					</option>
					<?php
				}

				foreach ( $main_menus as $key => $main_menu_item ) {
					printf(
						"<option value='%s' %s>%s</option>",
						esc_attr( $main_menu_item->id ),
						selected( $main_menu_item->id, $nav_menu_selected_id ),
						esc_html( $main_menu_item->menu_name )
					);
				}
				?>
			</select>
			<span class="submit-btn"><input type="submit" class="button" value="<?php esc_attr_e( 'Select', 'buddyboss-app' ); ?>"></span>
			<?php
			$is_hide = ( ( ! bbapp_is_active( 'access_controls' ) && $menu_manager->get_logout_menu_id( $menu_type_slug ) ) || 'headerbar' === $menu_type_slug );
			if ( false === $is_hide ) {
				?>
				<span class="add-new-menu-action">
				<?php
				/* translators: %s: URL to create a new menu. */
				printf(
					'%1$s <a href="%2$s">%3$s</a>',
					esc_html__( 'or', 'buddyboss-app' ),
					esc_url(
						add_query_arg(
							array(
								'page'    => 'bbapp-menus',
								'action'  => 'create',
								'setting' => $menu_type_slug,
								'lang'    => $menu_manager->current_lang_code, // phpcs:ignore
							),
							admin_url( 'admin.php' )
						)
					),
					esc_html__( 'create a new menu', 'buddyboss-app' )
				);
				?>
				<span class="screen-reader-text">
					<?php esc_html_e( 'Click the Save Menu button to save your changes.', 'buddyboss-app' ); ?>
				</span>
			</span><!-- /add-new-menu-action -->
			<?php } ?>
		</form>
	<?php } ?>
	<?php
	if ( 'tabbar' === $menu_type_slug ) {
		$headerbar_menu_id = $menu_manager->get_headerbar_menu_from_tabbar_id( $main_menu );

		if ( $headerbar_menu_id ) {
			$headerbar_url = add_query_arg(
				array(
					'page'    => 'bbapp-menus',
					'action'  => 'edit',
					'setting' => 'headerbar',
					'menu'    => $headerbar_menu_id,
					'lang'    => $menu_manager->current_lang_code, // phpcs:ignore
				),
				bbapp_get_admin_url( 'admin.php' )
			);
			printf(
				'<span class="headebar-link-span">%1$s <a href="%2$s">%3$s</a></span>',
				esc_html__( 'You can manage headerbar from here:', 'buddyboss-app' ),
				esc_url( $headerbar_url ),
				esc_html__( 'Click here', 'buddyboss-app' )
			);
		}
	}
	?>
</div><!-- /manage-menus -->

<script>
	jQuery( document ).ready( function ( $ ) {
		$( '#post-body-content' ).bind( 'DOMSubtreeModified', function () {
			const self = $( this ),
				more = $( 'input[name="setting"]' );

			if ( !more.length ) {
				return;
			}
			if ( 'more' !== more.val() ) {
				return;
			}

			const menus = self.find( 'input[value="custom"], input[value="page"]' );

			$.each( menus, function ( index, item ) {
				const itemWrap = $( item ).closest( '.menu-item-settings' ),
					itemId = itemWrap.find( '.menu-item-id' ).val(),
					checked = itemWrap.find( '.bbapp-custom-link-field' ).is( ':checked' ),
					preview = $( 'a[data-id="' + itemId + '"]' ),
					prevWarp = preview.closest( '.bbapp-more-section' );

				if ( checked ) {
					prevWarp.find( '.bbapp-external-link-svg' ).show();
				}
			} );
		} );

		$( document ).on( 'change', '.bbapp-custom-link-field', function () {
			const self = $( this ),
				wrap = self.closest( '.menu-item-settings' ),
				checked = self.is( ':checked' ),
				itemId = wrap.find( '.menu-item-id' ).val(),
				preview = $( 'a[data-id="' + itemId + '"]' ),
				prevWarp = preview.closest( '.bbapp-more-section' );

			if ( checked ) {
				prevWarp.find( '.bbapp-external-link-svg' ).show();
			} else {
				prevWarp.find( '.bbapp-external-link-svg' ).hide();
			}
		} );
	} );
</script>
