<?php
/**
 * Holds header menu related admin functionality.
 *
 * @package BuddyBossApp\Admin\Menus
 */

use BuddyBossApp\Menu;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$headerbar_menu_data = \BuddyBossApp\Menus\MenuManager::instance()->get_menu( $nav_menu_selected_id );
$is_lite_app         = bbapp_is_lite_app();

$header_bar_position = ( ! empty( $headerbar_menu_data->data['title_position'] ) ) ? $headerbar_menu_data->data['title_position'] : 'left';
$more_menu_position  = ( ! empty( $headerbar_menu_data->data['more_menu_position'] ) ) ? $headerbar_menu_data->data['more_menu_position'] : 'tabbar';
$post_input_button   = ( ! empty( $headerbar_menu_data->data['post_input_field'] ) && ! $is_lite_app ) ? 1 : 0;

?>
<div id="bbapp-widgets">
	<div class="bbapp-widget-liquid">
		<div class="widgets-holder-wrap menu-settings bbapp-active">
			<div class="widgets-sortables">
				<div class="sidebar-name sidebar-name--menus" data-tab="menu-settings" data-add-to="Add to: <?php echo esc_html__( 'Header Bar Settings', 'buddyboss-app' ); ?>">
					<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
						<span class="screen-reader-text">
							<?php echo esc_html__( 'Header Bar Settings', 'buddyboss-app' ); ?>
						</span>
						<span class="toggle-indicator" aria-hidden="true"></span>
					</button>
					<h3 class="bbapp-widget-title">
						<?php echo esc_html__( 'Header Bar Settings', 'buddyboss-app' ); ?>
						<span class="spinner"></span>
					</h3>
				</div>
				<div class="bbapp-widget-content sidebar-description">
					<form id="bbapp-update-header-menu-setting" method="post">
						<?php wp_nonce_field( 'update-nav-appmenu-setting', 'update-nav-appmenu-setting-nonce' ); ?>
						<input type="hidden" name="action" value="app_menu_setting_save"/>
						<input type="hidden" name="appmenu_settings[headerbar]" value="<?php echo esc_attr( $nav_menu_selected_id ); ?>"/>
						<div class="bbapp-palette-flow bbapp-menu-settings">
							<div class="bbapp-menu-setting-list">
								<label for="header-bar-position">
									<span class="bbapp-menu-setting-label">
										<?php esc_html_e( 'Header position on Scroll', 'buddyboss-app' ); ?>
									</span>
									<select id="header-bar-position" name="appmenu_settings[title_position]" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>>
										<option value="left" <?php selected( $header_bar_position, 'left' ); ?>>
											<?php esc_html_e( 'Left', 'buddyboss-app' ); ?>
										</option>
										<option value="hidden" <?php selected( $header_bar_position, 'hidden' ); ?>>
											<?php esc_html_e( 'Hidden', 'buddyboss-app' ); ?>
										</option>
									</select>
								</label>
								<p class="description">
									<?php esc_html_e( 'Select the header position upon scrolling.', 'buddyboss-app' ); ?>
								</p>
							</div>
							<div class="bbapp-menu-setting-list">
								<label for="more-menu-position">
									<span class="bbapp-menu-setting-label">
										<?php esc_html_e( 'More Menu', 'buddyboss-app' ); ?>
									</span>
									<?php
									$more_menu_disabled = ( ! $menu_manager->has_more_menu_bar( 'more' ) || ! $menu_manager->can_more_menu_add() ) ? 'disabled' : '';
									?>
									<select id="more-menu-position"
											name="appmenu_settings[more_menu_position]"
										<?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>
											<?php disabled( true ); ?>
										<?php echo esc_attr( $more_menu_disabled ); ?>
											data-nonce="<?php echo esc_attr( wp_create_nonce( 'add-more-menu' ) ); ?>">
										<option value="tabbar" <?php selected( $more_menu_position, 'tabbar' ); ?>>
											<?php esc_html_e( 'Bottom Tab Bar', 'buddyboss-app' ); ?>
										</option>
										<option value="headerbar" <?php selected( $more_menu_position, 'headerbar' ); ?>>
											<?php esc_html_e( 'Top Header Bar', 'buddyboss-app' ); ?>
										</option>
									</select>
								</label>
								<p class="description">
									<?php esc_html_e( 'Select the position for more menu. It can be placed either in the tab bar or the header.', 'buddyboss-app' ); ?>
								</p>
							</div>
						</div>
						<input type="submit" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button button-primary menu-save" value="<?php esc_attr_e( 'Save Settings', 'buddyboss-app' ); ?>" name="save_menu_headerbar_setting" id="<?php echo esc_attr( 'save_appmenu_headerbar_setting' ); ?>"/>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php if ( defined( 'BP_PLATFORM_VERSION' ) && ! bbapp_is_lite_app() ) { ?>
	<div class="widgets-holder-wrap menu-settings bbapp-active">
		<div class="widgets-sortables">
			<div class="sidebar-name sidebar-name--menus" data-tab="menu-settings" data-add-to="Add to: <?php echo esc_html__( 'Activity Feed Setting', 'buddyboss-app' ); ?>">
				<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
						<span class="screen-reader-text">
							<?php echo esc_html__( 'Activity Feed Setting', 'buddyboss-app' ); ?>
						</span>
					<span class="toggle-indicator" aria-hidden="true"></span>
				</button>
				<h3 class="bbapp-widget-title">
					<?php echo esc_html__( 'Activity Feed Setting', 'buddyboss-app' ); ?>
					<span class="spinner"></span>
				</h3>
			</div>
			<div class="bbapp-widget-content sidebar-description">
				<form id="bbapp-update-header-menu-setting" method="post">
					<?php wp_nonce_field( 'update-nav-appmenu-setting', 'update-nav-appmenu-setting-nonce' ); ?>
					<input type="hidden" name="action" value="app_menu_setting_save"/>
					<input type="hidden" name="appmenu_settings[headerbar]" value="<?php echo esc_attr( $nav_menu_selected_id ); ?>"/>
					<div class="bbapp-palette-flow bbapp-menu-settings">
						<div class="bbapp-menu-setting-list">
							<label for="headermenu_post_button">
								<span class="bbapp-menu-setting-label">
									<?php esc_html_e( 'Post Input Field', 'buddyboss-app' ); ?>
								</span>
								<input <?php checked( $post_input_button, true ); ?> <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?>
										type="checkbox" name="appmenu_settings[post_input_button]"
										id="headermenu_post_button" value="1" <?php disabled( bbapp_is_lite_app() ); ?>>
								<?php esc_html_e( 'Enable the post area at the top.', 'buddyboss-app' ); ?>
							</label>
						</div>
					</div>
					<input type="submit" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button button-primary menu-save" value="<?php esc_attr_e( 'Save Settings', 'buddyboss-app' ); ?>" name="save_menu_headerbar_setting" id="<?php echo esc_attr( 'save_appmenu_headerbar_setting' ); ?>" <?php disabled( bbapp_is_lite_app() ); ?>/>
				</form>
			</div>
		</div>
	</div>
	<?php } ?>
</div>
