<?php
/**
 * Create Default Menu Structures
 *
 * This file is part of the BuddyBoss App.
 *
 * @since   2.4.10
 * @package BuddyBoss App
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

// Ensure menu_type_slug is properly sanitized and set to a default value if not set.
$menu_type_slug  = isset( $_GET['setting'] ) ? sanitize_key( $_GET['setting'] ) : 'tabbar'; // phpcs:ignore
$menu_type_label = bbapp_get_menu_type_label( $menu_type_slug );
$nonce           = wp_create_nonce( 'bbapp-create-default-menus' );
?>
<div class="manage-menus bbapp-manage-menus">
	<p><?php esc_html_e( 'No menu structures found. Would you like to create the default menu structures?', 'buddyboss-app' ); ?></p>
	<button 
		type="button" 
		id="create-default-menu-btn" 
		class="button button-primary" 
		data-menu-type="<?php echo esc_attr( $menu_type_slug ); ?>"
		data-nonce="<?php echo esc_attr( $nonce ); ?>"
	>
		<?php esc_html_e( 'Create Default Menu Structures', 'buddyboss-app' ); ?>
	</button>
	<span class="spinner"></span>
</div>


<script>
	jQuery( document ).ready( function () {
		// Disable form prompt without submitting by browser.
		jQuery( document ).on( 'click', function () {
			jQuery( window ).off( 'beforeunload' );
			window.onbeforeunload = null;
		} );

		// Handle create default menu button click
		jQuery( '#create-default-menu-btn' ).on( 'click', function ( e ) {
			e.preventDefault();

			var button = jQuery( this );

			// Disable button and show loading state
			button.prop( 'disabled', true );
			button.text( '<?php echo esc_js( __( 'Creating menus...', 'buddyboss-app' ) ); ?>' );

			// Make AJAX request to create default menus
			jQuery.ajax( {
				url: ajaxurl,
				type: 'POST',
				data: {
					action: 'bbapp_create_default_menus',
					login_state: 1,
					nonce: '<?php echo esc_js( $nonce ); ?>',
					lang: '<?php echo esc_js( $menu_manager->current_lang_code ); ?>',
				},
				success: function ( response ) {
					if ( response.success ) {
						// Show success message
						var notice = '<div class="notice notice-success is-dismissible"><p>' + response.data.message + '</p></div>';
						jQuery( '.wrap > h1' ).after( notice );

						// Reload the page to show the new menus
						setTimeout( function () {
							window.location.reload();
						}, 1000 );
					} else {
						// Show error message
						button.prop( 'disabled', false );
						button.text( '<?php echo esc_js( __( 'Create Default Menu Structures', 'buddyboss-app' ) ); ?>' );

						var notice = '<div class="notice notice-error is-dismissible"><p>' + response.data.message + '</p></div>';
						jQuery( '.wrap > h1' ).after( notice );
					}
				},
				error: function () {
					// Handle AJAX error
					button.prop( 'disabled', false );
					button.text( '<?php echo esc_js( __( 'Create Default Menu Structures', 'buddyboss-app' ) ); ?>' );

					var notice = '<div class="notice notice-error is-dismissible"><p>'+ '<?php echo esc_js( __( 'An error occurred while creating menus. Please try again.', 'buddyboss-app' ) ); ?>' +'</p></div > ';
					jQuery( '.wrap > h1' ).after( notice );
				}
			} );
		} );
	} );
</script>
