<?php
/**
 * Holds menu structure HTML.
 *
 * @package BuddyBossApp\Admin\Menus
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use BuddyBossApp\Admin\Menus;

global $one_theme_location_no_menus;

// Load all the nav menu interface functions.
require_once ABSPATH . 'wp-admin/includes/nav-menu.php';
$menu_manager      = BuddyBossApp\Menus\MenuManager::instance();
$tabbar_item_exist = $menu_manager->is_tabbar_item_exist();
$menu_type_slug    = Menus::instance()->get_current_sub_tab();
$screen_active     = $menu_type_slug; // loading preview.
$menu_type_label   = bbapp_get_menu_type_label( $menu_type_slug );

// Are we on the add new screen?
$add_new_screen = false;
$action_get     = isset( $_GET['action'] ) ? bbapp_input_clean( wp_unslash( $_GET['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

// Check specifically for 'create' action rather than menu=0 and action=edit to avoid confusion with the menu list.
if ( 'create' === $action_get ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
	$add_new_screen = true;
	global $nav_menu_selected_id;
}

// this condition uses for existing menus.
$default_menu_id = $menu_manager->get_default_menu_id( $menu_type_slug );

// Set menu ID to '0' when in create mode or if no menu is selected.
if ( $add_new_screen || 'create' === $action_get ) {
	$nav_menu_selected_id = '0'; //phpcs:ignore
} else {
	$nav_menu_selected_id = ! empty( $_REQUEST['menu'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['menu'] ) ) : $default_menu_id; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.WP.GlobalVariablesOverride.Prohibited
}
$metabox_holder_disabled_class = ( $add_new_screen ) ? ' metabox-holder-disabled' : '';
$default_more_menu_id          = $menu_manager->get_default_menu_id( 'more' );

$menu_items_args = array(
	'has_items' => array(
		'parent_id'           => 0,
		'has_more_menu_items' => $default_more_menu_id,
	),
);
$main_menu       = $menu_manager->get_menu( $nav_menu_selected_id, $menu_items_args );
$page_count      = wp_count_posts( 'page' );

/*
 * If we have one theme location, and zero menus, we take them right
 * into editing their first menu.
 */
if ( ! $add_new_screen && empty( $main_menu ) && ! empty( $page_count->publish ) ) {
	$one_theme_location_no_menus = true; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
} else {
	$one_theme_location_no_menus = false; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
}

// Load side tab items.
do_action( 'bbapp_render_menu_metabox' );

// Load SVG for Preview Tab Bar.
require bbapp()->plugin_dir . 'views/preview/common/tabbar-svg-loader.php';

Menus\Menus::instance()->load_header_script();

$notice_url   = 'javascript:void(0);';
$notice_class = 'bbapp-add-setting-menu';

if ( 'more' !== $menu_type_slug ) {
	$notice_url   = admin_url( 'admin.php?page=bbapp-menus&setting=more&add_menu=settings' );
	$notice_class = 'bbapp-add-setting-menu-tabbar';
}

$headerbar_menu_id = $menu_manager->get_headerbar_menu_from_tabbar_id( $main_menu );

// We're on the Tab Bar page but no menus exist.
if ( 'tabbar' === $menu_type_slug && empty( $main_menu ) && ! $add_new_screen ) {
	require bbapp()->plugin_dir . '/views/menus/sections/create-default-menu.php';
} elseif ( $headerbar_menu_id === $nav_menu_selected_id && 'tabbar' !== $menu_type_slug && ! $menu_manager->get_default_menu_id( 'tabbar' ) ) {
	require bbapp()->plugin_dir . '/views/menus/sections/create-default-menu.php';
} elseif ( 'headerbar' === $menu_type_slug && ! $tabbar_item_exist ) {
	require bbapp()->plugin_dir . '/views/menus/sections/no-menu-items-found.php';
} else {
	?>
	<div id="nav-menus-frame" class="nav-menus-php nav-appmenus-frame">
		<div id="menu-settings-column"
			class="metabox-holder appmenu-settings-column <?php echo esc_attr( $metabox_holder_disabled_class ); ?>">
			<div class="clear"></div>
			<!-- Load menu settings. -->
			<?php if ( 'tabbar' === $menu_type_slug ) { ?>
				<?php require bbapp()->plugin_dir . '/views/menus/sections/settings.php'; ?>
			<?php } ?>
			<?php if ( 'headerbar' === $menu_type_slug ) { ?>
				<?php require bbapp()->plugin_dir . '/views/menus/sections/headerbar-settings.php'; ?>
			<?php } ?>
			<div class="clear"></div>
			<!-- Load menu priority. -->
			<?php if ( '0' !== $nav_menu_selected_id && $menu_manager->is_custom_menu_exists( $menu_type_slug ) ) { ?>
				<?php include bbapp()->plugin_dir . '/views/menus/sections/priority.php'; ?>
				<div class="clear"></div>
			<?php } ?>
			<!-- Load menu tab items. -->
			<?php
			require bbapp()->plugin_dir . '/views/menus/sections/tab-items.php';
			require bbapp()->plugin_dir . 'views/preview/common/styles.php';
			?>
		</div><!-- /#menu-settings-column -->
		<div id="menu-management-liquid">
			<div id="menu-management" class="bbapp_branding_fields appmenu-management">
				<div class="appmenu-management__panels flex">
					<div id="bbapp-tab-bar-left-section" class="appmenu-management__menu">
						<div class="bbapp-menu-top flex">
							<h2>
								<?php esc_html_e( 'Menu structure', 'buddyboss-app' ); ?>
							</h2>
							<?php
							$menu_tutorial_link = $menu_manager->get_menu_tutorial_link( $menu_type_slug );
							?>
							<a href="<?php echo esc_url( $menu_tutorial_link ); ?>" class="button view_tutorial"
								target="_blank">
								<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
							</a>
						</div>
						<?php

						if ( '0' !== $nav_menu_selected_id ) {
							include bbapp()->plugin_dir . '/views/menus/sections/manage-menu.php';
						}
						require bbapp()->plugin_dir . '/views/menus/sections/menu-list.php';
						?>
					</div>
					<!-- Load mobile preview. -->
					<?php if ( ! $add_new_screen ) { ?>
						<?php include bbapp()->plugin_dir . '/views/menus/sections/preview.php'; ?>
					<?php } ?>
				</div>
				<!-- /#update-nav-menu -->
			</div><!-- /#menu-management -->
		</div><!-- /#menu-management-liquid -->
	</div>
	<?php
}
?>
<script>
	jQuery( document ).ready( function () {
		<?php if ( false === $menu_manager->setting_menu_exists( $nav_menu_selected_id ) ) { ?>
		jQuery( '.bbapp-setting-menu-notice' ).show();
		<?php } ?>
	} );
</script>

