<?php
/**
 * Holds new BuddyBoss icons.
 *
 * @package BuddyBossApp\Common
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
global $pagenow;
wp_enqueue_style( 'bbapp_croppie' );
wp_enqueue_script( 'bbapp_croppie' );
$menu_screen_class = isset( $_GET['menu'] ) ? sanitize_text_field( wp_unslash( $_GET['menu'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$menu_screen       = bbapp_get_menu_type();
$bg_default_color  = '';

if ( 'post.php' !== $pagenow ) {
	if ( 'tabbar' === $menu_screen ) {
		$bg_default_color = bbapp_get_default_color( 'bottomTabsBg' );
	} elseif ( 'more' === $menu_screen ) {
		$bg_default_color = bbapp_get_default_color( 'bodyFrontBg' );
	}
}
?>

<div id="bbapp_icon_tabs" class="supports-drag-drop <?php echo esc_attr( $menu_screen_class ); ?>-menu-screen" style="display: none; position: relative;">
	<div tabindex="0" class="media-modal wp-core-ui">
		<button type="button" id="bbapp_icon_modal_close" class="media-modal-close">
			<span class="media-modal-icon">
				<span class="screen-reader-text"><?php esc_html_e( 'Close', 'buddyboss-app' ); ?></span>
			</span>
		</button>
		<div class="media-modal-content">
			<div class="bbapp-modal-box__header">
				<ul class="tabs">
					<li class="tab-link bbapp-tab-1 current" data-tab="tab-1">
						<?php esc_html_e( 'Icons', 'buddyboss-app' ); ?>
					</li>
					<li class="tab-link bbapp-tab-2" data-tab="tab-2">
						<?php esc_html_e( 'Custom', 'buddyboss-app' ); ?>
					</li>
				</ul>
			</div>
			<div class="bbapp-modal-box__body">
				<div id="tab-1" class="tab-content bbapp-tab-1-content current">
					<div id="bbapp-icon-left-section">
						<div class="bbapp-dialog-icon-picker" data-id="">
							<div class="bbapp-icon-filters">
								<div class="bbapp-icon-legacy-filter bbapp-icon-filters-cmn">
									<select class="bbapp-icon-legacy-filter-select">
										<option value="buddyboss"><?php esc_html_e( 'BuddyBoss', 'buddybos-app' ); ?></option>
										<option value="legacy"><?php esc_html_e( 'Legacy', 'buddybos-app' ); ?></option>
									</select>
								</div>
								<div class="bbapp-icon-category-filter bbapp-icon-filters-cmn">
									<?php $this->render_category_dropdown(); ?>
								</div>
								<div class="bbapp-icon-search bbapp-icon-filters-cmn">
									<i class="bb-icon-i bb-icon-search"></i>
									<input class="bbapp-icon-search-input medium-text" type="text" name="s" placeholder="<?php echo esc_attr__( 'Search Icons', 'buddyboss-app' ); ?>" value="">
								</div>
							</div>
							<?php require bbapp()->plugin_dir . 'views/icon-picker/bb-icons.php'; ?>
							<?php require bbapp()->plugin_dir . 'views/icon-picker/legacy.php'; ?>
						</div>
					</div>
					<div id="bbapp-icon-right-section">
						<?php require bbapp()->plugin_dir . 'views/icon-picker/bb-icons-settings.php'; ?>
						<?php require bbapp()->plugin_dir . 'views/icon-picker/legacy-settings.php'; ?>
					</div>
				</div>
				<div id="tab-2" class="tab-content bbapp-tab-2-content">
					<?php require bbapp()->plugin_dir . 'views/icon-picker/custom-icons.php'; ?>
				</div>
			</div>
			<div class="bbapp-modal-box__footer">
				<div class="bbapp-icon-delete">
					<input type="hidden" name="bbapp-delete-nonce" id="bbapp-delete-nonce" value="<?php echo esc_attr( wp_create_nonce( 'bbapp-delete-custom-icon' ) ); ?>">
					<button class="button button-link button-link-delete bbapp-delete-icon" id="bbapp-delete-icon" style="display: none;">
						<div class="bbapp_loading bbapp-delete-icon-loader" style="display: none;"></div>
						<?php echo esc_html__( 'Delete Icon', 'buddyboss-app' ); ?>
					</button>
					<div class="bbapp-message-box"></div>
				</div>
				<div class="icon-action">
					<div class="bbapp_loading icon-loader" style="display: none;"></div>
					<input type="submit" id="icon-picker-saved" name="save_icon_picker" class="button-primary bbapp_select_icon" value="<?php echo esc_html__( 'Select Icon', 'buddyboss-app' ); ?>">
				</div>
			</div>
		</div>
	</div>
	<div class="media-modal-backdrop"></div>
</div>
<div class="bbapp-icon-picker-preview-filed-data"></div>
<script type="text/html" id="tmpl-buddyboss-app-icon-data">
	<input type="hidden" class="bbapp_icon_preview_data" name="bbapp_icon_preview_data" value='{{JSON.stringify(data)}}'>
</script>
