<?php
/**
 * Holds old icons settings.
 *
 * @package BuddyBossApp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

?>
<div class="bbapp-legacy-icon-settings bbapp-hide">
	<div class="bbapp-icon-preview-box">
		<div class="bbapp-icon-picker-message-box"><p><?php echo esc_html__( 'Select an icon to configure its appearance.', 'buddyboss-app' ); ?></p></div>
		<div class="bbapp-icon-picker-preview-box"></div>
		<div class="bbapp-icon-picker-settings-box"></div>
	</div>
	<script type="text/html" id="tmpl-buddyboss-app-icon-quick-link-preview">
		<div class="bbapp-dialog-icon-picker" data-id="">
			<div id="bbapp_icon_preview">
				<h3>
					<# if ( data.menu_name ) { #>
					{{{data.menu_name}}}
					<# } else { #>
					<?php esc_html_e( 'Selected Icon', 'buddyboss-app' ); ?>
					<# } #>
				</h3>
				<div class="bbapp_icon_picker_preview">
					<a class="icon-picker-preview" href="javascript:void(0)" data-value="{{{data.icon_value}}}">
						<img style="filter: url(#bbapp-icon-preview)" src="{{{data.img_url}}}"/>
					</a>
					<input type="hidden" class="bbapp_icon_preview_icon_value" name="bbapp_icon_preview_icon_value" value='{{{data.icon_value}}}'>
				</div>
			</div>
		</div>
	</script>
	<script type="text/html" id="tmpl-buddyboss-app-legacy-icon-picker-preview">
		<h3><?php esc_html_e( 'Preview', 'buddyboss-app' ); ?></h3>
		<div class="bbapp_icon_picker_preview">
			<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
			<# let color = 'default' !== data.color ? data.color :defaultColor #>
			<# var box_style = ('box' === data.box_style) ? "background:"+color : "background:<?php echo esc_attr( $bg_default_color ); ?>" #>
			<# var svg_fill_color = ('box' === data.box_style) ? '#fff' : color #>

			<div class="icon-picker-preview" style="{{box_style}}">
				<img style="filter: url(#bbapp-icon-preview)" src="{{data.extra.img_url}}">
				<# if( true === data.fill_color ){ #>
				<svg id="bbapp-icon-preview-svg" class="" style="position: absolute; height: 0; visibility: hidden; width: 0;">
					<defs>
						<filter id="bbapp-icon-preview">
							<feFlood flood-color="{{svg_fill_color}}"></feFlood>
							<feComposite in2="SourceAlpha" operator="atop"></feComposite>
						</filter>
					</defs>
				</svg>
				<# } #>
			</div>

		</div>
	</script>
	<script type="text/html" id="tmpl-buddyboss-app-legacy-icon-picker-setting">
		<div class="bbapp-icon-settings">
			<h3><?php esc_html_e( 'Icon Settings', 'buddyboss-app' ); ?></h3>
			<form id="bbapp-monochrome-settings">
				<div id="bbapp-icon-monochrome-select-wrap">
					<label for="bbapp-icon-style">
						<?php esc_html_e( 'Icon Style', 'buddyboss-app' ); ?>
					</label>
					<# var current_menu_bar = bbappCore.helper.bbapp_get_url_parameter('setting'); #>
					<# if( 'undefined' === typeof current_menu_bar ) { #>
					<# current_menu_bar = 'tabbar'; #>
					<# } #>

					<select name="bbapp-icon-style-option">
						<option value="<?php esc_attr_e( 'lined', 'buddyboss-app' ); ?>" <# if( 'lined' === data.style && '' === data.box_style ){ #> selected <# } #> >
						<?php esc_html_e( 'Outlined', 'buddyboss-app' ); ?>
						</option>
						<option value="<?php esc_attr_e( 'filled', 'buddyboss-app' ); ?>" <# if( 'filled' === data.style ){ #> selected <# } #> >
						<?php esc_html_e( 'Filled', 'buddyboss-app' ); ?>
						</option>
						<# if( 'more' === current_menu_bar ) { #>
						<option value="<?php esc_attr_e( 'boxed', 'buddyboss-app' ); ?>" <# if( 'lined' === data.style && 'box' === data.box_style ){ #> selected <# } #> >
						<?php esc_html_e( 'Boxed', 'buddyboss-app' ); ?>
						</option>
						<# } #>
					</select>
				</div>
				<div id="bbapp-icon-color-select-wrap">
					<label for="bbapp-icon-color">
						<?php esc_html_e( 'Icon Color', 'buddyboss-app' ); ?>
					</label>
					<select name="bbapp-icon-color-option">
						<option value="<?php esc_attr_e( 'default', 'buddyboss-app' ); ?>" <# if( 'default' === data.color ){ #> selected <# } #>>
						<?php esc_html_e( 'Default', 'buddyboss-app' ); ?>
						</option>
						<option value="<?php esc_attr_e( 'custom', 'buddyboss-app' ); ?>" <# if( 'default' !== data.color  ){ #> selected <# } #> >
						<?php esc_html_e( 'Custom', 'buddyboss-app' ); ?>
						</option>
					</select>
				</div>
				<# if ( 'default' === data.color ) { #>
				<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
				<div id="bbapp-icon-monochrome-color-picker-wrap-default">
					<label>
						<input type="text" value="{{defaultColor}}" name="bbapp-icon-monochrome-color-default" class="bbapp-icon-monochrome-color-default"/>
					</label>
				</div>
				<# } #>
				<# if ( 'default' !== data.color ) { #>
				<div id="bbapp-icon-monochrome-color-picker-wrap">
					<label>
						<input type="text" value="{{data.color}}" name="bbapp-icon-monochrome-color" class="bbapp-icon-monochrome-color"/>
					</label>
				</div>
				<# } #>
			</form>
		</div>
	</script>
</div>
