<?php
/**
 * Holds new BuddyBoss custom icons.
 *
 * @package BuddyBossApp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

?>
<div class="bbapp-icon-uploader-main">
	<ul class="bbapp-tabs-uploader">
		<li class="tab-link bbapp-tab-upload-icon current" data-tab="bbapp-tab-upload-icon"><?php esc_html_e( 'Upload Icon', 'buddyboss-app' ); ?></li>
		<li class="tab-link bbapp-tab-uploaded" data-tab="bbapp-tab-uploaded"><?php esc_html_e( 'Uploaded', 'buddyboss-app' ); ?></li>
	</ul>
	<div id="bbapp-tab-upload-icon" class="tab-uploader-content bbapp-tab-upload-icon-content bbapp_custom_icons current">
		<div id="bbapp-icon-left-section">
			<div class="bbapp_icon_uploader">
				<h2><?php esc_html_e( 'Add file to upload', 'buddyboss-app' ); ?></h2>
				<!--Upload Code Start-->
				<div class="icons custom_icons">

					<div class="bbapp_icon_preview" style="display: none">
						<span><?php esc_html_e( 'Crop & Adjust', 'buddyboss-app' ); ?></span>
						<div class="inner"></div>
						<span class="cr-percentage"></span>
						<span class="loading" style="display:none"><?php esc_html_e( 'Uploading...', 'buddyboss-app' ); ?></span>
						<a href="#" class="done"><?php esc_html_e( 'Done', 'buddyboss-app' ); ?></a>
					</div>

				</div>
				<div class="bbapp-icon-file-upload button button-hero">
					<span><?php esc_html_e( 'Upload Icon', 'buddyboss-app' ); ?></span>
					<input type="hidden" name="bbapp-upload-nonce" id="bbapp-upload-nonce" value="<?php echo esc_attr( wp_create_nonce( 'bbapp-upload-custom-icon' ) ); ?>">
					<input type="file" name="bbapp_custom_icon_upload" class="bbapp_custom_icon_upload" value="<?php esc_attr_e( 'Upload Icon', 'buddyboss-app' ); ?>"/>
				</div>
				<!--Upload Code End-->
				<p class="bbapp_icon_description"><?php esc_attr_e( 'For best results upload an image greater than 200px in size.', 'buddyboss-app' ); ?></p>
			</div>
		</div>
		<div id="bbapp-icon-right-section">
		</div>
	</div>
	<div id="bbapp-tab-uploaded" class="tab-uploader-content bbapp-tab-uploaded-content bbapp_custom_icons">
		<div id="bbapp-icon-left-section">
			<div class="bbapp-dialog-icon-picker" data-id="">
				<div class="bbapp-custom-icons-list icons">
					<?php
					$custom_icons      = $this->icon_picker_custom_icon_list();
					$custom_icons_path = $this->icon_picker_custom_icon_url();
					foreach ( $custom_icons as $icon ) {
						$icon_path = str_replace( 'custom/', '', $icon ); // Strip the identifier.
						echo sprintf( '<a href="javascript:void(0);" class="bbapp-icon custom" data-value="%1$s"><img src="%2$s.png"/><span class="bbapp-icon-title"><span>%3$s</span></span></a>', esc_attr( $icon ), esc_url( $custom_icons_path . '/' . $icon_path ), esc_html__( 'Custom', 'buddyboss-app' ) );
					}
					?>
				</div>
			</div>
		</div>
		<div id="bbapp-icon-right-section" class="bbapp_icon_picker">
			<div class="bbapp-custom-icon-preview-box">
				<div class="bbapp-custom-icon-picker-message-box"><p><?php echo esc_html__( 'Select an icon to configure its appearance.', 'buddyboss-app' ); ?></p></div>
				<div class="bbapp-custom-icon-picker-preview-box"></div>
				<div class="bbapp-custom-icon-picker-settings-box"></div>
			</div>
		</div>
	</div>
</div>
<script type="text/html" id="tmpl-bbapp-custom-icon-picker-preview">
	<div class="bbapp-dialog-icon-picker">
		<div id="bbapp_icon_preview">
			<h3><?php echo esc_html__( 'Preview', 'buddyboss-app' ); ?></h3>
			<div class="bbapp_custom_icon_picker_preview">
				<div class="icon-picker-preview" style="background:<?php echo esc_attr( $bg_default_color ); ?>">
					<img style="filter: url(#bbapp-custom-icon-preview)" src="{{data.extra.img_url}}">
					<# if( true === data.fill_color ){ #>
					<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
					<# let color = '' !== data.color ? data.color :defaultColor #>
					<svg id="bbapp-custom-icon-preview-svg" class="" style="position: absolute; height: 0; visibility: hidden; width: 0;">
						<defs>
							<filter id="bbapp-custom-icon-preview">
								<feFlood flood-color="{{color}}"></feFlood>
								<feComposite in2="SourceAlpha" operator="atop"></feComposite>
							</filter>
						</defs>
					</svg>
					<# } #>
				</div>
			</div>
		</div>
	</div>
</script>
<script type="text/html" id="tmpl-bbapp-custom-icon-picker-setting">
	<div class="bbapp-icon-settings">
		<h3><?php echo esc_html__( 'Icon color', 'buddyboss-app' ); ?></h3>
		<div id="bbapp-icon-monochrome-checkbox-wrap">
			<label for="bbapp-custom-icon-color-checkbox">
				<input type="checkbox" class="bbapp-custom-icon-color-checkbox" id="bbapp-custom-icon-color-checkbox" name="bbapp-custom-icon-color-checkbox" value="yes" <# if( true === data.fill_color  ){ #> checked <# }  #>>
				<span class="bbapp-icon-monochrome-label">
					<?php echo esc_html__( 'Change the icon\'s color', 'buddyboss-app' ); ?>
				</span>
			</label>
		</div>
		<# if( true === data.fill_color  ){ #>
		<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
		<# let color = '' !== data.color ? data.color :defaultColor #>
		<label><input type="text" value="{{color}}" name="bbapp-custom-icon-monochrome-color" class="bbapp-custom-icon-monochrome-color"/></label>
		<# }  #>
	</div>
	<div class="bbapp-icon-message-section">
		<span class="bbapp-monochrome-custom-message">
			<?php echo esc_html__( 'For best result, only change the color of icons made up of a single color and a transparent background.', 'buddyboss-app' ); ?>
		</span>
	</div>
</script>
