<?php
/**
 * Holds new BuddyBoss icons settings.
 *
 * @package BuddyBossApp
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
$is_tabbar = ! ( ! empty( $_GET['setting'] ) && 'tabbar' !== sanitize_text_field( wp_unslash( $_GET['setting'] ) ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
?>
<div class="bbapp-icon-settings-right">
	<div class="bbapp-new-icon-preview-box">
		<div class="bbapp-new-icon-icon-picker-message-box">
			<p><?php echo esc_html__( 'Select an icon to configure its appearance.', 'buddyboss-app' ); ?></p>
		</div>
		<div class="bbapp-new-icon-picker-preview-box"></div>
		<div class="bbapp-new-icon-picker-settings-box"></div>
		<?php
		if ( true === $is_tabbar ) {
			echo sprintf( '<div class="bbapp-new-icon-icon-picker-tip-message-box"><p><strong>%1$s</strong> %2$s</p></div>', esc_html__( 'Tip:', 'buddyboss-app' ), esc_html__( 'If you select lined, the icon will be dynamically changed to filled when the menu item is active.', 'buddyboss-app' ) );
		}
		?>
	</div>
	<script type="text/html" id="tmpl-buddyboss-app-new-icon-preview">
		<div class="bbapp-dialog-icon-picker">
			<div id="bbapp_icon_preview">
				<h3><?php esc_html_e( 'Preview', 'buddyboss-app' ); ?></h3>
				<#
				var iconStyle = ( 'filled' === data.style ) ? 'f' : 'l';
				var iconBoxStyle = ''

				if( 'box' === data.box_style ){
				iconBoxStyle = 'b';
				} else if( 'round' === data.box_style ){
				iconBoxStyle = 'r';
				}

				iconApplyStyle = iconBoxStyle+iconStyle;
				#>
				<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
				<# let color = 'default' !== data.color ? data.color :defaultColor #>
				<# let foreground_color_style = ''; #>
				<# if( 'filled' === data.style && ( 'box' === data.box_style || 'round' === data.box_style ) ) { #>
				<# foreground_color_style = "background: "+data.fg_color+"; border-radius: 50%;" #>
				<# } #>
				<div class="bbapp_icon_picker_preview">
					<div class="icon-picker-preview" style="background:<?php echo esc_attr( $bg_default_color ); ?>">
						<i class='bb-icon-{{iconApplyStyle}} bb-icon-{{data.id}}' style="color:{{color}};{{foreground_color_style}}"></i>
					</div>
				</div>
			</div>
		</div>
	</script>
	<script type="text/html" id="tmpl-buddyboss-app-new-icon-settings">
		<div class="bbapp-dialog-icon-picker">
			<div id="bbapp_icon_preview">
				<h3><?php esc_html_e( 'Icon Settings', 'buddyboss-app' ); ?></h3>
				<div class="bbapp-new-icon-style-wrp">
					<label for="bbapp-new-icon-style">
						<?php esc_html_e( 'Icon Style', 'buddyboss-app' ); ?>
					</label>
					<select id="bbapp-new-icon-style" class="bbapp-new-icon-style">
						<option value="lined"
						<# if( 'lined' === data.style ){ #> selected <# } #>>
						<?php esc_html_e( 'Outlined', 'buddyboss-app' ); ?>
						</option>
						<option value="filled"
						<# if( 'filled' === data.style ){ #> selected <# } #>>
						<?php esc_html_e( 'Filled', 'buddyboss-app' ); ?>
						</option>
					</select>
				</div>
				<div class="bbapp-new-icon-box-style-wrp">
					<label for="bbapp-new-icon-box-style">
						<?php esc_html_e( 'Box Style', 'buddyboss-app' ); ?>
					</label>
					<select id="bbapp-new-icon-box-style" class="bbapp-new-icon-box-style">
						<option value=""
						<# if( '' === data.box_style ){ #> selected <# } #>>
						<?php esc_html_e( 'None', 'buddyboss-app' ); ?>
						</option>
						<option value="box"
						<# if( 'box' === data.box_style ){ #> selected <# } #>>
						<?php esc_html_e( 'Boxed', 'buddyboss-app' ); ?>
						</option>
						<option value="round"
						<# if( 'round' === data.box_style ){ #> selected <# } #>>
						<?php esc_html_e( 'Rounded', 'buddyboss-app' ); ?>
						</option>
					</select>
				</div>
				<div class="bbapp-new-icon-color-wrp">
					<label for="bbapp-new-icon-color">
						<# if( 'filled' === data.style && ( 'box' === data.box_style || 'round' === data.box_style ) ) { #>
						<?php esc_html_e( 'Background Color', 'buddyboss-app' ); ?>
						<# } else { #>
						<?php esc_html_e( 'Icon Color', 'buddyboss-app' ); ?>
						<# } #>
					</label>
					<select id="bbapp-new-icon-color" class="bbapp-new-icon-color">
						<option value="default"
						<# if( 'default' === data.color ){ #> selected <# } #>>
						<?php esc_html_e( 'Default', 'buddyboss-app' ); ?>
						</option>
						<option value="custom"
						<# if( 'default' !== data.color ){ #> selected <# } #>>
						<?php esc_html_e( 'Custom', 'buddyboss-app' ); ?>
						</option>
					</select>
					<# if ( 'default' === data.color ) { #>
					<# let defaultColor = bbappCore.helper.bbapp_get_default_icon_color() #>
					<div id="bbapp-icon-new-monochrome-color-picker-wrap-default">
						<label>
							<input type="text" value="{{defaultColor}}" name="bbapp-icon-new-monochrome-color-default" class="bbapp-icon-new-default-icon-picker"/>
						</label>
					</div>
					<# }
					if ( 'default' !== data.color ) { #>
					<div id="bbapp-icon-new-monochrome-color-picker-wrap">
						<label>
							<input type="text" value="{{data.color}}" name="bbapp-icon-new-monochrome-color" class="bbapp-icon-new-monochrome-color"/>
						</label>
					</div>
					<# } #>
				</div>
				<# if( 'filled' === data.style && ( 'box' === data.box_style || 'round' === data.box_style ) ) { #>
				<div class="bbapp-new-icon-fg-color-wrp">
					<label for="bbapp-new-icon-fg-color">
						<?php esc_html_e( 'Foreground Color', 'buddyboss-app' ); ?>
					</label>
					<select id="bbapp-new-icon-fg-color" class="bbapp-new-icon-fg-color">
						<option value="transparent" <# if( 'transparent' === data.fg_color ){ #> selected <# } #> >
							<?php esc_html_e( 'Transparent', 'buddyboss-app' ); ?>
						</option>
						<option value="custom" <# if( 'transparent' !== data.fg_color ){ #> selected <# } #> >
							<?php esc_html_e( 'Custom', 'buddyboss-app' ); ?>
						</option>
					</select>
					<# if ( 'transparent' !== data.fg_color ) { #>
					<div id="bbapp-icon-new-foreground-color-picker-wrap">
						<label>
							<input type="text" value="{{data.fg_color}}" name="bbapp-icon-new-foreground-color" class="bbapp-icon-new-foreground-color"/>
						</label>
					</div>
					<# } #>
				</div>
				<# } #>
			</div>
		</div>
	</script>
</div>
